#pragma once
#include <ctime>
#include "UnitManager.h"
#include "Arbitrator.h"
#include "BuildingPlacer.h"
#include "MapInformationSystem.h"
#include "PvTAlpha.h"
#include "PvTBeta.h"
#include "PvTGamma.h"
#include "PvPAlpha.h"
#include "PvPBeta.h"
#include "PvZAlpha.h"
#include "PvZBeta.h"
#include "PvZGamma.h"
#include "PvPGamma.h"
#include "PvPDelta.h"
/*#include "InformationManager.h"*/
#include "GroundScoutBehaviour.h"
#include "UnitPredictionManager.h"
#include "ArmyStructureInferenceManager.h"
#include "OffenseMonitor.h"
#include "DefenseMonitor.h"
#include "PastPerformanceManager.h"

class BaseModel;
class BuildOrderTemplate;

class Overseer {
public:
	Overseer();
	void initialize();
	void update();
	UnitManager* getUnitManager();
	Arbitrator* getArbitrator();
	ArmyStructureInferenceManager* getArmyStructureManager();
	BuildingPlacer* getBuildingPlacer();

	bool canReserveResources(int mineralAmount, int gasAmount);
	std::pair<int,int> getAvailableResources();
	void reserveResources(int mineralAmount, int gasAmount);
	void relinquishResources(int mineralAmount, int gasAmount);
	void testGrabArmy();
	void testGrabScout();
	void testUnitPrediction();
	void testArmyStructureInference();
	void testArmyMovement();
	void testPathing();
	void manageSupply();
	void manageMinNumWorkers();
	int getNewTaskID();
	void testTargetting();
	void registerTask(TaskBase* t);
	bool isTaskRegisteredFor(UnitType t);
	TaskBase* getTaskFromMap(int id);
	int getTopTaskID();
	void flushMemoryBanks();
	OffenseMonitor* getOffenseMonitor();
	PastPerformanceManager* getScoreManager();
	int getCurrentHighLevelStrat();
	void compileStrategy();
	bool isInitialized();	
	/*InformationManager* getInformationManager();*/


private:
	UnitManager* unitManager;
	Arbitrator* arbitrator;
	BuildingPlacer* buildingPlacer;
	std::pair<int,int> effectiveResources;
	std::pair<int,int> reservedResources;
	/*InformationManager* im;*/
	UnitPredictionManager* upred;
	ArmyStructureInferenceManager* asi;
	bool initialized;
	bool just_initialized;
	bool unitsOnly;
	OffenseMonitor* om;
	DefenseMonitor* dm;
	int curTaskID;
	std::map<int, TaskBase*> taskMap;
	std::vector<std::vector<TilePosition>> testPaths;
	PastPerformanceManager* scoreManager;
	int curStratID;

protected:


};