#pragma once
#include "BWAPI.h"
#include "BWTA.h"
#include "TargetEvaluator.h"
#include "InformationCell.h"

class Overseer;
class Army;

class OffenseMonitor {
public:
	OffenseMonitor(Overseer* ov);
	void evaluate();
	bool reccomend();
	Army* getTheoreticalArmy();
	BWTA::Region* reccomendWeakestTarget();
	bool regionsAreAdjacent(BWTA::Region* a, BWTA::Region* b);
	bool isRegionUnderAttack(BWTA::Region* r);
	void registerTarget(Army* a, BWTA::Region* r);
	std::set<BWTA::Region*> getConnectedRegions(BWTA::Region* a);
	void enable();
	void disable();


private:
	Overseer* overseer;
	TargetEvaluator* targetEval;
	int reccomendationMemory[20];
	int memChunk;
	bool attacking;
	std::map<BWTA::Region*, Army*> battleMap;
	int baseSquadSize;
	int MIN_FORCE_SIZE;
	Army* knownMainForce;

	bool enabled;

protected:
};