#pragma once
#include "BWAPI.h"
#include "BWTA.h"

#include "UnitManager.h"

using namespace BWAPI;
using namespace BWTA;

class UnitModel;

class NudgeModule {
public:
	NudgeModule( UnitModel* sub , UnitManager* u);
	virtual bool execute();
	virtual void nudge();
		virtual void permnudge();
	BWAPI::Position bestPointClosestTo(BWAPI::Position p, int r);
	bool isBeingNudged();
	void setNudgeAbility(bool a);
	bool getNudgeAbility();
private:
	BWAPI::Position targetPosition;
	UnitManager* unitManager;
	UnitModel* subject;
	Position nudgeTarget;
	Position preNudgePos;
	bool movingToNudgeTarget;
	bool movingToPreNudgeTarget;
	int bubbleClearance;

	bool ableToNudge;

protected:


};