#include "MapInformationSystem.h"
#include "UnitManager.h"


MapInformationSystem::MapInformationSystem(UnitManager* uman)
{
	unitManager = uman;
}


//************************************
// Method:    initialize
// FullName:  MapInformationSystem::initialize
// Access:    public 
// Returns:   void
// Comments:  none
//************************************
void MapInformationSystem::initialize()
{
	/*
	So what are the statically interesting things we might want to keep tabs on?
	For a kick off... base locations!
	*/
	float baseBaseLocImportance = 1.3;
	float baseChokePointLocImportance = 0.8;
	float startPositionLocImportance = 2.5;
	float startPositionNaturalExpansionImportance = 1.5; // todo

	std::set<BWTA::BaseLocation*> bases = BWTA::getBaseLocations();
	for (std::set<BWTA::BaseLocation*>::iterator i = bases.begin(); i != bases.end(); ++i)
	{
		BaseLocation* cur = *i;
		if(cur->isStartLocation()) {
			mapCells.push_back(new InformationCell(cur->getPosition().x(), cur->getPosition().y(), 128, startPositionLocImportance, unitManager, cur));
		} else {
			mapCells.push_back(new InformationCell(cur->getPosition().x(), cur->getPosition().y(), 128, baseBaseLocImportance, unitManager, cur));
		}
	}


	/*
	What also about choke points?
	*/
	std::set<Chokepoint*> chokes = BWTA::getChokepoints();
	for (std::set<Chokepoint*>::iterator i = chokes.begin(); i != chokes.end(); ++i)
	{
		Chokepoint* cur = *i;
		mapCells.push_back(new InformationCell(cur->getCenter().x(), cur->getCenter().y(), 128, baseChokePointLocImportance, unitManager, NULL));
	}
}

void MapInformationSystem::update()
{
	if(Broodwar->getFrameCount()%32 == 0) {
		for (vector<InformationCell*>::iterator i = mapCells.begin(); i != mapCells.end(); ++i)
		{
			InformationCell* curCell = *i;
			curCell->updateInformationValue();		
		}
	}
}

void MapInformationSystem::drawMap()
{
	for (vector<InformationCell*>::iterator i = mapCells.begin(); i != mapCells.end(); ++i)
	{
		InformationCell* curCell = *i;
		//Broodwar->drawTextMap(curCell->getPosition().x(), curCell->getPosition().y()-64, "importance: %f", curCell->getImportance());
		//Broodwar->drawTextMap(curCell->getPosition().x(), curCell->getPosition().y()+32, "%f", curCell->getInformationValue());
		//Broodwar->drawTextMap(curCell->getPosition().x(), curCell->getPosition().y()+48, "%f", curCell->getLastUnitScore());
		if(curCell->getImportance() > 1.0) {
			//Broodwar->drawEllipseMap(curCell->getPosition().x(), curCell->getPosition().y(), curCell->getRadius(), curCell->getRadius(), BWAPI::Colors::Blue, false);
			if(curCell->getImportance() > 2.0) {
				//Broodwar->drawEllipseMap(curCell->getPosition().x(), curCell->getPosition().y(), curCell->getRadius(), curCell->getRadius(), BWAPI::Colors::Cyan, false);
			}
		} else {
			//Broodwar->drawEllipseMap(curCell->getPosition().x(), curCell->getPosition().y(), curCell->getRadius(), curCell->getRadius(), BWAPI::Colors::Orange, false);

		}

	}
}

std::vector<InformationCell*> MapInformationSystem::getMapCells()
{
	return mapCells;
}

InformationCell* MapInformationSystem::getBaseCellAt( BWTA::Region* r )
{
	int bestDist = 100000;
	InformationCell* bestCell = NULL;
	for (vector<InformationCell*>::iterator i = mapCells.begin(); i != mapCells.end(); ++i)
	{
		InformationCell* curCell = *i;
		int curDist = curCell->getPosition().getDistance(r->getCenter());
		if(curDist < bestDist) {
			bestCell = curCell;
			bestDist = curDist;
		}
	}
	return bestCell;
}
