#include "InternalStateChangeTask.h"
#include "Overseer.h"


InternalStateChangeTask::InternalStateChangeTask( Overseer* ov , int STATE_CHANGE_TYPE)
{
	changeType = STATE_CHANGE_TYPE;
	TASK_TYPE = STATECHANGE;
	executing = false;
	finished = false;
	initialized = false;
	type = UnitTypes::None;
	overseer = ov;
	startFrame = Broodwar->getFrameCount();
	pauseCounter = 0;
	preReq = NULL;
}

InternalStateChangeTask::InternalStateChangeTask( Overseer* ov, int STATE_CHANGE_TYPE, int suppliment )
{
	changeType = STATE_CHANGE_TYPE;
	TASK_TYPE = STATECHANGE;
	executing = false;
	finished = false;
	initialized = false;
	type = UnitTypes::None;
	overseer = ov;
	startFrame = Broodwar->getFrameCount();
	changeVar = suppliment;
	pauseCounter = 0;
	preReq = NULL;
}

InternalStateChangeTask::InternalStateChangeTask( Overseer* ov, int STATE_CHANGE_TYPE, int suppliment, UnitRatio* ur )
{
	changeType = STATE_CHANGE_TYPE;
	TASK_TYPE = STATECHANGE;
	executing = false;
	finished = false;
	initialized = false;
	type = UnitTypes::None;
	overseer = ov;
	startFrame = Broodwar->getFrameCount();
	changeVar = suppliment;
	pauseCounter = 0;
	preReq = NULL;
	targetRatio = ur;
}


bool InternalStateChangeTask::canInitialize()
{
	// do we need to do anything here? unlikely.
	if(preReq != NULL) {
		if(preReq->isFinished()) {
			initialized = true;
		}
	} else {
		initialized = true;
	}
	return initialized;
}

bool InternalStateChangeTask::execute()
{
	switch(changeType) {
	case ACTIVATE_SYNAPSE:
		overseer->getUnitManager()->getSynapse()->start();
		break;
	case DEACTIVATE_SYNAPSE:
		overseer->getUnitManager()->getSynapse()->stop();
		break;
	case ENABLE_OFFENSE:
		overseer->getOffenseMonitor()->enable();
		break;
	case DISABLE_OFFENSE:
		overseer->getOffenseMonitor()->disable();
		break;
	case CLEAR_RALLY_LOC:
		overseer->getUnitManager()->getSynapse()->clearRallyPoint();
		break;
	case ALTER_WORKER_CAP:
		{
			std::vector<BaseModel*> friendlyBaseModels = overseer->getUnitManager()->getFriendlyBaseModels();
			for (vector<BaseModel*>::iterator k = friendlyBaseModels.begin(); k != friendlyBaseModels.end(); ++k)
			{
				BaseModel* cur = *k;
				if(cur->isAlive()) {
					if(cur->getBuildOrder() != NULL) {
						cur->getBuildOrder()->setTargetMineralWorkers(changeVar);
					}
				}
			}
			break;
		}
	case REPLACE_SYNAPSE_RATIO:
		{
			overseer->getUnitManager()->getSynapse()->replaceRatioAt(changeVar, targetRatio);
			break;
		}
	case DEACTIVATE_ROBOS: {
		overseer->getUnitManager()->getSynapse()->deactivateFacility(UnitTypes::Protoss_Robotics_Facility);
		break;
						   }

	case ACTIVATE_ROBOS: {
		overseer->getUnitManager()->getSynapse()->activateFacility(UnitTypes::Protoss_Robotics_Facility);
		break;
						 }


	case DEACTIVATE_GATEWAYS: {
		overseer->getUnitManager()->getSynapse()->deactivateFacility(UnitTypes::Protoss_Gateway);
		break;
							  }

	case ACTIVATE_GATEWAYS: {
		overseer->getUnitManager()->getSynapse()->activateFacility(UnitTypes::Protoss_Gateway);
		break;
							}

	case DEACTIVATE_PROBES: {
		overseer->getUnitManager()->getSynapse()->deactivateFacility(UnitTypes::Protoss_Probe);
		break;
							}

	case ACTIVATE_PROBES: {
		overseer->getUnitManager()->getSynapse()->activateFacility(UnitTypes::Protoss_Probe);
		break;
						  }

	case DEACTIVATE_STARGATES: {
		overseer->getUnitManager()->getSynapse()->deactivateFacility(UnitTypes::Protoss_Stargate);
		break;
							   }

	case ACTIVATE_STARGATES: {
		overseer->getUnitManager()->getSynapse()->activateFacility(UnitTypes::Protoss_Stargate);
		break;
							 }
	case PAUSE_CONSTRUCTION:
		pauseCounter = 0;
		break;
	case SWITCH_PREFERRED_DT_STRAT:
		overseer->getUnitManager()->setPreferredDTStrat(changeVar);
		break;
	case UNPAUSE_CONSTRUCTION:
		pauseCounter = changeVar;
		break;
	case PAUSE_WORKER_PRODUCTION_GLOBAL:
		{
			////Broodwar->sendText("pausing worker production. GLOBAL");
			std::vector<BaseModel*> bases = overseer->getUnitManager()->getFriendlyBaseModels();
			for(std::vector<BaseModel*>::const_iterator i = bases.begin(); i != bases.end(); i++) {
				BaseModel* cur = *i;
				cur->getBuildOrder()->setManagingWorkerAcquisition(false);
			}
			break;
		}
	case RESUME_WORKER_PRODUCTION_GLOBAL:
		{
			////Broodwar->sendText("resuming worker production. GLOBAL");
			std::vector<BaseModel*> bases = overseer->getUnitManager()->getFriendlyBaseModels();
			for(std::vector<BaseModel*>::const_iterator i = bases.begin(); i != bases.end(); i++) {
				BaseModel* cur = *i;
				cur->getBuildOrder()->setManagingWorkerAcquisition(true);
			}
			break;
		}



	}
	executing = true;
	return executing;
}

void InternalStateChangeTask::monitor()
{
	if(changeType != PAUSE_CONSTRUCTION) {
		executing = false;
		finished = true;
	} else {
		if(pauseCounter < changeVar) {
			pauseCounter++;
		} else {
			executing = false;
			finished = true;
		}
	}
}

bool InternalStateChangeTask::isExecuting()
{
	return executing;
}

bool InternalStateChangeTask::isFinished()
{
	return finished;
}

bool InternalStateChangeTask::isInitialized()
{
	return initialized;
}

BWAPI::UnitType InternalStateChangeTask::getBuildType()
{
	return type;
}

void InternalStateChangeTask::setTargetBase( BaseModel* b )
{

}

