#include "InformationManager.h"
#include "Overseer.h"

InformationManager::InformationManager( Overseer* ov )
{
	overseer = ov;
}


//************************************
// Method:    getForceDPF
// FullName:  InformationManager::getForceDPF
// Access:    public 
// Returns:   float
// Parameter: Army * a
// Comments:  none
//************************************
float InformationManager::getForceDPF( Army* a )
{
	vector<UnitModel*> members = a->getMembers();
	float dpf = 0.0;
	for (vector<UnitModel*>::iterator i = members.begin(); i != members.end(); ++i)
	{
		UnitModel* cur = *i;
		float damage = cur->getType().groundWeapon().damageAmount();
		float attackSpeed = cur->getType().groundWeapon().damageCooldown();
		dpf += (damage/attackSpeed);
	}
	return dpf;
}
