#pragma once
#include "BWAPI.h"
#include "BWTA.h"
#include "TargetEvaluator.h"
#include <cmath>


class UnitManager;
using namespace BWAPI;
using namespace BWTA;

class InformationCell {
public:
	InformationCell(int x, int y, int r, float imp, UnitManager* uman, BWTA::BaseLocation* bloc);
	BWAPI::Position getPosition();
	int getRadius();
	void setLastVisited(int tstamp);
	int getLastVisited();
	void updateInformationValue();
	float getInformationValue();
		float getLastUnitScore();
	void updateImportance(int v);
	bool isBeingExplored();
	void setBeingExplored(bool status);
	float getImportance();
	float getRegionAttackValue();
	BWTA::Region* getRegion();
	void setRegion(BWTA::Region* r);
	BWTA::BaseLocation* getBaseLoc();

private:
	float informationValue;
	int x;
	int y;
	int radius;

	int lastVisited;
	float importance;
	float lastUnitScore;

	BWAPI::Position position;
	BWTA::Region* region;
	BWTA::BaseLocation* baseLoc;

	bool beingExplored;
	UnitManager* unitManager;
	TargetEvaluator* regionEvaluator;

protected:
};