#pragma once
#include "MicroBehaviour.h"
#include "BaseModel.h"

class HarassingDarkTemplarBehaviour : public MicroBehaviour {
public:
	HarassingDarkTemplarBehaviour( UnitModel* sub , UnitManager* u);
	virtual bool execute();
	virtual void nudge();
	int calculateTargetValue(UnitModel* candidate);
	bool breachMainBase();
	bool defendPoint();
	bool hasBeenDetected();
	void findTarget();
	std::vector<Position> generateDetectionField(Position p);
	void attachTargets(Position natPos, Position basePos);
	void locateTargetsIndependently();
	void setWaitForShuttle(bool s);

private:
	BWAPI::Position targetPosition;
	BWTA::Region* targetRegion;
	UnitManager* unitManager;
	UnitModel* currentTarget;
	bool attacking;
	bool moving;
	bool breachingMainBase;
	bool defendingPoint;
	Position naturalPos;
	Position mainBasePos;
	UnitModel* bestTarget;
	bool waitForShuttle;
protected:


};