#pragma once
#include "MicroBehaviour.h"
#include "ParticleGenerator.h"
#include "BaseModel.h"
#include "BWAPI.h"
#include "BWTA.h"
#include <algorithm>
#include <vector>
#include <stack>
using namespace std;
using namespace BWAPI;
using namespace BWTA;

class GroundScoutBehaviour : public MicroBehaviour {
public:
	GroundScoutBehaviour(UnitModel* sub , UnitManager* u);
	virtual bool execute();
	virtual void nudge();
	virtual void initializeSearchStack();
	virtual void pickNewTarget();
	//virtual bool compFunc (BaseLocation* a, BaseLocation* b);
private:
	BWAPI::Position targetPosition;
	BWAPI::Position internalTargetPosition;
	InformationCell* targetCell;
	UnitManager* unitManager;
	std::set<BWAPI::Position> visitedPoints;
	int nextPoint;
	bool scoutingBase;
	bool moving;
	bool aliveLastFrame;
	std::stack<BWTA::BaseLocation*> searchStack;
	Position lastKnownGoodPosition;

protected:


};