#pragma once

/*
	Learning file config switches
*/
const static bool IEEE_MODE = true;
const static bool AIIDE_MODE = false;
/*
	Pathfinding type definitions.
*/
static const int PATHFINDING_ASTAR = 0;
static const int PATHFINDING_THREATAWARE_ASTAR_GROUND = 1;
static const int PATHFINDING_THREATAWARE_ASTAR_AIR = 2;
static const int PATHFINDING_THREATAWARE_ASTAR_GROUND_AVOIDUNITS = 3;
static const int PATHFINDING_THREATAWARE_ASTAR_AIR_FINER_GRANULARITY = 4;
static const int PATHFINDING_THREATAWARE_ASTAR_GROUND_NO_OBSTACLES = 5;
static const int PATHFINDING_THREATAWARE_ASTAR_GROUND_NO_OBSTACLES_HIGHGRAIN = 6;
static const int PATHFINDING_THREATAWARE_ASTAR_GROUND_NO_OBSTACLES_DT = 7;
/*
	Task type definitions.
*/
static const int NO_TASK = 10;
static const int TRAINING = 11;
static const int CONSTRUCTION = 12;
static const int RESEARCH = 13;
static const int ATTACK = 14;
static const int HARASS = 15;
static const int EXPAND = 16;
static const int SCOUTING = 17;
static const int STATECHANGE = 18;
static const int GUARD = 19;
static const int CONSTRUCT_BASE = 20;
/*
	System state definitions.
*/
static const int ACTIVATE_SYNAPSE = 30;
static const int DEACTIVATE_SYNAPSE = 31;
static const int PAUSE_WORKER_PRODUCTION_GLOBAL = 32;
static const int PAUSE_WORKER_PRODUCTION_LOCAL = 33;
static const int ALTER_WORKER_CAP = 34;
static const int RESUME_WORKER_PRODUCTION_GLOBAL = 35;
static const int RESUME_WORKER_PRODUCTION_LOCAL = 36;
static const int DEACTIVATE_PROBES = 37;
static const int DEACTIVATE_GATEWAYS = 38;
static const int DEACTIVATE_ROBOS = 39;
static const int DEACTIVATE_STARGATES = 40;
static const int ACTIVATE_PROBES = 41;
static const int ACTIVATE_GATEWAYS = 42;
static const int ACTIVATE_ROBOS = 43;
static const int ACTIVATE_STARGATES = 44;
static const int CLEAR_RALLY_LOC = 45;
static const int PAUSE_CONSTRUCTION = 46;
static const int UNPAUSE_CONSTRUCTION = 47;
static const int REPLACE_SYNAPSE_RATIO = 48;
static const int DISABLE_OFFENSE = 49;
static const int ENABLE_OFFENSE = 50;
static const int SWITCH_PREFERRED_DT_STRAT = 51;

/*
	Build-order stuff.
*/
static int MAX_EXPANSIONS = 4;
static const int GLOBAL_WORKER_CAP = 60;
static const int RALLY_NATURAL = 660;
static const int RALLY_START_CHOKEPOINT = 661;
static const int RALLY_START_CHOKEPOINT_FRONT = 662;
static const int RALLY_START_CHOKEPOINT_BACK = 663;
static const int RALLY_NATURAL_CHOKEPOINT = 664;
static const int RALLY_NONE = 665;

static int CURRENT_HIGHLEVEL_STRAT;
static const int HIGHLEVEL_STRAT_PVP_ALPHA = 666;
static const int HIGHLEVEL_STRAT_PVT_ALPHA = 667;
static const int HIGHLEVEL_STRAT_PVZ_ALPHA = 668;

static const int HIGHLEVEL_STRAT_PVZ_BETA = 669;
static const int HIGHLEVEL_STRAT_PVP_BETA = 670;
static const int HIGHLEVEL_STRAT_PVT_BETA = 671;

static const int HIGHLEVEL_STRAT_PVT_GAMMA = 672;
static const int HIGHLEVEL_STRAT_PVP_GAMMA = 673;
static const int HIGHLEVEL_STRAT_PVZ_GAMMA = 674;

static const int HIGHLEVEL_STRAT_PVP_DELTA = 675;

/*
	Behaviour state definitions
*/
static int DT_BEHAVIOUR_PREF = 0;
static const int DEFAULT = 60;
static const int PROTOSS_ARC_DRAGOON = 61;
static const int PROTOSS_BASE_BLOCKING_DARK_TEMPLAR = 62;
static const int PROTOSS_COWARDLY_DRAGOON = 63;
static const int PROTOSS_HARASSING_DARK_TEMPLAR = 64;
static const int PROTOSS_SCOUTING_OBSERVER = 65;
static const int PROTOSS_GENERAL_ZEALOT = 66;
static const int PROTOSS_GENERAL_ARBITER = 67;
static const int PROTOSS_SUPPORTING_OBSERVER = 68;
static const int PROTOSS_REAVER_CARRYING_SHUTTLE = 69;
static const int PROTOSS_PHOTON_CANNON = 70;
static const int PROTOSS_SCOUTING_PROBE = 71;
static const int PROTOSS_MILITARY_OBSERVER = 72;
static const int PROTOSS_PROBE = 73;
static const int PROTOSS_GENERAL_REAVER = 74;
static const int PROTOSS_GENERAL_HIGHTEMPLAR = 75;
static const int PROTOSS_GENERAL_ARCHON = 76;
static const int PROTOSS_ROAMING_SCOUT = 77;
static const int PROTOSS_ROAMING_DARK_TEMPLAR = 78;