#pragma once
#include "TaskBase.h"
#include "BuildOrderTemplate.h"

class ExpandTask : public TaskBase {



public:
	ExpandTask(Overseer* ov);
	ExpandTask(Overseer* ov, BuildOrderTemplate* bo);
	ExpandTask(BWAPI::TilePosition pos, Overseer* ov);
	ExpandTask(BWAPI::TilePosition pos, Overseer* ov, BuildOrderTemplate* bo);

	virtual bool canInitialize();
	virtual bool execute();
	virtual void monitor();
	virtual bool isExecuting();
	virtual bool isFinished();
	virtual bool isInitialized();
	virtual UnitType getBuildType() { return type; };
	virtual void setTargetBase(BaseModel* b) { };
	TilePosition getTargetPosition();
	void setGuardStrength(int g);
	void setShouldCheckReserve(bool c);
	void findExpandLocation(bool preferGas);
	void setPosPreference(bool p);
private:
	bool workerMovingToLocation;
	bool workerCanBuildBase;
	bool checkReserve;
	bool checkForBase;
	BuildOrderTemplate* templateToAdd;
	std::vector<TilePosition> path;
	std::vector<UnitModel*> maynardedWorkers;

	int timer;
	int guardStrength;

	bool posPref;
protected:

};
