#pragma  once
#include "TaskBase.h"
#include "Overseer.h"
#include "UOBBot.h"
#include <algorithm>
#include <set>

class UnitManager;

class ConstructionTask : public TaskBase {

	

public:
	ConstructionTask(BWAPI::TilePosition pos, BWAPI::UnitType building, Overseer* ov);
	ConstructionTask(BaseModel* base, BWAPI::UnitType building, Overseer* ov);
	ConstructionTask(UnitModel* target, BWAPI::UnitType building, Overseer* ov);

	virtual bool canInitialize();
	virtual bool execute();
	virtual void monitor();
	virtual bool isExecuting();
	virtual bool isFinished();
	virtual bool isInitialized();
	virtual UnitType getBuildType() { return type; };
	virtual void setTargetBase(BaseModel* b);
	bool hasPreReqs();
	bool checkForRegression();
	UnitModel* getEventualSubject();
	bool isOnBaseLoc();
private:
	int timer;
	int initTimer;
	int buildTimer;
	int cmdTmr;
	BaseModel* closestBase;
	UnitModel* um;
	UnitModel* buildNearUnit;
	std::set<UnitType> missingPreReqs;
protected:

};
