#pragma once
#include <BWAPI.h>
#include "RectangleArray.h"
#include "ReservedMap.h"
#include "SALHeap.h"
#include "BWTA.h"
using namespace BWAPI;
using namespace BWSAL;
using namespace BWTA;

//************************************
// Comments:  This class is shamelessly stolen from the BWSAL project: http://code.google.com/p/bwsal/
//			  The algorithm for building placement is excellent and we use it as a base for our own extensions.
//************************************

class BuildingPlacer
{
public:
	BuildingPlacer();
	bool canBuildHere(BWAPI::TilePosition position, BWAPI::UnitType type) const;
	bool canBuildHereWithSpace(BWAPI::TilePosition position, BWAPI::UnitType type) const;
	bool canBuildHereWithSpace(BWAPI::TilePosition position, BWAPI::UnitType type, int buildDist) const;
	BWAPI::TilePosition getBuildLocation(BWAPI::UnitType type) const;
	BWAPI::TilePosition getBuildLocationNear(BWAPI::TilePosition position,BWAPI::UnitType type) const;
	BWAPI::TilePosition getBuildLocationNear(BWAPI::TilePosition position,BWAPI::UnitType type, int buildDist) const;
	bool buildable(int x, int y) const;
	void reserveTiles(BWAPI::TilePosition position, int width, int height);
	void freeTiles(BWAPI::TilePosition position, int width, int height);
	void setBuildDistance(int distance);
	int getBuildDistance() const;
	bool isReserved(int x, int y) const;
private:
	BWSAL::RectangleArray<bool> reserveMap;
	int buildDistance;
};