#include "BaseBlockingDarkTemplarBehaviour.h"


BaseBlockingDarkTemplarBehaviour::BaseBlockingDarkTemplarBehaviour( UnitModel* sub , UnitManager* u )
{
	subject = sub;
	unitManager = u;
	attacking = false;
	moving = false;
		currentTarget = NULL;
		id = PROTOSS_BASE_BLOCKING_DARK_TEMPLAR;
}

bool BaseBlockingDarkTemplarBehaviour::execute()
{
	/*
		General idea: Find the base closest to the enemy base.
		Then go and sit on it.

	*/
	std::set<BWTA::BaseLocation*> bases = BWTA::getBaseLocations();
	BWTA::BaseLocation* nearestBase = NULL;
	BaseModel* enemyBase = unitManager->getEnemyBaseModels().at(0);

	for (std::set<BaseLocation*>::iterator i = bases.begin(); i != bases.end(); ++i)
	{
		BaseLocation* cur = *i;

		if(nearestBase == NULL) {
			nearestBase = cur;
		} else {
			TilePosition startLoc = TilePosition(enemyBase->getSubject()->getTilePosition().x(), enemyBase->getSubject()->getTilePosition().y());
			TilePosition curLoc = cur->getTilePosition();
			TilePosition bestLoc = nearestBase->getTilePosition();
			int distance = startLoc.getDistance(curLoc);
			int bestDistance = startLoc.getDistance(bestLoc);
			if(distance < bestDistance && distance > 5) {
				nearestBase = cur;
			}
		}
	}
	
	if(nearestBase != NULL) {
		Position bestPosition = Position(nearestBase->getPosition().x(), nearestBase->getPosition().y()+32);
		subject->getUnit()->move(bestPosition);
	}

	return false;
}

void BaseBlockingDarkTemplarBehaviour::nudge()
{

}
