#pragma once
#include "NewBuildingPlacer.h"
#include "RectangleArray.h"
#include "BWAPI.h"
#include "ReservedMap.h"
#include "SALHeap.h"
#include "BWTA.h"
using namespace BWTA;
namespace BWSAL
{
	// An implementation of a BuildingPlacer
	class BFSBuildingPlacer
	{
	public:
		BFSBuildingPlacer();
		virtual BWAPI::TilePosition findBuildLocation(BWAPI::UnitType unitType, BWAPI::TilePosition seedLocation, BWAPI::Unit* builder = NULL );
		virtual BWAPI::TilePosition findBuildLocation(BWAPI::UnitType unitType, BWAPI::TilePosition seedLocation, BWAPI::Unit* builder, int dist );
	//private:
		BWAPI::TilePosition getBuildLocationNear( BWAPI::TilePosition position, BWAPI::UnitType type, BWAPI::Unit* builder, int buildDist ) const;
		bool canBuildHereWithSpace( BWAPI::TilePosition position, BWAPI::UnitType type, BWAPI::Unit* builder, int buildDist ) const;
		bool isBuildable( BWAPI::Unit* builder, int x, int y ) const;
		RectangleArray< bool > m_reducedWalkability;
		
		void reserveTiles(BWAPI::TilePosition position, int width, int height);
		void freeTiles(BWAPI::TilePosition position, int width, int height);
		ReservedMap* rm;
		BWTA::Region* currentTargetRegion;
	};
}