#pragma once
#include "MicroBehaviour.h"
#include "ParticleGenerator.h"

class ArcingDragoonMicroBehaviour : public MicroBehaviour {
public:
	ArcingDragoonMicroBehaviour( UnitModel* sub , UnitManager* u);
	virtual bool execute();
	virtual void nudge();
	std::vector<Position> findSafestNearbyPoints();
	int calculateAllyStrengthAt(Position p);
	int calculateEnemyStrengthAt(Position p);
	UnitModel* getBestTarget();


private:
	BWAPI::Position targetPosition;
	UnitManager* unitManager;
	Position fallBackLocation;
	bool attacking;
	bool moving;
	int curEnemyCautionMeasure;
	int curAllyStrengthHere;
	int nearByEnemies;
	UnitModel* currentTarget;
	std::set<Unit*> nearbyUnits;
	Position safestPoint;
	Position closestEnemyPos;

	Position safestPointSmoothing[5];
	int sftPtr;

protected:


};