#pragma once
#include "TaskBase.h"
#include <deque>
#include <map>

class Arbitrator {
public:
	bool declareNewTask(TaskBase* t);
	bool stageNewTask(TaskBase* t);
	bool stageNewTaskUrgent(TaskBase* t);
	void monitor();
	int countProjectedUnitsOfType(UnitType t, int window);
	bool isStagedToBeBuilt(UnitType y);
	deque<TaskBase*> getActiveTasks();

private:
	deque<TaskBase*> activeTasks;
	deque<TaskBase*> stagedTasks;
	map<TaskBase*, int> retryMap;


protected:


};