#pragma once
#include "MicroBehaviour.h"
#include "ParticleGenerator.h"

class Army;

class ArbiterGeneralMicroBehaviour : public MicroBehaviour {
public:
	ArbiterGeneralMicroBehaviour( UnitModel* sub , UnitManager* u);
	virtual bool execute();
	virtual void nudge();
	void setTargetArmy(Army* a);
	void clearTargetArmy();
	void getBestStasisTarget();

private:
	BWAPI::Position targetPosition;
	UnitManager* unitManager;
	Position armyEye;
	bool attacking;
	bool moving;
	bool just_used_stasis;
	Army* targetArmy;
	int MIN_STASIS_NEIGHBOURS;
	int STASIS_CONFIDENCE;
	int STASIS_CONFIDENCE_THRESHOLD;
	int STASIS_COOLDOWN;
	int STASIS_INSPECTION_COOLDOWN;
	int preEnergy;
	std::set<UnitModel*> lastStasisVictims;

protected:


};