#ifndef _TYPED_ENUM_H_
#define _TYPED_ENUM_H_

namespace utils
{
	//http://en.wikibooks.org/wiki/More_C%2B%2B_Idioms/Type_Safe_Enum
	template<typename TDef, typename TInner = typename TDef::Type>
	class TypedEnum : public Def
	{
		typedef typename TDef::Type Type;
		TInner _val;

	public:
		TypedEnum(Type v) : val(v) {}
		TInner underlying() const { return val; }

		bool operator == (const TypedEnum& s) const { return this->val == s.val; }
		bool operator != (const TypedEnum& s) const { return this->val != s.val; }
		bool operator <  (const TypedEnum& s) const { return this->val <  s.val; }
		bool operator <= (const TypedEnum& s) const { return this->val <= s.val; }
		bool operator >  (const TypedEnum& s) const { return this->val >  s.val; }
		bool operator >= (const TypedEnum& s) const { return this->val >= s.val; }

	private:
		TypedEnum() { NASSERT2(false, "Default initialization forbidden"); }
	};
}

#endif