#include "NovaStdAfx.h"
#include "StrategyManager.h"
#include "BuildManager.h"
#include "SquadManager.h"

using namespace BWAPI;

StrategyManager::StrategyManager(ProductionManager *productionManager)
{
	_lastSweepFrame.clear();
	_productionManager = productionManager;
	_StateMachine = 0;

	// Marine rush
//	informationManager->_percentList[UnitTypes::Terran_Marine] = 100;

	// Marine+Medic rush
// 	informationManager->_percentList[UnitTypes::Terran_Marine] = 80;
// 	informationManager->_percentList[UnitTypes::Terran_Medic] = 20;
// 	informationManager->researchRequest(TechTypes::Stim_Packs);
//	informationManager->researchRequest(TechTypes::Optical_Flare);
// 	informationManager->upgradeRequest(UpgradeTypes::U_238_Shells);
// 	informationManager->upgradeRequest(UpgradeTypes::Terran_Infantry_Weapons);
// 	informationManager->buildRequest(UnitTypes::Terran_Comsat_Station, true);

	//BBS
// 	informationManager->buildRequest(UnitTypes::Terran_Barracks);
// 	informationManager->buildRequest(UnitTypes::Terran_Barracks);
// 	informationManager->buildRequest(UnitTypes::Terran_Supply_Depot);
// 	informationManager->_percentList[UnitTypes::Terran_Marine] = 100;
// 	informationManager->_useProxyPosition = true;

	// Vulture rush
// 	informationManager->_percentList[UnitTypes::Terran_Vulture] = 100;
// 	informationManager->upgradeRequest(UpgradeTypes::Ion_Thrusters);
// 	informationManager->upgradeRequest(UpgradeTypes::Terran_Vehicle_Weapons, 3);
// 	informationManager->upgradeRequest(UpgradeTypes::Terran_Vehicle_Plating, 3);

	// Tank rush
// 	informationManager->_percentList[UnitTypes::Terran_Siege_Tank_Tank_Mode] = 100;
// 	informationManager->researchRequest(TechTypes::Tank_Siege_Mode);

	// Tank + dropship rush
// 	informationManager->_percentList[UnitTypes::Terran_Siege_Tank_Tank_Mode] = 90;
// 	informationManager->_percentList[UnitTypes::Terran_Dropship] = 10;
// 	informationManager->researchRequest(TechTypes::Tank_Siege_Mode);

	// Wraith rush
// 	informationManager->_percentList[UnitTypes::Terran_Wraith] = 100;
// 	informationManager->upgradeRequest(UpgradeTypes::Terran_Ship_Weapons, 3);
// 	informationManager->buildRequest(UnitTypes::Terran_Control_Tower, true);

	
  	_StateMachine = new StateMachine<StrategyManager>(this);
	if (Broodwar->enemy()->getRace() == Races::Zerg) {
		//_StateMachine->ChangeState(TwoPortWraith::Instance());
		_StateMachine->ChangeState(OneRaxFE::Instance());
	} else if (Broodwar->enemy()->getRace() == Races::Protoss) {
		//_StateMachine->ChangeState(OneRaxFE::Instance());
		_StateMachine->ChangeState(TwoFactMines::Instance());
		//_StateMachine->ChangeState(TwoFactTanks1::Instance());
	} else {
  		_StateMachine->ChangeState(OneFactory::Instance());
	}

};

StrategyManager::~StrategyManager()
{
	if (_StateMachine!=0) delete _StateMachine;
}

void StrategyManager::onFrame()
{
	if (_StateMachine!=0) _StateMachine->Update();

	// Check reactive events ------------------------------------------------------
	// ************** Detected cloaked Units? ********************
	if (!informationManager->_cloakedEnemyPositions.empty())
		handleCloakedEnemy();

	// ************** Gas steal in our base? **************
	if (_productionManager->_commandCenters.size() == 1) {
		for(UnitSet::const_iterator enemy=informationManager->_seenEnemies.begin();enemy!=informationManager->_seenEnemies.end();++enemy) {
			if ( (*enemy)->getType().isWorker() ) {
				// check if is in the same region of a base
				BWTA::Region* workerRegion = BWTA::getRegion( (*enemy)->getTilePosition() );
				UnitSet::const_iterator base=_productionManager->_commandCenters.begin();
				BWTA::Region* baseRegion = BWTA::getRegion( (*base)->getTilePosition() );
				if (workerRegion == baseRegion) {
					// if we don't have Refinery try to build it
					if (Broodwar->self()->completedUnitCount(UnitTypes::Terran_Refinery) == 0)
						informationManager->criticalBuildRequest(UnitTypes::Terran_Refinery);

					if (!workerManager->workersDefending(*enemy)) {
						workerManager->defenseBase(*enemy);
					}
				}
			}
		}
	}

	// ************** Defense bases from scouts **************
	for(UnitSet::const_iterator enemy=informationManager->_seenEnemies.begin();enemy!=informationManager->_seenEnemies.end();++enemy) {
		if ( (*enemy)!=0 && (*enemy)->getType() != UnitTypes::Unknown ) {
			int completedUnits = Broodwar->self()->completedUnitCount(UnitTypes::Terran_Vulture);
			completedUnits += Broodwar->self()->completedUnitCount(UnitTypes::Terran_Siege_Tank_Tank_Mode);
			completedUnits += Broodwar->self()->completedUnitCount(UnitTypes::Terran_Siege_Tank_Siege_Mode);
			if ( completedUnits == 0) {
				// check if is in the same region of a base
				BWTA::Region* enemyRegion = BWTA::getRegion( (*enemy)->getTilePosition() );
				if (_productionManager->_commandCenters.size()>0) {
					UnitSet::const_iterator base=_productionManager->_commandCenters.begin();
					if ((*base)!=0) {
						BWTA::Region* baseRegion = BWTA::getRegion( (*base)->getTilePosition() );
						if (enemyRegion == baseRegion) {
							if (!workerManager->workersDefending(*enemy)) {
								workerManager->defenseBase(*enemy);
							}
						}
					}
				}
			}
		}
	}

	// ************** Defense base from zergling rush **************
	UnitSet allEnemiesSeen;
	for(UnitSet::const_iterator eunit = informationManager->_seenEnemies.begin();eunit!=informationManager->_seenEnemies.end();eunit++) allEnemiesSeen.insert(*eunit);
	for(SquadSet::const_iterator squadIter=squadManager->_squads.begin();squadIter!=squadManager->_squads.end();++squadIter) {
		for(UnitSet::const_iterator eunit = (*squadIter)->_enemies.begin();eunit!=(*squadIter)->_enemies.end();eunit++) allEnemiesSeen.insert(*eunit);
	}
	for(UnitSet::const_iterator enemy=allEnemiesSeen.begin();enemy!=allEnemiesSeen.end();++enemy) {
		if ( (*enemy)!=0 && (*enemy)->getType() == UnitTypes::Zerg_Zergling ) {
			BWTA::Region* enemyRegion = BWTA::getRegion( (*enemy)->getTilePosition() );
			if (enemyRegion == informationManager->home) { 
				if (!workerManager->workersDefending(*enemy)) {
					workerManager->defenseBase(*enemy);
					workerManager->defenseBase(*enemy);
				}
			}
		}
	}

	// ************** scan empty bases for enemy **************
	informationManager->scanBases();

	// ************** need anti air units? **************
	double timeToKillEnemyAir = (informationManager->_enemyAirHP>0)? (informationManager->_ourAirDPS == 0)? 99999 : informationManager->_enemyAirHP/informationManager->_ourAirDPS : 0;
	//double timeToKillAntiAir = (totalSelfAirHP>0)? (totalEnemyAirDPS == 0 )? 99999 : totalSelfAirHP/totalEnemyAirDPS : 0;
	// if enemy is Zerg check for mutalsik
	if (Broodwar->enemy()->getRace() == Races::Zerg) {
		// TODO count mutalisk vs wraith
	} else {
		if (timeToKillEnemyAir > 5) {
			informationManager->_needAntiAirUnits = true;
			informationManager->checkRequirements(UnitTypes::Terran_Goliath);
			informationManager->upgradeRequest(UpgradeTypes::Charon_Boosters);
		} else {
			informationManager->_needAntiAirUnits = false;
		}
	}
// 	Broodwar->drawTextScreen(290,52,"Enemy Air DPS: %0.2f", informationManager->_enemyAirDPS);
// 	Broodwar->drawTextScreen(290,62,"Time Kill Enemy Air: %0.2f", timeToKillEnemyAir);
// 	Broodwar->drawTextScreen(290,72,"Barrack Production: %s", informationManager->_trainOrder[UnitTypes::Terran_Barracks].getName().c_str());
// 	Broodwar->drawTextScreen(290,82,"Factory Production: %s", informationManager->_trainOrder[UnitTypes::Terran_Factory].getName().c_str());
// 	Broodwar->drawTextScreen(290,92,"Starport Production: %s", informationManager->_trainOrder[UnitTypes::Terran_Starport].getName().c_str());

	// State info
	if (_StateMachine!=0) {
		Broodwar->drawTextScreen(437,17,"%cState: %c%s", 0x07, 0x03, _StateMachine->GetCurrentState()->GetName());
	}
	//Broodwar->drawTextScreen(437,17,"M: %d G: %d", informationManager->minerals(), informationManager->gas());
}

void StrategyManager::handleCloakedEnemy() {
	if (!informationManager->_comsatStation.empty() && !informationManager->_cloakedEnemyPositions.empty()) {
		for (UnitToTimeMap::iterator unit = informationManager->_comsatStation.begin(); unit != informationManager->_comsatStation.end(); ++unit) {
			// TODO select best position (at the moment we only get the first)
			TilePositionSet::iterator posIter = informationManager->_cloakedEnemyPositions.begin();
			TilePosition pos = *posIter;

			if (_lastSweepFrame.find(pos) != _lastSweepFrame.end()) {
				if (Broodwar->getFrameCount() - _lastSweepFrame[pos] < SCANNER_SWEEP_FREQUENCY) {
					break;
				}
			}

			// Use scanner sweep if possible
			if (unit->first->getEnergy() >= 50) {
				bool scanned = informationManager->useScanner(unit->first, Position(pos));
				if (scanned) {
					_lastSweepFrame[pos] = Broodwar->getFrameCount();
					break;
				}
			}
		}
	} else if ( !buildManager->alreadyBuilding(UnitTypes::Terran_Comsat_Station) ) { // Build Comsat Station
		informationManager->criticalBuildRequest(UnitTypes::Terran_Comsat_Station);
	}

	// Execute Science Vessel plan
	//informationManager->_scienceVesselDetector = true;
	//if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Starport)==0 && !buildManager->alreadyBuilding(UnitTypes::Terran_Starport)) {
	//	informationManager->criticalBuildRequest(UnitTypes::Terran_Science_Facility, true);
	//	informationManager->criticalBuildRequest(UnitTypes::Terran_Starport, true);
	//	informationManager->criticalBuildRequest(UnitTypes::Terran_Factory, true);
	//}

	// Execute missile turret defense plan
	if (Broodwar->enemy()->getRace() != Races::Zerg) {
		informationManager->_turretDefenses = true;
	} else if (informationManager->_enemyMutalisk > 3) {
		informationManager->_turretDefenses = true;
	}

	// Clear notifications
	informationManager->_cloakedEnemyPositions.clear();
}

void StrategyManager::checkGasSteal(Unit* unit)
{
	if (_productionManager->_commandCenters.size() == 1) {
		// check if is in the same region of a base
		BWTA::Region* refineryRegion = BWTA::getRegion( unit->getTilePosition() );
		UnitSet::const_iterator base=_productionManager->_commandCenters.begin();
		BWTA::Region* baseRegion = BWTA::getRegion( (*base)->getTilePosition() );
		if (refineryRegion == baseRegion) {
			Broodwar->sendText("Bastard you stole my gas!");
			// send one worker to destroy it
			Unit* worker = workerManager->getWorkerForTask(unit->getPosition());
			if (worker!=0) worker->attack(unit);
			
			//Broodwar->printf("Unit event: %s", unit->getType().getName().c_str());
			TilePosition geyserLocation = unit->getTilePosition();
			// check if refinery is already build it
			bool refineryExist = false;
			UnitSet unitsOnGeyser = BWAPI::Broodwar->getUnitsOnTile(geyserLocation.x(), geyserLocation.y());
			
			if (Broodwar->self()->completedUnitCount(UnitTypes::Terran_Barracks) == 0 && Broodwar->self()->incompleteUnitCount(UnitTypes::Terran_Barracks) == 0 )
				informationManager->criticalBuildRequest(UnitTypes::Terran_Barracks);
		}
	}
}