#pragma once
#include <BWAPI.h>
#include <windows.h>
#include "Common.h"
#include "InformationManager.h"
#include "CombatAgent.h"

typedef std::set<CombatAgent*> CombatUnitSet;
typedef std::map<BWAPI::Unit*, CombatAgent*> UnitToCombatAgentMap;

class SquadAgent
{
public:
	enum Order
	{
		Idle,
		GetPosition,
		Fight,
		MergeSquads
	};
	enum Formation
	{
		Normal,
		Cohesion
	};

	SquadAgent();
	~SquadAgent();
	std::string getState();
	void addUnit(BWAPI::Unit* unit);
	void addUnits(UnitSet units);
	void onFrame();
	void orderGetPosition(BWAPI::Position positionTarget);
	void checkFormation();
	void checkSpread();
	bool needWait();
	void inCombat();
	void onUnitDestroy(BWAPI::Unit* unit);
	int getUnitFrameCreated(BWAPI::Unit* unit);
	int getAgents();
	void inMerge();
	void inMerge(SquadAgent* squadToMerge, BWAPI::Position toMerge = BWAPI::Positions::None);
	bool hasUnitOfType(const BWAPI::UnitType &type);
	void insertEnemyThreat(BWAPI::Unit* unit);
	void removeEnemyThreat(BWAPI::Unit* unit);
	CombatAgent* getClosestUnitTo(BWAPI::Position toPosition, BWAPI::UnitType type = BWAPI::UnitTypes::None, bool ignoreFlyers = false);
	bool isSquadBio();

	CombatUnitSet _squadUnits;
	UnitToCombatAgentMap _unitToCombatAgentMap;
	UnitSet _enemies;
	UnitToTypeMap _enemiesType;
	BWAPI::Position _center;
	double _spread; // Average distance to center.
	Order _state;
	BWAPI::Position _positionTarget;
	SquadAgent* _squadToMerge;
	bool _waitingNewUnits;
	BWAPI::Position _positionToMerge;
	std::string _waitingReason;

	// Enemy Force
	double _enemyAirDPS;
	double _enemyGroundDPS;
	double _enemyAirHP;
	double _enemyGroundHP;

	// Squad Force
	double _squadAirDPS;
	double _squadGroundDPS;
	double _squadAirHP;
	double _squadGroundHP;

private:
	void squadArea();
	bool canWin();
	void insertSquadThreat(BWAPI::Unit* unit);
	void removeSquadThreat(BWAPI::Unit* unit);
	void checkBunker(BWAPI::Unit* unit);

	//int _maxSpread;
	//bool _compacting;
	Formation _movement;
	int _squadMaxSpread;
	log4cxx::LoggerPtr _logger;
};