#include "NovaStdAfx.h"
#include "SquadAgent.h"
#include "SquadManager.h"

using namespace BWAPI;

#define MIN_SPREAD_BASE 30
#define MAX_SPREAD_BASE 50
#define SMALL_SPREAD 2
#define MEDIUM_SPREAD 4
#define LARGE_SPREAD 4

SquadAgent::SquadAgent()
	//: _maxSpread( GetPrivateProfileIntA("squad","spread",50,"bwapi-data\\AI\\novaAI.ini") ),
	//_compacting(false),
	: _movement(SquadAgent::Normal),
	_positionTarget(Positions::None),
	_state(Idle),
	_squadToMerge(0),
	_waitingNewUnits(true),
	_squadMaxSpread(0),
	_enemyAirDPS(0),
	_enemyGroundDPS(0),
	_enemyAirHP(0),
	_enemyGroundHP(0),
	_squadAirDPS(0),
	_squadGroundDPS(0),
	_squadAirHP(0),
	_squadGroundHP(0),
	_logger(log4cxx::Logger::getLogger("SquadManager.SquadAgent"))
{
	_waitingReason = "";
};

SquadAgent::~SquadAgent()
{
	for(CombatUnitSet::const_iterator unit=_squadUnits.begin();unit!=_squadUnits.end();++unit) {
		delete *unit;
	}
	_squadUnits.clear();
}

std::string SquadAgent::getState()
{
	switch (_state) {
		case Idle:				{ return "Idle";		}
		case GetPosition:		{ return "GetPosition"; }
		case Fight:				{ return "Fight";		}
		case MergeSquads:		{ return "MergeSquads"; }
	}
	return "InvalidState";
}


void SquadAgent::addUnit(Unit* unit) 
{
	CombatAgent *newUnit = new CombatAgent(unit);
	_squadUnits.insert(newUnit);
	_unitToCombatAgentMap.insert(UnitToCombatAgentMap::value_type(unit, newUnit));
	if ( unit->getType().size() == UnitSizeTypes::Small ) {
		_squadMaxSpread += SMALL_SPREAD;
	} else if ( unit->getType().size() == UnitSizeTypes::Medium ) {
		_squadMaxSpread += MEDIUM_SPREAD;
	} else if ( unit->getType().size() == UnitSizeTypes::Large ) {
		_squadMaxSpread += LARGE_SPREAD;
	}
	squadArea();
	insertSquadThreat(unit);
}

void SquadAgent::addUnits(UnitSet units) 
{
	for(UnitSet::const_iterator i=units.begin();i!=units.end();++i) {
		CombatAgent *newUnit = new CombatAgent((*i));
		_squadUnits.insert(newUnit);
		_unitToCombatAgentMap.insert(UnitToCombatAgentMap::value_type(*i, newUnit));
		if ( (*i)->getType().size() == UnitSizeTypes::Small ) {
			_squadMaxSpread += SMALL_SPREAD;
		} else if ( (*i)->getType().size() == UnitSizeTypes::Medium ) {
			_squadMaxSpread += MEDIUM_SPREAD;
		} else if ( (*i)->getType().size() == UnitSizeTypes::Large ) {
			_squadMaxSpread += LARGE_SPREAD;
		}
		insertSquadThreat(*i);
	}
	squadArea();
}

void SquadAgent::insertSquadThreat(Unit* unit)
{
	if (unit->getType().airWeapon().damageAmount() > 0 )
		_squadAirDPS += unit->getType().airWeapon().damageAmount()*(24.0/unit->getType().airWeapon().damageCooldown());
	if (unit->getType().groundWeapon().damageAmount() > 0 )
		_squadGroundDPS += unit->getType().groundWeapon().damageAmount()*(24.0/unit->getType().groundWeapon().damageCooldown());
	// In the case of Firebats and Zealots, the damage returned by BWAPI is not right, since they have two weapons:
	if (unit->getType() == UnitTypes::Terran_Firebat)
		_squadGroundDPS += unit->getType().groundWeapon().damageAmount();
	if (unit->getType().isFlyer())
		_squadAirHP += (unit->getType().maxShields() + unit->getType().maxHitPoints());
	else
		_squadGroundHP += (unit->getType().maxShields() + unit->getType().maxHitPoints());
}

void SquadAgent::removeSquadThreat(Unit* unit)
{
	if (unit->getType().airWeapon().damageAmount() > 0 )
		_squadAirDPS -= unit->getType().airWeapon().damageAmount()*(24.0/unit->getType().airWeapon().damageCooldown());
	if (unit->getType().groundWeapon().damageAmount() > 0 )
		_squadGroundDPS -= unit->getType().groundWeapon().damageAmount()*(24.0/unit->getType().groundWeapon().damageCooldown());
	// In the case of Firebats and Zealots, the damage returned by BWAPI is not right, since they have two weapons:
	if (unit->getType() == UnitTypes::Terran_Firebat)
		_squadGroundDPS -= unit->getType().groundWeapon().damageAmount();
	if (unit->getType().isFlyer())
		_squadAirHP -= (unit->getType().maxShields() + unit->getType().maxHitPoints());
	else
		_squadGroundHP -= (unit->getType().maxShields() + unit->getType().maxHitPoints());
}

void SquadAgent::insertEnemyThreat(Unit* unit)
{
	if (unit->getType().canAttack() && !unit->getType().isWorker()) {
		if (unit->getType().airWeapon().damageAmount() > 0 )
			_enemyAirDPS += unit->getType().airWeapon().damageAmount()*(24.0/unit->getType().airWeapon().damageCooldown());
		if (unit->getType().groundWeapon().damageAmount() > 0 )
			_enemyGroundDPS += unit->getType().groundWeapon().damageAmount()*(24.0/unit->getType().groundWeapon().damageCooldown());
		// In the case of Firebats and Zealots, the damage returned by BWAPI is not right, since they have two weapons:
		//if (unit->getType() == UnitTypes::Terran_Firebat || unit->getType() == UnitTypes::Protoss_Zealot)
		//	_enemyGroundDPS += unit->getType().groundWeapon().damageAmount();
		if (unit->getType().isFlyer())
			_enemyAirHP += (unit->getType().maxShields() + unit->getType().maxHitPoints());
		else
			_enemyGroundHP += (unit->getType().maxShields() + unit->getType().maxHitPoints());
	}
}

void SquadAgent::removeEnemyThreat(Unit* unit)
{
	if (unit->getType().canAttack() && !unit->getType().isWorker()) {
		if (unit->getType().airWeapon().damageAmount() > 0 )
			_enemyAirDPS -= unit->getType().airWeapon().damageAmount()*(24.0/unit->getType().airWeapon().damageCooldown());
		if (unit->getType().groundWeapon().damageAmount() > 0 )
			_enemyGroundDPS -= unit->getType().groundWeapon().damageAmount()*(24.0/unit->getType().groundWeapon().damageCooldown());
		// In the case of Firebats and Zealots, the damage returned by BWAPI is not right, since they have two weapons:
		//if (unit->getType() == UnitTypes::Terran_Firebat || unit->getType() == UnitTypes::Protoss_Zealot)
		//	_enemyGroundDPS -= unit->getType().groundWeapon().damageAmount();
		if (unit->getType().isFlyer())
			_enemyAirHP -= (unit->getType().maxShields() + unit->getType().maxHitPoints());
		else
			_enemyGroundHP -= (unit->getType().maxShields() + unit->getType().maxHitPoints());
	}
	// Sanitize
	if (_enemyAirDPS < 0) _enemyAirDPS = 0;
	if (_enemyGroundDPS < 0) _enemyGroundDPS = 0;
	if (_enemyAirHP < 0) _enemyAirHP = 0;
	if (_enemyGroundHP < 0) _enemyGroundHP = 0;

}

void SquadAgent::onFrame() 
{
	LOG4CXX_TRACE(_logger,"[onFrame] START (Update Area)");
	squadArea();

	// If we have a Dropship or Science Vessel, run its micro:
	for(CombatUnitSet::const_iterator i = this->_squadUnits.begin(); i!=this->_squadUnits.end(); ++i) {
		if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship) {
			LOG4CXX_TRACE(_logger,"Dropship micro");
			(*i)->inCombatDropship();
		}
		else if ((*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) {
			LOG4CXX_TRACE(_logger,"Science Vessel micro");
			(*i)->microScienceVessel(this);
		}
	}

	LOG4CXX_TRACE(_logger,"Check fight state");
	// if we have enemies target it
	if ( _state != Fight && _state != MergeSquads  && _enemies.size() > 0) {
		//Broodwar->printf("Change to Fight state from %s", getState().c_str());
		_state = Fight;
	}

	// DEBUG TANK SIEGE CONDITIONS
	for(CombatUnitSet::const_iterator i = this->_squadUnits.begin(); i!=this->_squadUnits.end(); ++i) {
		if ((*i)->_unit->getType() == UnitTypes::Terran_Siege_Tank_Siege_Mode || (*i)->_unit->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
			if ((*i)->_siegeState == CombatAgent::NullTarget)
				Broodwar->drawCircleMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y()-15,3,Colors::Cyan,true);
			if ((*i)->_siegeState == CombatAgent::Enemies)
				Broodwar->drawCircleMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y()-15,3,Colors::Red,true);
			if ((*i)->_siegeState == CombatAgent::NoEnemies)
				Broodwar->drawCircleMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y()-15,3,Colors::Green,true);
		}
	}

	switch (_state) {
		case MergeSquads:
			LOG4CXX_TRACE(_logger,"Update MergeSquads");
			inMerge();
			break;
		case GetPosition:
			if (isSquadBio()) {
				LOG4CXX_TRACE(_logger,"Update GetPosition BIO");
				for(CombatUnitSet::const_iterator i = this->_squadUnits.begin(); i!=this->_squadUnits.end(); ++i) {
					if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship || (*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) continue; //ignore special micro
					if ((*i)->_unit->getOrder() == Orders::PlayerGuard) {
						//if ((*i)->_unit->getType() == UnitTypes::Terran_Medic) (*i)->_unit->move(_positionTarget);
						//else (*i)->_unit->attack(_positionTarget);
						//*******************************************************
						(*i)->_unit->attack(_positionTarget);
					}
				}
				checkSpread(); // check to compact squad
			} else if (!needWait()) {
				LOG4CXX_TRACE(_logger,"Update GetPosition MECHA");
				for(CombatUnitSet::const_iterator i = this->_squadUnits.begin(); i!=this->_squadUnits.end(); ++i) {
					if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship || (*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) continue; //ignore special micro
					if ((*i)->_unit->getOrder() == Orders::PlayerGuard) {
						if ((*i)->_unit->isSieged()) (*i)->unsiegeRequest();
						else (*i)->_unit->attack(_positionTarget);
					}
					// if we are attacking or being attacked -> change to siege mode
					if ((*i)->_unit->isStartingAttack() || (*i)->_unit->isUnderAttack()) {
						if ((*i)->_unit->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
							(*i)->_unit->siege();
							(*i)->_siegeState = CombatAgent::None;
						}
					}
				}
			} else { // we need wait
				for(CombatUnitSet::const_iterator i = this->_squadUnits.begin(); i!=this->_squadUnits.end(); ++i) {
					if ((*i)->_unit->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
						if ((*i)->_unit->getOrder() == Orders::PlayerGuard || (*i)->_unit->isHoldingPosition()  ) {
							(*i)->_unit->siege();
							(*i)->_siegeState = CombatAgent::None;
						}
					}
				}
			}


// 			if (informationManager->_firstPush) {
// 				if (!needWait()) {
// 					for(CombatUnitSet::const_iterator i = this->_squadUnits.begin(); i!=this->_squadUnits.end(); ++i) {
// 						if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship || (*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) continue; //ignore special micro
// 						if ((*i)->_unit->getOrder() == Orders::PlayerGuard) {
// 							if ((*i)->_unit->isSieged()) (*i)->unsiegeRequest();
// 							else (*i)->_unit->attack(_positionTarget);
// 						}
// 						// if we are attacking or being attacked -> change to siege mode
// 						if ((*i)->_unit->isStartingAttack() || (*i)->_unit->isUnderAttack()) {
// 							if ((*i)->_unit->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
// 								(*i)->_unit->siege();
// 								(*i)->_siegeState = CombatAgent::None;
// 							}
// 						}
// 					}
// 					//checkSpread(); // check to compact squad
// 				}
// 			} else { // Wait until first push
// 				for(CombatUnitSet::const_iterator i = this->_squadUnits.begin(); i!=this->_squadUnits.end(); ++i) {
// 					if ((*i)->_unit->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
// 						if (!(*i)->_unit->isHoldingPosition() && informationManager->_initialRallyPosition.getApproxDistance((*i)->_unit->getPosition()) < 75 ) {
// 							(*i)->_unit->holdPosition();
// 						}
// 
// 						if ((*i)->_unit->getOrder() == Orders::PlayerGuard || (*i)->_unit->isHoldingPosition()  ) {
// 							(*i)->_unit->siege();
// 							(*i)->_siegeState = CombatAgent::None;
// 						}
// 					} else if ((*i)->_unit->getType() == UnitTypes::Terran_Marine) {
// 						checkBunker((*i)->_unit);
// 					}
// 				}
// 			}
			
			if (!ONLY_MICRO) {
				if ( !_positionTarget.isValid() || _center.getDistance(_positionTarget) < 75 ) {
					_positionTarget = squadManager->getBestTarget();
				}
			}

			Broodwar->drawLineMap(_center.x(), _center.y(), _positionTarget.x(), _positionTarget.y(), Colors::Yellow);
			Broodwar->drawCircleMap(_positionTarget.x(),_positionTarget.y(),3,Colors::Yellow,true);
			break;
		case Fight:
			LOG4CXX_TRACE(_logger,"Fight State");
			if ( canWin() ) {
				LOG4CXX_TRACE(_logger,"Starting inCombat");
				inCombat();
			} else {
				LOG4CXX_TRACE(_logger,"Request Retreat");
				squadManager->requestRetreat(this);
			}

			if (_enemies.size() == 0) {
				checkFormation();
				_state = GetPosition;
			}
			break;
		case Idle:
			for(CombatUnitSet::const_iterator i = this->_squadUnits.begin(); i!=this->_squadUnits.end(); ++i) {
				if ((*i)->_unit->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
					if (!(*i)->_unit->isHoldingPosition() && informationManager->_initialRallyPosition.getApproxDistance((*i)->_unit->getPosition()) < 75 ) {
						(*i)->_unit->holdPosition();
					}

					if ((*i)->_unit->getOrder() == Orders::PlayerGuard || (*i)->_unit->isHoldingPosition()  ) {
						(*i)->_unit->siege();
						(*i)->_siegeState = CombatAgent::None;
					}
				} else if ((*i)->_unit->getType() == UnitTypes::Terran_Marine) {
					checkBunker((*i)->_unit);
				}
			}
			break;
	}
	LOG4CXX_TRACE(_logger,"[onFrame] END");
}

void SquadAgent::checkBunker(BWAPI::Unit* unit)
{
	UnitSet UnitsInRange = unit->getUnitsInRadius(200);
	for(UnitSet::const_iterator i=UnitsInRange.begin();i!=UnitsInRange.end();++i) {
		Unit* nearUnit = *i;
		if ( nearUnit->getType()==UnitTypes::Terran_Bunker && nearUnit->isCompleted() && nearUnit->getLoadedUnits().size() < 4) {
			unit->load(nearUnit);
			//onUnitDestroy(unit); //TODO improve this
		}
	}
}

void SquadAgent::orderGetPosition(Position positionTarget) 
{
	_positionTarget = positionTarget;
	if (_state != MergeSquads) {
		for(CombatUnitSet::const_iterator i = this->_squadUnits.begin(); i!=this->_squadUnits.end(); ++i) {
			if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship || (*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) continue; //ignore special micro
			if ((*i)->_unit->isSieged()) (*i)->unsiegeRequest();
			else if ((*i)->_unit->getType() == UnitTypes::Terran_Medic) (*i)->_unit->move(_positionTarget);
			else (*i)->_unit->attack(_positionTarget);
		}
		_state = GetPosition;
		_positionToMerge = Positions::None;
	}

	// check formation
	checkFormation();
}

void SquadAgent::squadArea()
{
	// Compute squad Area
	_center = Position(0, 0);
	int squadSize = 0;
	for (CombatUnitSet::const_iterator it = this->_squadUnits.begin(); it!=this->_squadUnits.end(); ++it) {
		if ((*it)->_unit->getType().isFlyer()) continue; //ignore special micro
		_center += (*it)->_unit->getPosition();
		squadSize++;
	}
	if (squadSize > 0)
		_center = BWAPI::Position(_center.x() / squadSize, _center.y() / squadSize);
	_spread = 0;
	for (CombatUnitSet::const_iterator it = this->_squadUnits.begin(); it!=this->_squadUnits.end(); ++it) {
		if ((*it)->_unit->getType().isFlyer()) continue; //ignore special micro
		_spread += _center.getDistance((*it)->_unit->getPosition());
	}
	if (squadSize > 0)
		_spread /= squadSize;

	// Draw squad Area
	Color squadFormationColor = Colors::White;
	if (_movement == SquadAgent::Cohesion) squadFormationColor = Colors::Yellow;
	Broodwar->drawCircle(CoordinateType::Map, _center.x(), _center.y(), (int) _spread, squadFormationColor, false);
}

bool SquadAgent::isSquadBio()
{
	for(CombatUnitSet::const_iterator i=this->_squadUnits.begin();i!=this->_squadUnits.end();++i) {
		if ((*i)->_unit->getType() == UnitTypes::Terran_Marine || (*i)->_unit->getType() == UnitTypes::Terran_Medic) return true;
	}
	return false;
}

#define ATTACK_SQUAD_MAX_SPREAD_BASE 50
#define ATTACK_SQUAD_MAX_SPREAD_PER_UNIT 2
#define ATTACK_SQUAD_MIN_SPREAD_BASE 30

void SquadAgent::checkFormation()
{
	_movement = SquadAgent::Normal;
}

void SquadAgent::checkSpread()
{
	// if we are close to our base, don't checkSpread
	if (informationManager->home->getCenter().getApproxDistance(_center) < 30*TILE_SIZE) return;

	// if the squad has more than 30 units, don't checkSpread
	if (_squadUnits.size() >= 40) return;

	//double maxSpread = ATTACK_SQUAD_MAX_SPREAD_BASE + ATTACK_SQUAD_MAX_SPREAD_PER_UNIT * _squadUnits.size();
	//double minSpread = ATTACK_SQUAD_MIN_SPREAD_BASE + ATTACK_SQUAD_MAX_SPREAD_PER_UNIT * _squadUnits.size();
	double maxSpread = MAX_SPREAD_BASE + _squadUnits.size() + _squadMaxSpread;
	double minSpread = MIN_SPREAD_BASE + _squadMaxSpread;

// 	Broodwar->drawTextScreen(5,26,"Max spread: %.2f", maxSpread );
// 	Broodwar->drawTextScreen(5,39,"Min spread: %.2f", minSpread );

	if ( _movement == SquadAgent::Normal && _spread >  maxSpread) {
		// get nearest chokepoint
		BWTA::Chokepoint* bestChokepoint = BWTA::getNearestChokepoint(getClosestUnitTo(_positionTarget, UnitTypes::None, true)->_unit->getPosition());
		// get unit closest to chokepoint
		Position location;
		if (bestChokepoint != NULL) {
			location = getClosestUnitTo(bestChokepoint->getCenter(), UnitTypes::None, true)->_unit->getPosition();
		} else {
			location = getClosestUnitTo(_positionTarget, UnitTypes::None, true)->_unit->getPosition();
		}
		for(CombatUnitSet::const_iterator i=this->_squadUnits.begin();i!=this->_squadUnits.end();++i) {
			if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship || (*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) continue; //ignore special micro
			(*i)->_unit->move(location);
		}
		_movement = SquadAgent::Cohesion;
	}
	if ( _movement == SquadAgent::Cohesion && _spread < minSpread ){
		for(CombatUnitSet::const_iterator i=this->_squadUnits.begin();i!=this->_squadUnits.end();++i) {
			if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship || (*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) continue; //ignore special micro
			(*i)->_unit->attack(_positionTarget);
		}
		_movement = SquadAgent::Normal;
	}

	//CombatUnitSet::const_iterator i=this->_squadUnits.begin();
	Unit* closest = getClosestUnitTo(_positionTarget, UnitTypes::None, true)->_unit;
	if ( (closest->getOrder() == Orders::AttackMove || closest->getOrder() == Orders::AttackTile || closest->getOrder() == Orders::AttackUnit) && _movement == SquadAgent::Cohesion ) {
		_movement = SquadAgent::Normal;
	}


	Broodwar->drawCircleMap(_center.x(), _center.y(), (int) maxSpread, Colors::Red, false);
	Broodwar->drawCircleMap(_center.x(), _center.y(), (int) minSpread, Colors::Green, false);
}

bool SquadAgent::needWait()
{
	
	if (ONLY_MICRO) {
		_waitingReason = "Move: only micro";
		return false;
	}
	if (squadManager->_squads.size() > 3) {
		_waitingReason = "Move: squads > 3";
		return false;
	}
	// get unit closest to target
	CombatAgent* closestCombatAgent = getClosestUnitTo(_positionTarget, UnitTypes::None, true);
	if (closestCombatAgent == 0) {
		_waitingReason = "Wait: no squad unit in target position";
		return true;
	}
	Unit* closestUnit = closestCombatAgent->_unit;
	// only wait if closestUnit is more close to enemyBase than homeBase
	if (closestUnit->getPosition().getApproxDistance(informationManager->home->getCenter()) < (int)(closestUnit->getPosition().getApproxDistance(informationManager->_enemyStartPosition)/3)) {
		_waitingReason = "Move: close to home";
		return false;
	}

	UnitSet UnitsInRange = closestUnit->getUnitsInRadius(300);
	// get out not attackers units
	for(UnitSet::const_iterator i=UnitsInRange.begin();i!=UnitsInRange.end();) {
		if ( !(*i)->getType().canAttack() || (*i)->getType().isWorker() || (*i)->getType()==UnitTypes::Terran_Vulture_Spider_Mine ) {
			UnitsInRange.erase(i++);
		} else {
			++i;
		}
	}
	// add the closestUnit
	UnitsInRange.insert(closestUnit);

	std::ostringstream oss;
	oss << UnitsInRange.size() << " of " << informationManager->_minSquadSize;

	if (UnitsInRange.size() < informationManager->_minSquadSize) {
		for(CombatUnitSet::const_iterator i=this->_squadUnits.begin();i!=this->_squadUnits.end();++i) {
			if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship || (*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) continue; //ignore special micro
			Broodwar->drawTextMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y()-5,"%d", (*i)->_unit->getPosition().getApproxDistance(closestUnit->getPosition()));
			if ( (*i)->_unit == closestUnit )  (*i)->_unit->stop();
			else if ((*i)->_unit->getPosition().getApproxDistance(closestUnit->getPosition()) > 300) {
				if ((*i)->_unit->isSieged()) (*i)->unsiegeRequest();
				else (*i)->_unit->move(closestUnit->getPosition());
			}
			if ( ( (*i)->_unit->getOrder() == Orders::Stop || (*i)->_unit->getOrder() == Orders::PlayerGuard )
				&& (*i)->_unit->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode && UnitsInRange.size() < informationManager->_minSquadSize-1 && !(*i)->_unit->isSieged()) {
				(*i)->_unit->siege();
				(*i)->_siegeState = CombatAgent::None;
			}
		}
		_waitingReason = "Wait: " + oss.str() + " in squad";
		return true;	
	}
	_waitingReason = "Move: " + oss.str() + " in squad";
	return false;
}

void SquadAgent::inCombat()
{
	for(CombatUnitSet::const_iterator i=this->_squadUnits.begin();i!=this->_squadUnits.end();++i)
	{
		if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship || (*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) continue; //ignore special micro
		// find and attack best target
		(*i)->inCombat(_enemies, this);

		// Debug info
		Color colorAttack = Colors::Blue;
		if ((*i)->_unit->isStartingAttack())
			colorAttack = Colors::Yellow;
		else if ((*i)->_unit->isAttacking())
			colorAttack = Colors::Red;

		Unit* targetSelected = (*i)->_unit->getOrderTarget();
		if (targetSelected != NULL && targetSelected != (*i)->_lastTarget) {
			//Broodwar->printf("Automatic targeting");
			//(*i)->_unit->attack((*i)->_lastTarget); //FIXME: Force to attack right target. Search why happens this
			Broodwar->drawLineMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y(), targetSelected->getPosition().x(), targetSelected->getPosition().y(), Colors::Orange);
		}

		if ((*i)->_unit->isIdle() && (*i)->_unit->getType() == UnitTypes::Terran_Marine) {
// 			Broodwar->printf("WARNING: marine in combat idle");
// 			DEBUG("WARNING: marine in combat idle");
			(*i)->_unit->attack((*i)->_lastTarget);
		}

		if ((*i)->_lastTarget!=0) {
			Broodwar->drawLineMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y(), (*i)->_lastTarget->getPosition().x(), (*i)->_lastTarget->getPosition().y(), colorAttack);
			// calculate 15 degrees near point
			//Position rotated = rotatePosition(20, (*i)->_lastTarget->getPosition(), (*i)->_unit->getPosition());
			//Broodwar->drawLineMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y(), rotated.x(), rotated.y(), Colors::Purple);
		} else {
			//Broodwar->printf("[ERROR] No target selected!!!!!!!");
		}
		
		if ((*i)->_lastPosition!=Positions::None) {
			Broodwar->drawLineMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y(), (*i)->_lastPosition.x(), (*i)->_lastPosition.y(), Colors::Cyan);
			Broodwar->drawCircleMap((*i)->_lastPosition.x(), (*i)->_lastPosition.y(),3,Colors::Cyan,true);
		}
		//Broodwar->drawTextMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y()-5,"%d", (*i)->getEnemiesInRange(_enemies));
		//Broodwar->drawTextMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y()-5,"%d", (*i)->_unit->getGroundWeaponCooldown());
		//Broodwar->drawCircleMap((*i)->_unit->getPosition().x(), (*i)->_unit->getPosition().y(), (*i)->_unit->getType().seekRange(), Colors::Yellow, false);
	}
}

void SquadAgent::onUnitDestroy(Unit* unit)
{
	UnitToCombatAgentMap::iterator found = _unitToCombatAgentMap.find(unit);
	if(found != _unitToCombatAgentMap.end())
	{
		CombatAgent *unitToDelete = found->second;
		_squadUnits.erase(unitToDelete);
		_unitToCombatAgentMap.erase(found);
		delete unitToDelete;
		// remove from spread calculation
		if ( unit->getType().size() == UnitSizeTypes::Small ) {
			_squadMaxSpread -= SMALL_SPREAD;
		} else if ( unit->getType().size() == UnitSizeTypes::Medium ) {
			_squadMaxSpread -= MEDIUM_SPREAD;
		} else if ( unit->getType().size() == UnitSizeTypes::Large ) {
			_squadMaxSpread -= LARGE_SPREAD;
		}
		removeSquadThreat(unit);
	} else {
		//DEBUG("[ERROR] Unit (" << unit << ") not found");
		//DEBUG("   UNITS ON SQUAD " << this);
		//for(CombatUnitSet::const_iterator unit2=_squadUnits.begin();unit2!=_squadUnits.end();++unit2) {
		//	DEBUG("    Unit (" << (*unit2)->_unit << ")");
		//}
	}
}

int SquadAgent::getUnitFrameCreated(Unit* unit)
{
	UnitToCombatAgentMap::iterator found = _unitToCombatAgentMap.find(unit);
	if(found != _unitToCombatAgentMap.end()) {
		CombatAgent *combatUnit = found->second;
		return combatUnit->frameCreated;
	} else {
		//DEBUG("[ERROR] unit not found in _unitToCombatAgentMap");
		return Broodwar->getFrameCount();
	}
}

int SquadAgent::getAgents()
{
	return _squadUnits.size();
}

bool SquadAgent::canWin()
{
	if (informationManager->_retreatDisabled) return true;

	// calculate time to kill
	double timeToKillEnemyAir = (_enemyAirHP>0)? (_squadAirDPS == 0)? 99999 : _enemyAirHP/_squadAirDPS : 0;
	double timeToKillEnemyGround = (_enemyGroundHP>0)? (_squadGroundDPS == 0)? 99999 : _enemyGroundHP/_squadGroundDPS : 0;
	double timeToKillSquadAir = (_squadAirHP>0)? (_enemyAirDPS == 0 )? 99999 : _squadAirHP/_enemyAirDPS : 0;
	double timeToKillSquadGround = (_squadGroundHP>0)? (_enemyGroundDPS == 0)? 99999 : _squadGroundHP/_enemyGroundDPS : 0;

// 	DEBUG("Enemy Force: AirDPS " << _enemyAirDPS << " groundDPS " << _enemyGroundDPS << " airHP " << _enemyAirHP << " groundHP " << _enemyGroundHP);
// 	DEBUG("Squad Force: AirDPS " << _squadAirDPS << " groundDPS " << _squadGroundDPS << " airHP " << _squadAirHP << " groundHP " << _squadGroundHP);
// 	DEBUG("killEnemyA " << timeToKillEnemyAir << " killEnemyG " << timeToKillEnemyGround << " killSquadA " << timeToKillSquadAir << " killSquadG " << timeToKillSquadGround);
// 
// 	Broodwar->drawTextScreen(100,100,"%0.2f > %0.2f || %0.2f > %0.2f",timeToKillSquadAir,timeToKillEnemyAir,timeToKillSquadGround,timeToKillEnemyGround );

	return (timeToKillSquadAir>timeToKillEnemyAir || timeToKillSquadGround>timeToKillEnemyGround);

}

#define MERGE_DISTANCE 100

void SquadAgent::inMerge()
{
	//DEBUG("-Get first unit");
	CombatUnitSet::const_iterator i=this->_squadUnits.begin();
	if ( (*i)->_unit->getOrder() == Orders::PlayerGuard ) {
		//DEBUG("-Update own squad");
		inMerge(_squadToMerge);
		//DEBUG("-Update target squad");
		_squadToMerge->inMerge(this);
	}
}

void SquadAgent::inMerge(SquadAgent* squadToMerge, Position toMerge)
{
	LOG4CXX_TRACE(_logger,"[inMerge] Updating vars");
	_state = MergeSquads;
	_waitingNewUnits = false;
	_squadToMerge = squadToMerge;

	LOG4CXX_TRACE(_logger,"[inMerge] Updating position");
	if (toMerge == Positions::None)
		_positionToMerge = _squadToMerge->getClosestUnitTo(_positionTarget, UnitTypes::None, true)->_unit->getPosition();
	else
		_positionToMerge = toMerge;

	LOG4CXX_TRACE(_logger,"[inMerge] Moving order");
	for(CombatUnitSet::const_iterator i=this->_squadUnits.begin();i!=this->_squadUnits.end();++i) {
		if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship || (*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) continue; //ignore special micro
		(*i)->_unit->move(_positionToMerge);
	}
	//inMerge();
}

CombatAgent* SquadAgent::getClosestUnitTo(Position toPosition, UnitType type, bool ignoreFlyers)
{
	int distance = 9999999;
	int newDistance;
	CombatAgent *bestUnit = 0;
	for(CombatUnitSet::const_iterator i=this->_squadUnits.begin();i!=this->_squadUnits.end();++i) {
		if ((*i)->_unit->getType() == UnitTypes::Terran_Dropship || (*i)->_unit->getType() == UnitTypes::Terran_Science_Vessel) continue; //ignore special micro
		if (ignoreFlyers && (*i)->_unit->getType().isFlyer() ) continue;
		if (type == UnitTypes::None || type == (*i)->_unit->getType()) {
			newDistance = (*i)->_unit->getPosition().getApproxDistance(toPosition);
			if (newDistance < distance) {
				distance = newDistance;
				bestUnit = *i;
			}
		}
	}
	if (bestUnit == 0) {
		LOG4CXX_WARN(_logger,"Unit not found in getClosestUnitTo");
		bestUnit = *(_squadUnits.begin());
	}
	return bestUnit;
}


bool SquadAgent::hasUnitOfType(const UnitType &type)
{
	for(CombatUnitSet::const_iterator i=this->_squadUnits.begin();i!=this->_squadUnits.end();++i) {
		if ((*i)->_unit->getType() == type) return true;
	}
	return false;
}


