#include "NovaStdAfx.h"
#include "NovaAIModule.h"
#include "log4cxx/propertyconfigurator.h"
#include <log4cxx/helpers/pool.h>
#include <log4cxx/basicconfigurator.h>
#include <log4cxx/fileappender.h>
#include <log4cxx/simplelayout.h>
#include <log4cxx/logstring.h>

using namespace BWAPI;

void NovaAIModule::onStart()
{
	enhancedUI = new EnhancedUI();
	informationManager = new InformationManager();

	if (Broodwar->isReplay()) return;

	setUpLogging();
	{
		SYSTEMTIME time;
		GetLocalTime(&time);
		//DEBUG(time.wYear << "/" << time.wMonth << "/" << time.wDay << " " << time.wHour << ":" << time.wMinute << ":" << time.wSecond);
		//DEBUG("--");
	}

	Broodwar->enableFlag(Flag::UserInput);
	//Broodwar->enableFlag(Flag::CompleteMapInformation);

	// check MICRO map
	char first = Broodwar->mapFileName()[0];
	ONLY_MICRO = false;
	PATHFINDING01 = false;
	usingCloackUnits = false;
	totalKitingFrames = 0;
	vulturesCreated = 0;
	vulturesKilled = 0;
	totalVulutreLife = 0;
	zealotsKilled = 0;

  	if ( first != '(' ) {
		ONLY_MICRO = true;
		//Broodwar->printf("Map name '%s'", Broodwar->mapFileName().c_str() );
  	}
	if ( Broodwar->mapFileName().compare("path01.scx") == 0) {
		PATHFINDING01 = true;
	}
	if ( Broodwar->mapFileName().compare("kiting04.scm") == 0) {
		ONLY_MICRO = true;
		Broodwar->enableFlag(Flag::CompleteMapInformation);
		Broodwar->setLocalSpeed(0);
		// globals
		selfHitPoints = 0;
		selfMaxHitPoints = 0;
		enemyHitPoints = 0;
		enemyMaxHitPoints = 0;
		//microBullets = BWAPI::Bullet(null);
		numShots = 0;
	}

	// Initialize managers
	squadManager = new SquadManager();
	workerManager = new WorkerManager();
	plannerManager = new PlannerManager();
	productionManager = new ProductionManager();
	buildManager = new BuildManager();
	strategyManager = new StrategyManager(productionManager);
	
	if (PATHFINDING01) {
		//Select SVC
		UnitSet::const_iterator i = Broodwar->self()->getUnits().begin();
		Unit* scv = *i;

		Broodwar->setLocalSpeed(20);
		Position target(19*TILE_SIZE, 87*TILE_SIZE);

		//Analyze Map
		BWTA::readMap();
		BWTA::analyze();
		informationManager->mapAnalyzed = true;

		//Init walkable map
		int mapW = Broodwar->mapWidth()*4;
		int mapH = Broodwar->mapHeight()*4;

		walkableMap = new int*[mapW];
		for(int x = 0 ; x < mapW ; ++x) {
			walkableMap[x] = new int[mapH];

			//Fill from static map
			for (int y = 0; y < mapH; ++y) {
				walkableMap[x][y] = (Broodwar->isWalkable(x, y))? WALKABLE : BLOCKED;
			}
		}

		//Block static neutral units
		for(UnitSet::iterator m = Broodwar->getStaticNeutralUnits().begin(); m != Broodwar->getStaticNeutralUnits().end(); ++m) {
			// get area
			MyRectangle area;
			area.x1 = (*m)->getTilePosition().x()*4;
			area.y1 = (*m)->getTilePosition().y()*4;
			area.x2 = (*m)->getTilePosition().x()*4 + (*m)->getType().tileWidth()*4;
			area.y2 = (*m)->getTilePosition().y()*4 + (*m)->getType().tileHeight()*4;
			// map area
			for (int x = area.x1; x <= area.x2; x++) {
				for (int y = area.y1; y <= area.y2; y++) {
					if (x >= 0 && x < mapW && y >= 0 && y < mapH) {
						walkableMap[x][y] = BLOCKED;
					}
				}
			}
		}

		//Build ChokeNodeGraph
		buildChokeNodes();

		//Get walkable path
		path = getShortestPath(WalkPosition(scv->getPosition()), WalkPosition(target));

		
		scv->move(target);


	}else if (ONLY_MICRO) {
		// Set enemy start position
		std::set<TilePosition> enemyPosition = Broodwar->getStartLocations();
		for (std::set<TilePosition>::const_iterator it = enemyPosition.begin(); it != enemyPosition.end(); ++it) {
			if ( (*it).x() != Broodwar->self()->getStartLocation().x() || (*it).y() != Broodwar->self()->getStartLocation().y()) {
				informationManager->_enemyStartPosition = Position((*it).x()*TILE_SIZE, (*it).y()*TILE_SIZE);
				//DEBUG("Enemy Start Location: " << (*it).x() << "," << (*it).y() );
			}
		}
		// Add units to squad
		squadManager->newSquad(Broodwar->self()->getUnits());
		//DEBUG("New squad created");

		//testing merge squads
// 		SquadAgent* squad1;SquadAgent*  squad2;SquadAgent*  squad3;
// 		squad1 = squadManager->testSquad(Broodwar->getUnitsInRadius(Position(28*TILE_SIZE,25*TILE_SIZE),40));
// 		squad2 = squadManager->testSquad(Broodwar->getUnitsInRadius(Position(28*TILE_SIZE,29*TILE_SIZE),40));
// 		squad3 = squadManager->testSquad(Broodwar->getUnitsInRadius(Position(28*TILE_SIZE,39*TILE_SIZE),40));
// 
// 		squad2->inMerge(squad3);
// 		squad3->inMerge(squad2);
// 		squadManager->_squadsToMerge.insert(std::make_pair(squad2, squad3));
// 		squad3->inMerge(squad1);
// 		squad1->inMerge(squad3);
// 		squadManager->_squadsToMerge.insert(std::make_pair(squad3, squad1));

	} else {
		informationManager->analyzeMap();
		// DISABLE GUI and speed for TOURNAMENT
		Broodwar->setLocalSpeed(0);
		//Broodwar->setGUI(false);
	}
}

NovaAIModule::~NovaAIModule()
{
	//TODO delete mangers
}

void NovaAIModule::onFrame()
{
	enhancedUI->onFrame();

	if (Broodwar->isReplay()) return;

	if (PATHFINDING01){
		// Draw walkable tiles
		//int mapW = Broodwar->mapWidth()*4;
		//int mapH = Broodwar->mapHeight()*4;
		//for(int x=0; x < mapW; ++x) {
		//	for(int y=0; y < mapH; ++y) {
		//		if ( walkableMap[x][y] == WALKABLE) {
		//		//if ( Broodwar->isWalkable(x,y) ) {
		//			Broodwar->drawCircleMap(x*8+4,y*8+4,1,Colors::Green,true);
		//		} else {
		//			Broodwar->drawCircleMap(x*8+4,y*8+4,1,Colors::Red,true);
		//		}
		//	}
		//}

		// Draw path
		UnitSet::const_iterator i = Broodwar->self()->getUnits().begin();
		Unit* scv = *i;
		Position target(19*TILE_SIZE, 87*TILE_SIZE);
		WalkPosition previousPosition(-1, -1);
		for each(const BWTA::Chokepoint* choke in path) {
			WalkPosition pos(choke->getCenter());
			if(previousPosition.x != -1 && previousPosition.y != -1)
				BWAPI::Broodwar->drawLineMap(pos.x * 8 + 4, pos.y * 8 + 4, previousPosition.x * 8 + 4, previousPosition.y * 8 + 4, BWAPI::Colors::Cyan);
			else
				BWAPI::Broodwar->drawLineMap(pos.x * 8 + 4, pos.y * 8 + 4, scv->getPosition().x(), scv->getPosition().y(), BWAPI::Colors::Cyan);

			previousPosition = pos;
		}
		BWAPI::Broodwar->drawLineMap(target.x(), target.y(), previousPosition.x * 8 + 4, previousPosition.y * 8 + 4, BWAPI::Colors::Cyan);
	}

	if (ONLY_MICRO) {
		//DEBUG("squadManager");
		squadManager->onFrame();

		if (Broodwar->getFrameCount() == 1) {
			for(UnitSet::const_iterator it = Broodwar->self()->getUnits().begin();it!=Broodwar->self()->getUnits().end();it++) {
				selfMaxHitPoints += (*it)->getType().maxHitPoints() + (*it)->getType().maxShields();
			}

			for(UnitSet::const_iterator it = Broodwar->enemy()->getUnits().begin();it!=Broodwar->enemy()->getUnits().end();it++) {
				enemyMaxHitPoints += (*it)->getType().maxHitPoints() + (*it)->getType().maxShields();
			}
		}
	} else {
		kitingFrame = false;
		informationManager->_frameMineralSpend = 0;
		informationManager->_frameGasSpend = 0;
		LOG4CXX_TRACE(_logger, "Starting Squad Manager");
		//DEBUG("squadManager"); 
		squadManager->onFrame();
		LOG4CXX_TRACE(_logger, "Starting Worker Manager");
		//DEBUG("workerManager"); 
		workerManager->onFrame();
		LOG4CXX_TRACE(_logger, "Starting Build Manager");
		//DEBUG("buildManager"); 
		buildManager->onFrame();
		LOG4CXX_TRACE(_logger, "Starting Planner Manager");
		//DEBUG("plannerManager");
		plannerManager->onFrame();
		LOG4CXX_TRACE(_logger, "Starting Production Manager");
		//DEBUG("productionManager"); 
		productionManager->onFrame();
		LOG4CXX_TRACE(_logger, "Starting Strategy Manager");
		//DEBUG("strategyManager"); 
		strategyManager->onFrame();
		//DEBUG("ON FRAME (END)");
		if (kitingFrame) totalKitingFrames++;
	}
}

void NovaAIModule::onSendText(std::string text)
{
	if (Broodwar->isReplay()) return;

// 	if (text=="/show visibility") {
// 		show_visibility_data=!show_visibility_data;
// 	} else {
// 		Broodwar->printf("You typed '%s'!",text.c_str());
// 		Broodwar->sendText("%s",text.c_str());
// 	}
	if (text=="/bo") PRINT_BUILD_ORDER = !PRINT_BUILD_ORDER;
	if (text=="/air dps") PRINT_AIR_DPS = !PRINT_AIR_DPS;
	if (text=="/ground dps") PRINT_GROUND_DPS = !PRINT_GROUND_DPS;
}

void NovaAIModule::onReceiveText(BWAPI::Player* player, std::string text)
{
  //Broodwar->printf("%s said '%s'", player->getName().c_str(), text.c_str());
}

void NovaAIModule::onNukeDetect(BWAPI::Position target)
{
//   if (target!=Positions::Unknown)
//     Broodwar->printf("Nuclear Launch Detected at (%d,%d)",target.x(),target.y());
//   else
//     Broodwar->printf("Nuclear Launch Detected");
}

void NovaAIModule::onUnitDiscover(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;

	if (Broodwar->self()->isEnemy(unit->getPlayer())) {
		// debug info
		if (firstUnit.length() == 0) {
			firstUnit = unit->getType().getName();
			frameFirstUnit = Broodwar->getFrameCount();
		}

		squadManager->newEnemy(unit);
		if ( unit->getType().isResourceDepot() ) {
			informationManager->onEnemyResourceDepotShow(unit);
		}
		if (!unit->getType().isWorker() && !informationManager->_firstPush) {
			if (!TOURNAMENT) Broodwar->printf("First Push Detected");
			informationManager->_firstPush = true;
		}
		if (Broodwar->enemy()->getRace() != Races::Zerg) {
			if (unit->getType().isFlyer()) informationManager->_turretDefenses = true;
		}
		if ( unit->getType() == UnitTypes::Terran_Vulture_Spider_Mine && !informationManager->_scienceVesselDetector) {
			informationManager->_scienceVesselDetector = true;
			if (Broodwar->self()->visibleUnitCount(UnitTypes::Terran_Starport)==0 && !buildManager->alreadyBuilding(UnitTypes::Terran_Starport)) {
				informationManager->criticalBuildRequest(UnitTypes::Terran_Science_Facility, true);
				informationManager->criticalBuildRequest(UnitTypes::Terran_Starport, true);
				informationManager->criticalBuildRequest(UnitTypes::Terran_Factory, true);
			}
		}
	}

	if (unit->getPlayer()->isNeutral()) {
		//Broodwar->printf("Neutral unit: %s", unit->getType().getName().c_str());
	}
}

void NovaAIModule::onUnitEvade(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
	//DEBUG("EVADE UNIT (START) " << unit->getType().getName() << " [" << unit->getPlayer()->getName() << "]"); 

	if ( Broodwar->self()->isEnemy(unit->getPlayer())||
		(unit->getPlayer()->isNeutral() && unit->getType().isAddon()) ) {
		// remove from squad target
		squadManager->onEnemyEvade(unit);
	}
	//DEBUG("EVADE UNIT (END)"); 
}

void NovaAIModule::onUnitShow(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
	//DEBUG("SHOW UNIT (START) " << unit->getType().getName() << " [" << unit->getPlayer()->getName() << "]"); 
	if (!ONLY_MICRO) {
		if ( Broodwar->self() == unit->getPlayer() ) {
			if ( unit->getType() == UnitTypes::Terran_Vulture_Spider_Mine ) return; // skip spider mines
			if (unit->getType().isBuilding()) {
				productionManager->onBuildingShow(unit);
				buildManager->constructionPlaced(unit);
				if (!unit->getType().isAddon()) {
					informationManager->removeReservedMinerals(unit->getType().mineralPrice());
					informationManager->removeReservedGas(unit->getType().gasPrice());
				}
				if ( unit->getType() == UnitTypes::Terran_Command_Center ) informationManager->onCommandCenterShow(unit);
				if ( unit->getType() == UnitTypes::Terran_Missile_Turret ) informationManager->onMissileTurretShow(unit);
			} else if ( unit->getType() == UnitTypes::Terran_SCV )
				workerManager->addUnit(unit);
			else {
				if ( unit->getType() == UnitTypes::Terran_Vulture ) vulturesCreated++;
				plannerManager->rebalanceProduction();
				squadManager->unitTraining(unit);
			}
		}
	}
	//DEBUG("SHOW UNIT (END)"); 
}

void NovaAIModule::onUnitHide(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
	//Broodwar->printf("Unit hide");
}

void NovaAIModule::onUnitCreate(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
//	Broodwar->printf("Unit create");
}

void NovaAIModule::onUnitDestroy(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;

	//DEBUG("DESTROY UNIT (START) " << unit->getType().getName() << " [" << unit->getPlayer()->getName() << "]"); 
	if (Broodwar->self() == unit->getPlayer()) { // self unit
		if (unit->getType().isBuilding()) {
			productionManager->onBuildingDestroy(unit);
			buildManager->onBuildingDestroy(unit);
			if ( unit->getType() == UnitTypes::Terran_Command_Center ) informationManager->onCommandCenterDestroy(unit);
			if ( unit->getType() == UnitTypes::Terran_Missile_Turret ) informationManager->onMissileTurretDestroy(unit);
		} else if ( unit->getType() == UnitTypes::Terran_SCV )
			workerManager->onUnitDestroy(unit);
		else {
			if ( unit->getType() == UnitTypes::Terran_Vulture ) {
				vulturesKilled++;
				totalVulutreLife += Broodwar->getFrameCount() - squadManager->getUnitFrameCreated(unit);
			}
			plannerManager->rebalanceProduction();
			squadManager->onUnitDestroy(unit);
		}
	} else if (Broodwar->self()->isEnemy(unit->getPlayer())) { // enemy unit
		squadManager->onEnemyDestroy(unit);
		if ( unit->getType().isResourceDepot() ) {
			informationManager->onEnemyResourceDepotDestroy(unit);
		}
		if ( unit->getType() == UnitTypes::Protoss_Zealot ) zealotsKilled++;
	} else if (unit->getType().isMineralField()) {
		workerManager->onMineralDestroy(unit);
		// TODO free space on buildMap (buildManager)
	} else if (unit->getType().isAddon()) { // Neutral addon, could be self or enemy addon
		productionManager->onBuildingDestroy(unit);
		squadManager->onEnemyDestroy(unit);
	}
	//DEBUG("DESTROY UNIT (END)"); 
}

void NovaAIModule::onUnitMorph(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
	//Broodwar->printf("Unit morph");

	if ( Broodwar->self() == unit->getPlayer() ) {
		if (unit->getType() == UnitTypes::Terran_Refinery) {
			buildManager->refineryPlaced(unit);
			informationManager->removeReservedMinerals(unit->getType().mineralPrice());
			informationManager->removeReservedGas(unit->getType().gasPrice());
		}
	} else if (unit->getType().isRefinery()) {
		strategyManager->checkGasSteal(unit);
		squadManager->newEnemy(unit);
	} else if (unit->getType() == UnitTypes::Resource_Vespene_Geyser) {
		//Broodwar->printf("Enemy refinery destroyed");
		squadManager->onEnemyDestroy(unit);
	}

}

void NovaAIModule::onUnitRenegade(BWAPI::Unit* unit)
{
	if (Broodwar->isReplay()) return;
	//Broodwar->printf("Unit renegade");
}

void NovaAIModule::onEnd(bool isWinner)
{
	if (isWinner) {
		//log win to file
	}

	if (ONLY_MICRO) {
		for(UnitSet::const_iterator it = Broodwar->self()->getUnits().begin();it!=Broodwar->self()->getUnits().end();it++) {
			selfHitPoints += (*it)->getHitPoints() + (*it)->getShields();
		}
		
		for(UnitSet::const_iterator it = Broodwar->enemy()->getUnits().begin();it!=Broodwar->enemy()->getUnits().end();it++) {
			enemyHitPoints += (*it)->getHitPoints() + (*it)->getShields();
		}

		LOG(Broodwar->elapsedTime() << "," << selfHitPoints << "," << selfMaxHitPoints << "," << enemyHitPoints << "," << enemyMaxHitPoints <<
			"," << Broodwar->self()->getUnits().size() << "," << Broodwar->enemy()->getUnits().size() << "," << Broodwar->mapFileName());
	}
	//LOG(Broodwar->getFrameCount() << "," << totalKitingFrames << "," << frameFirstUnit << "," << firstUnit << "," << usingCloackUnits << "," << isWinner << "," <<
	//	vulturesCreated << "," << vulturesKilled << "," << totalVulutreLife << "," << Broodwar->self()->getUnitScore() << "," << zealotsKilled << "," << Broodwar->self()->getKillScore());
	//if (!TOURNAMENT) {
	//	LOG(Broodwar->getFrameCount() << "," << isWinner);
		//fileLog.close();
	//}
}

void NovaAIModule::setUpLogging()
{
	//if (!TOURNAMENT) {
		// Open log file. Comment this when migration to log4cxx is done
		//fileLog.open("bwapi-data\\logs\\NovaAIModule.log");
		//fileLog.open("bwapi-data\\logs\\NovaAIModule.log", std::ios_base::app); //append the output

		_logger = log4cxx::Logger::getLogger("Nova");
		log4cxx::PropertyConfigurator::configure("bwapi-data/AI/logger.config");

		LOG4CXX_INFO(_logger, "Logging set up!");
	//}
}

int NovaAIModule::getShortestPathCost(WalkPosition start, WalkPosition target, BWTA::Region* region)
{
	std::multimap<int, WalkPosition> openTiles;
	std::map<WalkPosition, int> gmap;
	std::map<WalkPosition, WalkPosition> parent;
	std::set<WalkPosition> closedTiles;

	int mapWidth = BWAPI::Broodwar->mapWidth() * 4;
	int mapHeight = BWAPI::Broodwar->mapHeight() * 4;

	openTiles.insert(std::make_pair(0, start));
	gmap[start] = 0;
	parent[start] = start;

	while(!openTiles.empty())
	{
		WalkPosition p = openTiles.begin()->second;
		int gvalue = gmap[p];

		if(p == target)
			return gvalue;

		int fvalue = openTiles.begin()->first;

		openTiles.erase(openTiles.begin());
		closedTiles.insert(p);

		int minx = max(p.x - 1, 0);
		int maxx = min(p.x + 1, mapWidth-1);
		int miny = max(p.y - 1, 0);
		int maxy = min(p.y + 1, mapHeight-1);

		for(int x = minx; x <= maxx; x++)
		{
			for(int y = miny; y <= maxy; y++)
			{
				WalkPosition t(x, y);

				if(closedTiles.find(t) != closedTiles.end()) continue;

				if (walkableMap[x][y] == BLOCKED) continue;
				if (region != BWTA::getRegion(TilePosition(t))) continue; //  we are not at the same region

				int g = gvalue + 10;
				if (x != p.x && y != p.y) g+=4;
				int dx = abs(x - target.x);
				int dy = abs(y - target.y);
				int h = abs(dx - dy) * 10 + min(dx, dy) * 14;
				int f = g + h;
				if (gmap.find(t) == gmap.end() || g < gmap.find(t)->second)
				{
					gmap[t] = g;

					std::pair<std::multimap<int, WalkPosition>::iterator, std::multimap<int, WalkPosition>::iterator> itp = openTiles.equal_range(f);
					if (itp.second == itp.first) 
						openTiles.insert(std::make_pair(f, t));
					else 
					{
						for (std::multimap<int, WalkPosition>::const_iterator it = itp.first; it != itp.second; ++it) 
						{
							if (it->second == t) 
							{
								openTiles.erase(it);
								break;
							} 
						}
						openTiles.insert(std::make_pair(f, t));
					}
					parent[t] = p;
				}
			}
		}
	}

	//return std::numeric_limits<int>::infinity(); // or infinite, no path!!
	return 0; // 0 or infinite, no path!!
}

ChokePath NovaAIModule::getShortestPath(WalkPosition start, WalkPosition target)
{
	// copy chokeNodeGraph and add final nodes
	ChokepointGraph tmpChokeNodes = chokeNodes;
	BWTA::Region* region = BWTA::getRegion(TilePosition(target));
	//DEBUG("Target of the region: " << region );
	std::set<BWTA::Chokepoint*> chokes = region->getChokepoints();
	// get cost to each entrance
	for (std::set<BWTA::Chokepoint*>::const_iterator it = chokes.begin(); it != chokes.end(); ++it) {
		// get center position inside target region
		Position center = makePositionValidRegion((*it)->getCenter(), region);
		// get cost to target
		int cost = getShortestPathCost(target, WalkPosition(center), region);
		if (cost != 0) tmpChokeNodes[(*it)].insert(std::make_pair((BWTA::Chokepoint *)NULL, cost));
		//DEBUG("Choke center: " << center.x() << "," << center.y() << " Region: " << BWTA::getRegion(TilePosition(center)) << " Cost: " << cost);
	}

	// Execute A* on tmpChokeNodes graph
	ChokePath path;
	std::multimap<int, BWTA::Chokepoint*> openNodes;
	std::map<BWTA::Chokepoint*, int> gmap;
	std::map<BWTA::Chokepoint*, BWTA::Chokepoint*> parent;
	std::set<BWTA::Chokepoint*> closedNodes;

	// set first nodes as the cost to get to region start entrances
	region = BWTA::getRegion(TilePosition(start));
	chokes = region->getChokepoints();
	// get cost to each entrance
	for (std::set<BWTA::Chokepoint*>::const_iterator it = chokes.begin(); it != chokes.end(); ++it) {
		// get center position inside target region
		Position center = makePositionValidRegion((*it)->getCenter(), region);
		// get cost to target
		int cost = getShortestPathCost(start, WalkPosition(center), region);
		if (cost != 0) {
			openNodes.insert(std::make_pair(cost, *it));
			gmap[*it] = cost;
			parent[*it] = *it;
		}
	}

	while(!openNodes.empty()) {
		BWTA::Chokepoint* p = openNodes.begin()->second;
		
		int gvalue = gmap[p];

		int fvalue = openNodes.begin()->first;

		openNodes.erase(openNodes.begin());
		closedNodes.insert(p);

		// child 
		ChokeCost childNodes = tmpChokeNodes[p];
		for (std::set< std::pair<BWTA::Chokepoint*, int> >::const_iterator child = childNodes.begin(); child != childNodes.end(); ++child) {
			BWTA::Chokepoint* t = child->first;
			if(t == NULL) { // we found the path 
				//BWTA::Chokepoint* p = openNodes.begin()->second;
				while(p != parent[p]) {
					path.push_front(p);
					p = parent[p];
				}
				path.push_front(p);
				DEBUG(" Path size: " << path.size() );
				return path;
			}
			
			if(closedNodes.find(t) != closedNodes.end()) continue;

			int g = gvalue + child->second;
			WalkPosition walkCenter(t->getCenter());
			int dx = abs(walkCenter.x - target.x);
			int dy = abs(walkCenter.y - target.y);
			int h = abs(dx - dy) * 10 + min(dx, dy) * 14;
			int f = g + h;
			if (gmap.find(t) == gmap.end() || g < gmap.find(t)->second) {
				gmap[t] = g;

				std::pair<std::multimap<int, BWTA::Chokepoint*>::iterator, std::multimap<int, BWTA::Chokepoint*>::iterator> itp = openNodes.equal_range(f);
				if (itp.second == itp.first) 
					openNodes.insert(std::make_pair(f, t));
				else {
					for (std::multimap<int, BWTA::Chokepoint*>::const_iterator it = itp.first; it != itp.second; ++it) {
						if (it->second == t) {
							openNodes.erase(it);
							break;
						} 
					}
					openNodes.insert(std::make_pair(f, t));
				}
				parent[t] = p;
			}
		}
	}

	return path;
}

Position NovaAIModule::makePositionValidRegion(Position position, BWTA::Region* region)
{
	//searches outward in a spiral.
	int x      = position.x();
	int y      = position.y();
	int length = 1;
	int j      = 0;
	bool first = true;
	int dx     = 0;
	int dy     = 1;	
	while (length < Broodwar->mapWidth()*TILE_SIZE) //We'll ride the spiral to the end
	{
		//if we are in the desired region, return this tile position
		if (x >= 0 && x < Broodwar->mapWidth()*TILE_SIZE && y >= 0 && y < Broodwar->mapHeight()*TILE_SIZE)
			if (region == BWTA::getRegion(TilePosition(Position(x, y))))
				return Position(x, y);

		//otherwise, move to another position
		x = x + dx;
		y = y + dy;
		//count how many steps we take in this direction
		j++;
		if (j == length) { //if we've reached the end, its time to turn
			j = 0;	//reset step counter

			//Spiral out. Keep going.
			if (!first)
				length++; //increment step counter if needed

			
			first =! first; //first=true for every other turn so we spiral out at the right rate

			//turn counter clockwise 90 degrees:
			if (dx == 0) {
				dx = dy;
				dy = 0;
			} else {
				dy = -dx;
				dx = 0;
			}
		}
		//Spiral out. Keep going.
	}
	//DEBUG("ERROR");
	return position;
}

void NovaAIModule::buildChokeNodes()
{
	std::set<BWTA::Region*> regions = BWTA::getRegions();
	for (std::set<BWTA::Region*>::const_iterator region = regions.begin(); region != regions.end(); ++region) {
		const std::set<BWTA::Chokepoint*> chokes = (*region)->getChokepoints();
		for (std::set<BWTA::Chokepoint*>::const_iterator choke1 = chokes.begin(); choke1 != chokes.end(); ++choke1) {
			for (std::set<BWTA::Chokepoint*>::const_iterator choke2 = choke1; choke2 != chokes.end(); ++choke2) {
				if (choke1 == choke2) continue;
				// calculate cost between two chokepoints
				Position center1 = makePositionValidRegion((*choke1)->getCenter(), *region);
				Position center2 = makePositionValidRegion((*choke2)->getCenter(), *region);
				// get cost to target
				int cost = getShortestPathCost(WalkPosition(center1), WalkPosition(center2), *region);
				if (cost > 0) { // save cost
					chokeNodes[*choke1].insert(std::make_pair(*choke2, cost));
					chokeNodes[*choke2].insert(std::make_pair(*choke1, cost));
				}
			}
		}
	}
}
