#pragma once
#include <BWAPI.h>
#include <limits>

typedef std::set<BWAPI::Unit*> UnitSet;
typedef std::set<BWAPI::TilePosition> TilePositionSet;
typedef std::map<BWAPI::UnitType, int> UnitToPercent;

// Display debug info on screen
#define DEBUG_DISPLAY 1

// Managers:
class InformationManager;
class WorkerManager;
class SquadManager;
class BuildManager;

// Initialized in NovaAIModule::onStart();
extern InformationManager* informationManager;
extern WorkerManager* workerManager;
extern SquadManager* squadManager;
extern BuildManager* buildManager;

extern bool ONLY_MICRO;
extern bool TOURNAMENT;
extern bool PRINT_BUILD_ORDER;
extern bool PRINT_AIR_DPS;
extern bool PRINT_GROUND_DPS;

extern bool usingCloackUnits;
extern bool usingCloackUnits;
extern int totalKitingFrames;
extern bool kitingFrame;

BWAPI::Position rotatePosition(int degree, BWAPI::Position position, BWAPI::Position origen);
BWAPI::Position getPositionInDirection(BWAPI::Position origen, BWAPI::Position direction, int distance);

#include "Utils/WalkPosition.h"