package org.bwapi.proxy.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.messages.GameMessages;

//Auto-generated code
public class WeaponType {
	protected int id;

	protected WeaponType(int id) {
		this.id = id;
	}
	
    WeaponType(GameMessages.WeaponType id) {
        this(id.getId());
    }


	public final int getID() {
		return id;
	}
	
    protected static HashMap<Integer, GameMessages.WeaponTypeData> data;
    static void setWeapons(List<GameMessages.WeaponTypeData> _data) {
        data = new HashMap<Integer, GameMessages.WeaponTypeData>();
        for(GameMessages.WeaponTypeData w: _data) {
        	if(w != null)
            data.put(w.getId(), w);
        }
    }
    
    private GameMessages.WeaponTypeData getData() {
        return data.get(getID());
    }

	
	public String getName() {
        return getData().getName();
    }
    public TechType getTech() {
        return new TechType(getData().getTech());
    }
    public UnitType whatUses() {
        return new UnitType(getData().getWhatUses());
    }
    public int damageAmount() {
        return getData().getDamageAmount();
    }
    public int damageBonus() {
        return getData().getDamageBonus();
    }
    public int damageCooldown() {
        return getData().getDamageCooldown();
    }
    public int damageFactor() {
        return getData().getDamageFactor();
    }
    public UpgradeType upgradeType() {
        return new UpgradeType(getData().getUpgradeType());
    }
    public DamageType damageType() {
        return DamageType.values()[getData().getDamageType().getNumber()];
    }
    public ExplosionType explosionType() {
        return ExplosionType.values()[getData().getExplosionType().getNumber()];
    }
    public int minRange() {
        return getData().getMinRange();
    }
    public int maxRange() {
        return getData().getMaxRange();
    }
    public int innerSplashRadius() {
        return getData().getInnerSplashRadius();
    }
    public int medianSplashRadius() {
        return getData().getMedianSplashRadius();
    }
    public int outerSplashRadius() {
        return getData().getOuterSplashRadius();
    }
    public boolean targetsAir() {
        return getData().getTargetsAir();
    }
    public boolean targetsGround() {
        return getData().getTargetsGround();
    }
    public boolean targetsMechanical() {
        return getData().getTargetsMechanical();
    }
    public boolean targetsOrganic() {
        return getData().getTargetsOrganic();
    }
    public boolean targetsNonBuilding() {
        return getData().getTargetsNonBuilding();
    }
    public boolean targetsNonRobotic() {
        return getData().getTargetsNonRobotic();
    }
    public boolean targetsTerrain() {
        return getData().getTargetsTerrain();
    }
    public boolean targetsOrgOrMech() {
        return getData().getTargetsOrgOrMech();
    }
    public boolean targetsOwn() {
        return getData().getTargetsOwn();
    }


	public boolean doesSplashDamage() {
		return equals(WeaponType.ARCLITE_SHOCK_CANNON) || equals(WeaponType.HALO_ROCKETS) ||
		equals(WeaponType.SUICIDE_INFESTED_TERRAN) || equals(WeaponType.SUBTERRANEAN_SPINES) ||
		equals(WeaponType.GLAVE_WURM) || equals(WeaponType.CORROSIVE_ACID) ||
		equals(WeaponType.PSIONIC_SHOCKWAVE) || equals(WeaponType.NEUTRON_FLARE);
	}


    public static final WeaponType GAUSS_RIFLE = new WeaponType(0);
    public static final WeaponType C_10_CANISTER_RIFLE = new WeaponType(2);
    public static final WeaponType FRAGMENTATION_GRENADE = new WeaponType(4);
    public static final WeaponType SPIDER_MINES = new WeaponType(6);
    public static final WeaponType TWIN_AUTOCANNONS = new WeaponType(7);
    public static final WeaponType HELLFIRE_MISSILE_PACK = new WeaponType(8);
    public static final WeaponType ARCLITE_CANNON = new WeaponType(11);
    public static final WeaponType FUSION_CUTTER = new WeaponType(13);
    public static final WeaponType GEMINI_MISSILES = new WeaponType(15);
    public static final WeaponType BURST_LASERS = new WeaponType(16);
    public static final WeaponType ATS_LASER_BATTERY = new WeaponType(19);
    public static final WeaponType ATA_LASER_BATTERY = new WeaponType(20);
    public static final WeaponType FLAME_THROWER = new WeaponType(25);
    public static final WeaponType ARCLITE_SHOCK_CANNON = new WeaponType(27);
    public static final WeaponType LONGBOLT_MISSILE = new WeaponType(29);
    public static final WeaponType YAMATO_GUN = new WeaponType(30);
    public static final WeaponType NUCLEAR_STRIKE = new WeaponType(31);
    public static final WeaponType LOCKDOWN = new WeaponType(32);
    public static final WeaponType EMP_SHOCKWAVE = new WeaponType(33);
    public static final WeaponType IRRADIATE = new WeaponType(34);
    public static final WeaponType CLAWS = new WeaponType(35);
    public static final WeaponType NEEDLE_SPINES = new WeaponType(38);
    public static final WeaponType KAISER_BLADES = new WeaponType(40);
    public static final WeaponType TOXIC_SPORES = new WeaponType(42);
    public static final WeaponType SPINES = new WeaponType(43);
    public static final WeaponType ACID_SPORE = new WeaponType(46);
    public static final WeaponType GLAVE_WURM = new WeaponType(48);
    public static final WeaponType SEEKER_SPORES = new WeaponType(52);
    public static final WeaponType SUBTERRANEAN_TENTACLE = new WeaponType(53);
    public static final WeaponType SUICIDE_INFESTED_TERRAN = new WeaponType(54);
    public static final WeaponType SUICIDE_SCOURGE = new WeaponType(55);
    public static final WeaponType PARASITE = new WeaponType(56);
    public static final WeaponType SPAWN_BROODLINGS = new WeaponType(57);
    public static final WeaponType ENSNARE = new WeaponType(58);
    public static final WeaponType DARK_SWARM = new WeaponType(59);
    public static final WeaponType PLAGUE = new WeaponType(60);
    public static final WeaponType CONSUME = new WeaponType(61);
    public static final WeaponType PARTICLE_BEAM = new WeaponType(62);
    public static final WeaponType PSI_BLADES = new WeaponType(64);
    public static final WeaponType PHASE_DISRUPTOR = new WeaponType(66);
    public static final WeaponType PSIONIC_SHOCKWAVE = new WeaponType(70);
    public static final WeaponType DUAL_PHOTON_BLASTERS = new WeaponType(73);
    public static final WeaponType ANTI_MATTER_MISSILES = new WeaponType(74);
    public static final WeaponType PHASE_DISRUPTOR_CANNON = new WeaponType(77);
    public static final WeaponType PULSE_CANNON = new WeaponType(79);
    public static final WeaponType STS_PHOTON_CANNON = new WeaponType(80);
    public static final WeaponType STA_PHOTON_CANNON = new WeaponType(81);
    public static final WeaponType SCARAB = new WeaponType(82);
    public static final WeaponType STASIS_FIELD = new WeaponType(83);
    public static final WeaponType PSIONIC_STORM = new WeaponType(84);
    public static final WeaponType NEUTRON_FLARE = new WeaponType(100);
    public static final WeaponType DISRUPTION_WEB = new WeaponType(101);
    public static final WeaponType RESTORATION = new WeaponType(102);
    public static final WeaponType HALO_ROCKETS = new WeaponType(103);
    public static final WeaponType CORROSIVE_ACID = new WeaponType(104);
    public static final WeaponType MIND_CONTROL = new WeaponType(105);
    public static final WeaponType FEEDBACK = new WeaponType(106);
    public static final WeaponType OPTICAL_FLARE = new WeaponType(107);
    public static final WeaponType MAELSTROM = new WeaponType(108);
    public static final WeaponType SUBTERRANEAN_SPINES = new WeaponType(109);
    public static final WeaponType WARP_BLADES = new WeaponType(111);
    public static final WeaponType NONE = new WeaponType(130);
    public static final WeaponType UNKNOWN = new WeaponType(131);


	


	protected static final Map<String, WeaponType> gNamesToWeaponTypes = new HashMap<String, WeaponType>();
	protected static final Set<WeaponType> gAllWeaponTypes;
	protected static final WeaponType[] gIdsToWeaponTypes;


	protected static final Set<WeaponType> gNormalWeaponTypes;
	protected static final Set<WeaponType> gSpecialWeaponTypes;
	static {
		Set<WeaponType> allWeaponTypes = new HashSet<WeaponType>();
		gIdsToWeaponTypes = new WeaponType[132];
		gNamesToWeaponTypes.put("Gauss Rifle", WeaponType.GAUSS_RIFLE);
		allWeaponTypes.add(WeaponType.GAUSS_RIFLE);
		gIdsToWeaponTypes[0] = WeaponType.GAUSS_RIFLE;
		gNamesToWeaponTypes.put("C-10 Canister Rifle", WeaponType.C_10_CANISTER_RIFLE);
		allWeaponTypes.add(WeaponType.C_10_CANISTER_RIFLE);
		gIdsToWeaponTypes[2] = WeaponType.C_10_CANISTER_RIFLE;
		gNamesToWeaponTypes.put("Fragmentation Grenade", WeaponType.FRAGMENTATION_GRENADE);
		allWeaponTypes.add(WeaponType.FRAGMENTATION_GRENADE);
		gIdsToWeaponTypes[4] = WeaponType.FRAGMENTATION_GRENADE;
		gNamesToWeaponTypes.put("Spider Mines", WeaponType.SPIDER_MINES);
		allWeaponTypes.add(WeaponType.SPIDER_MINES);
		gIdsToWeaponTypes[6] = WeaponType.SPIDER_MINES;
		gNamesToWeaponTypes.put("Twin Autocannons", WeaponType.TWIN_AUTOCANNONS);
		allWeaponTypes.add(WeaponType.TWIN_AUTOCANNONS);
		gIdsToWeaponTypes[7] = WeaponType.TWIN_AUTOCANNONS;
		gNamesToWeaponTypes.put("Hellfire Missile Pack", WeaponType.HELLFIRE_MISSILE_PACK);
		allWeaponTypes.add(WeaponType.HELLFIRE_MISSILE_PACK);
		gIdsToWeaponTypes[8] = WeaponType.HELLFIRE_MISSILE_PACK;
		gNamesToWeaponTypes.put("Arclite Cannon", WeaponType.ARCLITE_CANNON);
		allWeaponTypes.add(WeaponType.ARCLITE_CANNON);
		gIdsToWeaponTypes[11] = WeaponType.ARCLITE_CANNON;
		gNamesToWeaponTypes.put("Fusion Cutter", WeaponType.FUSION_CUTTER);
		allWeaponTypes.add(WeaponType.FUSION_CUTTER);
		gIdsToWeaponTypes[13] = WeaponType.FUSION_CUTTER;
		gNamesToWeaponTypes.put("Gemini Missiles", WeaponType.GEMINI_MISSILES);
		allWeaponTypes.add(WeaponType.GEMINI_MISSILES);
		gIdsToWeaponTypes[15] = WeaponType.GEMINI_MISSILES;
		gNamesToWeaponTypes.put("Burst Lasers", WeaponType.BURST_LASERS);
		allWeaponTypes.add(WeaponType.BURST_LASERS);
		gIdsToWeaponTypes[16] = WeaponType.BURST_LASERS;
		gNamesToWeaponTypes.put("ATS Laser Battery", WeaponType.ATS_LASER_BATTERY);
		allWeaponTypes.add(WeaponType.ATS_LASER_BATTERY);
		gIdsToWeaponTypes[19] = WeaponType.ATS_LASER_BATTERY;
		gNamesToWeaponTypes.put("ATA Laser Battery", WeaponType.ATA_LASER_BATTERY);
		allWeaponTypes.add(WeaponType.ATA_LASER_BATTERY);
		gIdsToWeaponTypes[20] = WeaponType.ATA_LASER_BATTERY;
		gNamesToWeaponTypes.put("Flame Thrower", WeaponType.FLAME_THROWER);
		allWeaponTypes.add(WeaponType.FLAME_THROWER);
		gIdsToWeaponTypes[25] = WeaponType.FLAME_THROWER;
		gNamesToWeaponTypes.put("Arclite Shock Cannon", WeaponType.ARCLITE_SHOCK_CANNON);
		allWeaponTypes.add(WeaponType.ARCLITE_SHOCK_CANNON);
		gIdsToWeaponTypes[27] = WeaponType.ARCLITE_SHOCK_CANNON;
		gNamesToWeaponTypes.put("Longbolt Missile", WeaponType.LONGBOLT_MISSILE);
		allWeaponTypes.add(WeaponType.LONGBOLT_MISSILE);
		gIdsToWeaponTypes[29] = WeaponType.LONGBOLT_MISSILE;
		gNamesToWeaponTypes.put("Yamato Gun", WeaponType.YAMATO_GUN);
		allWeaponTypes.add(WeaponType.YAMATO_GUN);
		gIdsToWeaponTypes[30] = WeaponType.YAMATO_GUN;
		gNamesToWeaponTypes.put("Nuclear Strike", WeaponType.NUCLEAR_STRIKE);
		allWeaponTypes.add(WeaponType.NUCLEAR_STRIKE);
		gIdsToWeaponTypes[31] = WeaponType.NUCLEAR_STRIKE;
		gNamesToWeaponTypes.put("Lockdown", WeaponType.LOCKDOWN);
		allWeaponTypes.add(WeaponType.LOCKDOWN);
		gIdsToWeaponTypes[32] = WeaponType.LOCKDOWN;
		gNamesToWeaponTypes.put("EMP Shockwave", WeaponType.EMP_SHOCKWAVE);
		allWeaponTypes.add(WeaponType.EMP_SHOCKWAVE);
		gIdsToWeaponTypes[33] = WeaponType.EMP_SHOCKWAVE;
		gNamesToWeaponTypes.put("Irradiate", WeaponType.IRRADIATE);
		allWeaponTypes.add(WeaponType.IRRADIATE);
		gIdsToWeaponTypes[34] = WeaponType.IRRADIATE;
		gNamesToWeaponTypes.put("Claws", WeaponType.CLAWS);
		allWeaponTypes.add(WeaponType.CLAWS);
		gIdsToWeaponTypes[35] = WeaponType.CLAWS;
		gNamesToWeaponTypes.put("Needle Spines", WeaponType.NEEDLE_SPINES);
		allWeaponTypes.add(WeaponType.NEEDLE_SPINES);
		gIdsToWeaponTypes[38] = WeaponType.NEEDLE_SPINES;
		gNamesToWeaponTypes.put("Kaiser Blades", WeaponType.KAISER_BLADES);
		allWeaponTypes.add(WeaponType.KAISER_BLADES);
		gIdsToWeaponTypes[40] = WeaponType.KAISER_BLADES;
		gNamesToWeaponTypes.put("Toxic Spores", WeaponType.TOXIC_SPORES);
		allWeaponTypes.add(WeaponType.TOXIC_SPORES);
		gIdsToWeaponTypes[42] = WeaponType.TOXIC_SPORES;
		gNamesToWeaponTypes.put("Spines", WeaponType.SPINES);
		allWeaponTypes.add(WeaponType.SPINES);
		gIdsToWeaponTypes[43] = WeaponType.SPINES;
		gNamesToWeaponTypes.put("Acid Spore", WeaponType.ACID_SPORE);
		allWeaponTypes.add(WeaponType.ACID_SPORE);
		gIdsToWeaponTypes[46] = WeaponType.ACID_SPORE;
		gNamesToWeaponTypes.put("Glave Wurm", WeaponType.GLAVE_WURM);
		allWeaponTypes.add(WeaponType.GLAVE_WURM);
		gIdsToWeaponTypes[48] = WeaponType.GLAVE_WURM;
		gNamesToWeaponTypes.put("Seeker Spores", WeaponType.SEEKER_SPORES);
		allWeaponTypes.add(WeaponType.SEEKER_SPORES);
		gIdsToWeaponTypes[52] = WeaponType.SEEKER_SPORES;
		gNamesToWeaponTypes.put("Subterranean Tentacle", WeaponType.SUBTERRANEAN_TENTACLE);
		allWeaponTypes.add(WeaponType.SUBTERRANEAN_TENTACLE);
		gIdsToWeaponTypes[53] = WeaponType.SUBTERRANEAN_TENTACLE;
		gNamesToWeaponTypes.put("Suicide Infested Terran", WeaponType.SUICIDE_INFESTED_TERRAN);
		allWeaponTypes.add(WeaponType.SUICIDE_INFESTED_TERRAN);
		gIdsToWeaponTypes[54] = WeaponType.SUICIDE_INFESTED_TERRAN;
		gNamesToWeaponTypes.put("Suicide Scourge", WeaponType.SUICIDE_SCOURGE);
		allWeaponTypes.add(WeaponType.SUICIDE_SCOURGE);
		gIdsToWeaponTypes[55] = WeaponType.SUICIDE_SCOURGE;
		gNamesToWeaponTypes.put("Parasite", WeaponType.PARASITE);
		allWeaponTypes.add(WeaponType.PARASITE);
		gIdsToWeaponTypes[56] = WeaponType.PARASITE;
		gNamesToWeaponTypes.put("Spawn Broodlings", WeaponType.SPAWN_BROODLINGS);
		allWeaponTypes.add(WeaponType.SPAWN_BROODLINGS);
		gIdsToWeaponTypes[57] = WeaponType.SPAWN_BROODLINGS;
		gNamesToWeaponTypes.put("Ensnare", WeaponType.ENSNARE);
		allWeaponTypes.add(WeaponType.ENSNARE);
		gIdsToWeaponTypes[58] = WeaponType.ENSNARE;
		gNamesToWeaponTypes.put("Dark Swarm", WeaponType.DARK_SWARM);
		allWeaponTypes.add(WeaponType.DARK_SWARM);
		gIdsToWeaponTypes[59] = WeaponType.DARK_SWARM;
		gNamesToWeaponTypes.put("Plague", WeaponType.PLAGUE);
		allWeaponTypes.add(WeaponType.PLAGUE);
		gIdsToWeaponTypes[60] = WeaponType.PLAGUE;
		gNamesToWeaponTypes.put("Consume", WeaponType.CONSUME);
		allWeaponTypes.add(WeaponType.CONSUME);
		gIdsToWeaponTypes[61] = WeaponType.CONSUME;
		gNamesToWeaponTypes.put("Particle Beam", WeaponType.PARTICLE_BEAM);
		allWeaponTypes.add(WeaponType.PARTICLE_BEAM);
		gIdsToWeaponTypes[62] = WeaponType.PARTICLE_BEAM;
		gNamesToWeaponTypes.put("Psi Blades", WeaponType.PSI_BLADES);
		allWeaponTypes.add(WeaponType.PSI_BLADES);
		gIdsToWeaponTypes[64] = WeaponType.PSI_BLADES;
		gNamesToWeaponTypes.put("Phase Disruptor", WeaponType.PHASE_DISRUPTOR);
		allWeaponTypes.add(WeaponType.PHASE_DISRUPTOR);
		gIdsToWeaponTypes[66] = WeaponType.PHASE_DISRUPTOR;
		gNamesToWeaponTypes.put("Psionic Shockwave", WeaponType.PSIONIC_SHOCKWAVE);
		allWeaponTypes.add(WeaponType.PSIONIC_SHOCKWAVE);
		gIdsToWeaponTypes[70] = WeaponType.PSIONIC_SHOCKWAVE;
		gNamesToWeaponTypes.put("Dual Photon Blasters", WeaponType.DUAL_PHOTON_BLASTERS);
		allWeaponTypes.add(WeaponType.DUAL_PHOTON_BLASTERS);
		gIdsToWeaponTypes[73] = WeaponType.DUAL_PHOTON_BLASTERS;
		gNamesToWeaponTypes.put("Anti-Matter Missiles", WeaponType.ANTI_MATTER_MISSILES);
		allWeaponTypes.add(WeaponType.ANTI_MATTER_MISSILES);
		gIdsToWeaponTypes[74] = WeaponType.ANTI_MATTER_MISSILES;
		gNamesToWeaponTypes.put("Phase Disruptor Cannon", WeaponType.PHASE_DISRUPTOR_CANNON);
		allWeaponTypes.add(WeaponType.PHASE_DISRUPTOR_CANNON);
		gIdsToWeaponTypes[77] = WeaponType.PHASE_DISRUPTOR_CANNON;
		gNamesToWeaponTypes.put("Pulse Cannon", WeaponType.PULSE_CANNON);
		allWeaponTypes.add(WeaponType.PULSE_CANNON);
		gIdsToWeaponTypes[79] = WeaponType.PULSE_CANNON;
		gNamesToWeaponTypes.put("STS Photon Cannon", WeaponType.STS_PHOTON_CANNON);
		allWeaponTypes.add(WeaponType.STS_PHOTON_CANNON);
		gIdsToWeaponTypes[80] = WeaponType.STS_PHOTON_CANNON;
		gNamesToWeaponTypes.put("STA Photon Cannon", WeaponType.STA_PHOTON_CANNON);
		allWeaponTypes.add(WeaponType.STA_PHOTON_CANNON);
		gIdsToWeaponTypes[81] = WeaponType.STA_PHOTON_CANNON;
		gNamesToWeaponTypes.put("Scarab", WeaponType.SCARAB);
		allWeaponTypes.add(WeaponType.SCARAB);
		gIdsToWeaponTypes[82] = WeaponType.SCARAB;
		gNamesToWeaponTypes.put("Stasis Field", WeaponType.STASIS_FIELD);
		allWeaponTypes.add(WeaponType.STASIS_FIELD);
		gIdsToWeaponTypes[83] = WeaponType.STASIS_FIELD;
		gNamesToWeaponTypes.put("Psionic Storm", WeaponType.PSIONIC_STORM);
		allWeaponTypes.add(WeaponType.PSIONIC_STORM);
		gIdsToWeaponTypes[84] = WeaponType.PSIONIC_STORM;
		gNamesToWeaponTypes.put("Neutron Flare", WeaponType.NEUTRON_FLARE);
		allWeaponTypes.add(WeaponType.NEUTRON_FLARE);
		gIdsToWeaponTypes[100] = WeaponType.NEUTRON_FLARE;
		gNamesToWeaponTypes.put("Disruption Web", WeaponType.DISRUPTION_WEB);
		allWeaponTypes.add(WeaponType.DISRUPTION_WEB);
		gIdsToWeaponTypes[101] = WeaponType.DISRUPTION_WEB;
		gNamesToWeaponTypes.put("Restoration", WeaponType.RESTORATION);
		allWeaponTypes.add(WeaponType.RESTORATION);
		gIdsToWeaponTypes[102] = WeaponType.RESTORATION;
		gNamesToWeaponTypes.put("Halo Rockets", WeaponType.HALO_ROCKETS);
		allWeaponTypes.add(WeaponType.HALO_ROCKETS);
		gIdsToWeaponTypes[103] = WeaponType.HALO_ROCKETS;
		gNamesToWeaponTypes.put("Corrosive Acid", WeaponType.CORROSIVE_ACID);
		allWeaponTypes.add(WeaponType.CORROSIVE_ACID);
		gIdsToWeaponTypes[104] = WeaponType.CORROSIVE_ACID;
		gNamesToWeaponTypes.put("Mind Control", WeaponType.MIND_CONTROL);
		allWeaponTypes.add(WeaponType.MIND_CONTROL);
		gIdsToWeaponTypes[105] = WeaponType.MIND_CONTROL;
		gNamesToWeaponTypes.put("Feedback", WeaponType.FEEDBACK);
		allWeaponTypes.add(WeaponType.FEEDBACK);
		gIdsToWeaponTypes[106] = WeaponType.FEEDBACK;
		gNamesToWeaponTypes.put("Optical Flare", WeaponType.OPTICAL_FLARE);
		allWeaponTypes.add(WeaponType.OPTICAL_FLARE);
		gIdsToWeaponTypes[107] = WeaponType.OPTICAL_FLARE;
		gNamesToWeaponTypes.put("Maelstrom", WeaponType.MAELSTROM);
		allWeaponTypes.add(WeaponType.MAELSTROM);
		gIdsToWeaponTypes[108] = WeaponType.MAELSTROM;
		gNamesToWeaponTypes.put("Subterranean Spines", WeaponType.SUBTERRANEAN_SPINES);
		allWeaponTypes.add(WeaponType.SUBTERRANEAN_SPINES);
		gIdsToWeaponTypes[109] = WeaponType.SUBTERRANEAN_SPINES;
		gNamesToWeaponTypes.put("Warp Blades", WeaponType.WARP_BLADES);
		allWeaponTypes.add(WeaponType.WARP_BLADES);
		gIdsToWeaponTypes[111] = WeaponType.WARP_BLADES;
		gNamesToWeaponTypes.put("None", WeaponType.NONE);
		allWeaponTypes.add(WeaponType.NONE);
		gIdsToWeaponTypes[130] = WeaponType.NONE;
		gNamesToWeaponTypes.put("Unknown", WeaponType.UNKNOWN);
		allWeaponTypes.add(WeaponType.UNKNOWN);
		gIdsToWeaponTypes[131] = WeaponType.UNKNOWN;
		gAllWeaponTypes = Collections.unmodifiableSet(allWeaponTypes);

		Set<WeaponType> tempNormalWeaponTypes = new HashSet<WeaponType>();
		Set<WeaponType> tempSpecialWeaponTypes = new HashSet<WeaponType>();
		tempNormalWeaponTypes.add(WeaponType.GAUSS_RIFLE);
		tempNormalWeaponTypes.add(WeaponType.C_10_CANISTER_RIFLE);
		tempNormalWeaponTypes.add(WeaponType.FRAGMENTATION_GRENADE);
		tempNormalWeaponTypes.add(WeaponType.SPIDER_MINES);
		tempNormalWeaponTypes.add(WeaponType.TWIN_AUTOCANNONS);
		tempNormalWeaponTypes.add(WeaponType.HELLFIRE_MISSILE_PACK);
		tempNormalWeaponTypes.add(WeaponType.ARCLITE_CANNON);
		tempNormalWeaponTypes.add(WeaponType.FUSION_CUTTER);
		tempNormalWeaponTypes.add(WeaponType.GEMINI_MISSILES);
		tempNormalWeaponTypes.add(WeaponType.BURST_LASERS);
		tempNormalWeaponTypes.add(WeaponType.ATS_LASER_BATTERY);
		tempNormalWeaponTypes.add(WeaponType.ATA_LASER_BATTERY);
		tempNormalWeaponTypes.add(WeaponType.FLAME_THROWER);
		tempNormalWeaponTypes.add(WeaponType.ARCLITE_SHOCK_CANNON);
		tempNormalWeaponTypes.add(WeaponType.LONGBOLT_MISSILE);
		tempNormalWeaponTypes.add(WeaponType.YAMATO_GUN);
		tempNormalWeaponTypes.add(WeaponType.NUCLEAR_STRIKE);
		tempNormalWeaponTypes.add(WeaponType.LOCKDOWN);
		tempNormalWeaponTypes.add(WeaponType.EMP_SHOCKWAVE);
		tempNormalWeaponTypes.add(WeaponType.IRRADIATE);
		tempNormalWeaponTypes.add(WeaponType.CLAWS);
		tempNormalWeaponTypes.add(WeaponType.NEEDLE_SPINES);
		tempNormalWeaponTypes.add(WeaponType.KAISER_BLADES);
		tempNormalWeaponTypes.add(WeaponType.TOXIC_SPORES);
		tempNormalWeaponTypes.add(WeaponType.SPINES);
		tempNormalWeaponTypes.add(WeaponType.ACID_SPORE);
		tempNormalWeaponTypes.add(WeaponType.GLAVE_WURM);
		tempNormalWeaponTypes.add(WeaponType.SEEKER_SPORES);
		tempNormalWeaponTypes.add(WeaponType.SUBTERRANEAN_TENTACLE);
		tempNormalWeaponTypes.add(WeaponType.SUICIDE_INFESTED_TERRAN);
		tempNormalWeaponTypes.add(WeaponType.SUICIDE_SCOURGE);
		tempNormalWeaponTypes.add(WeaponType.PARASITE);
		tempNormalWeaponTypes.add(WeaponType.SPAWN_BROODLINGS);
		tempNormalWeaponTypes.add(WeaponType.ENSNARE);
		tempNormalWeaponTypes.add(WeaponType.DARK_SWARM);
		tempNormalWeaponTypes.add(WeaponType.PLAGUE);
		tempNormalWeaponTypes.add(WeaponType.CONSUME);
		tempNormalWeaponTypes.add(WeaponType.PARTICLE_BEAM);
		tempNormalWeaponTypes.add(WeaponType.PSI_BLADES);
		tempNormalWeaponTypes.add(WeaponType.PHASE_DISRUPTOR);
		tempNormalWeaponTypes.add(WeaponType.PSIONIC_SHOCKWAVE);
		tempNormalWeaponTypes.add(WeaponType.DUAL_PHOTON_BLASTERS);
		tempNormalWeaponTypes.add(WeaponType.ANTI_MATTER_MISSILES);
		tempNormalWeaponTypes.add(WeaponType.PHASE_DISRUPTOR_CANNON);
		tempNormalWeaponTypes.add(WeaponType.PULSE_CANNON);
		tempNormalWeaponTypes.add(WeaponType.STS_PHOTON_CANNON);
		tempNormalWeaponTypes.add(WeaponType.STA_PHOTON_CANNON);
		tempNormalWeaponTypes.add(WeaponType.SCARAB);
		tempNormalWeaponTypes.add(WeaponType.STASIS_FIELD);
		tempNormalWeaponTypes.add(WeaponType.PSIONIC_STORM);
		tempNormalWeaponTypes.add(WeaponType.NEUTRON_FLARE);
		tempNormalWeaponTypes.add(WeaponType.DISRUPTION_WEB);
		tempNormalWeaponTypes.add(WeaponType.RESTORATION);
		tempNormalWeaponTypes.add(WeaponType.HALO_ROCKETS);
		tempNormalWeaponTypes.add(WeaponType.CORROSIVE_ACID);
		tempNormalWeaponTypes.add(WeaponType.MIND_CONTROL);
		tempNormalWeaponTypes.add(WeaponType.FEEDBACK);
		tempNormalWeaponTypes.add(WeaponType.OPTICAL_FLARE);
		tempNormalWeaponTypes.add(WeaponType.MAELSTROM);
		tempNormalWeaponTypes.add(WeaponType.SUBTERRANEAN_SPINES);
		tempNormalWeaponTypes.add(WeaponType.WARP_BLADES);
		tempNormalWeaponTypes.add(WeaponType.NONE);
		tempNormalWeaponTypes.add(WeaponType.UNKNOWN);
		tempSpecialWeaponTypes.add(WeaponType.GAUSS_RIFLE);
		tempSpecialWeaponTypes.add(WeaponType.C_10_CANISTER_RIFLE);
		tempSpecialWeaponTypes.add(WeaponType.FRAGMENTATION_GRENADE);
		tempSpecialWeaponTypes.add(WeaponType.SPIDER_MINES);
		tempSpecialWeaponTypes.add(WeaponType.TWIN_AUTOCANNONS);
		tempSpecialWeaponTypes.add(WeaponType.HELLFIRE_MISSILE_PACK);
		tempSpecialWeaponTypes.add(WeaponType.ARCLITE_CANNON);
		tempSpecialWeaponTypes.add(WeaponType.FUSION_CUTTER);
		tempSpecialWeaponTypes.add(WeaponType.GEMINI_MISSILES);
		tempSpecialWeaponTypes.add(WeaponType.BURST_LASERS);
		tempSpecialWeaponTypes.add(WeaponType.ATS_LASER_BATTERY);
		tempSpecialWeaponTypes.add(WeaponType.ATA_LASER_BATTERY);
		tempSpecialWeaponTypes.add(WeaponType.FLAME_THROWER);
		tempSpecialWeaponTypes.add(WeaponType.ARCLITE_SHOCK_CANNON);
		tempSpecialWeaponTypes.add(WeaponType.LONGBOLT_MISSILE);
		tempSpecialWeaponTypes.add(WeaponType.YAMATO_GUN);
		tempSpecialWeaponTypes.add(WeaponType.NUCLEAR_STRIKE);
		tempSpecialWeaponTypes.add(WeaponType.LOCKDOWN);
		tempSpecialWeaponTypes.add(WeaponType.EMP_SHOCKWAVE);
		tempSpecialWeaponTypes.add(WeaponType.IRRADIATE);
		tempSpecialWeaponTypes.add(WeaponType.CLAWS);
		tempSpecialWeaponTypes.add(WeaponType.NEEDLE_SPINES);
		tempSpecialWeaponTypes.add(WeaponType.KAISER_BLADES);
		tempSpecialWeaponTypes.add(WeaponType.TOXIC_SPORES);
		tempSpecialWeaponTypes.add(WeaponType.SPINES);
		tempSpecialWeaponTypes.add(WeaponType.ACID_SPORE);
		tempSpecialWeaponTypes.add(WeaponType.GLAVE_WURM);
		tempSpecialWeaponTypes.add(WeaponType.SEEKER_SPORES);
		tempSpecialWeaponTypes.add(WeaponType.SUBTERRANEAN_TENTACLE);
		tempSpecialWeaponTypes.add(WeaponType.SUICIDE_INFESTED_TERRAN);
		tempSpecialWeaponTypes.add(WeaponType.SUICIDE_SCOURGE);
		tempSpecialWeaponTypes.add(WeaponType.PARASITE);
		tempSpecialWeaponTypes.add(WeaponType.SPAWN_BROODLINGS);
		tempSpecialWeaponTypes.add(WeaponType.ENSNARE);
		tempSpecialWeaponTypes.add(WeaponType.DARK_SWARM);
		tempSpecialWeaponTypes.add(WeaponType.PLAGUE);
		tempSpecialWeaponTypes.add(WeaponType.CONSUME);
		tempSpecialWeaponTypes.add(WeaponType.PARTICLE_BEAM);
		tempSpecialWeaponTypes.add(WeaponType.PSI_BLADES);
		tempSpecialWeaponTypes.add(WeaponType.PHASE_DISRUPTOR);
		tempSpecialWeaponTypes.add(WeaponType.PSIONIC_SHOCKWAVE);
		tempSpecialWeaponTypes.add(WeaponType.DUAL_PHOTON_BLASTERS);
		tempSpecialWeaponTypes.add(WeaponType.ANTI_MATTER_MISSILES);
		tempSpecialWeaponTypes.add(WeaponType.PHASE_DISRUPTOR_CANNON);
		tempSpecialWeaponTypes.add(WeaponType.PULSE_CANNON);
		tempSpecialWeaponTypes.add(WeaponType.STS_PHOTON_CANNON);
		tempSpecialWeaponTypes.add(WeaponType.STA_PHOTON_CANNON);
		tempSpecialWeaponTypes.add(WeaponType.SCARAB);
		tempSpecialWeaponTypes.add(WeaponType.STASIS_FIELD);
		tempSpecialWeaponTypes.add(WeaponType.PSIONIC_STORM);
		tempSpecialWeaponTypes.add(WeaponType.NEUTRON_FLARE);
		tempSpecialWeaponTypes.add(WeaponType.DISRUPTION_WEB);
		tempSpecialWeaponTypes.add(WeaponType.RESTORATION);
		tempSpecialWeaponTypes.add(WeaponType.HALO_ROCKETS);
		tempSpecialWeaponTypes.add(WeaponType.CORROSIVE_ACID);
		tempSpecialWeaponTypes.add(WeaponType.MIND_CONTROL);
		tempSpecialWeaponTypes.add(WeaponType.FEEDBACK);
		tempSpecialWeaponTypes.add(WeaponType.OPTICAL_FLARE);
		tempSpecialWeaponTypes.add(WeaponType.MAELSTROM);
		tempSpecialWeaponTypes.add(WeaponType.SUBTERRANEAN_SPINES);
		tempSpecialWeaponTypes.add(WeaponType.WARP_BLADES);
		tempSpecialWeaponTypes.add(WeaponType.NONE);
		tempSpecialWeaponTypes.add(WeaponType.UNKNOWN);
		gNormalWeaponTypes = Collections.unmodifiableSet(tempNormalWeaponTypes);
		gSpecialWeaponTypes = Collections.unmodifiableSet(tempSpecialWeaponTypes);
	}

	public static final WeaponType getWeaponType(String name) {
		return gNamesToWeaponTypes.get(name);
	}

	public static final Set<WeaponType> allWeaponTypes() {
		return gAllWeaponTypes;
	}

	static final WeaponType getWeaponTypeFromId(int id) {
		return gIdsToWeaponTypes[id];
	}

	static final int getMaxIdPlusOne() {
		return gIdsToWeaponTypes.length;
	}

	public static final Set<WeaponType> normalWeaponTypes() {
		return gNormalWeaponTypes;
	}

	public static final Set<WeaponType> specialWeaponTypes() {
		return gSpecialWeaponTypes;
	}

	public final boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		else if (this instanceof WeaponType) {
			final WeaponType other = (WeaponType) object;
			return this.id == other.id;
		}
		else {
			return false;
		}
	}

	public final int hashCode() {
		return this.id;
	}
}
