package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.messages.GameMessages;

public class UpgradeType {
    protected int id;

    UpgradeType(int id) {
        this.id = id;
    }

    UpgradeType(GameMessages.UpgradeType upgrade) {
        this(upgrade.getId());
    }

    protected static List<GameMessages.UpgradeTypeData> data;

    static void setUpgrades(List<GameMessages.UpgradeTypeData> _data) {
        data = new ArrayList<GameMessages.UpgradeTypeData>(_data);
    }

    private GameMessages.UpgradeTypeData getData() {
        return data.get(getID());
    }

    public final int getID() {
        return id;
    }

    public String getName() {
        return getData().getName();
    }

    public Race getRace() {
        return new Race(getData().getRace());
    }

    public int mineralPriceBase() {
        return getData().getMineralPriceBase();
    }

    public int mineralPriceFactor() {
        return getData().getMineralPriceFactor();
    }

    public int gasPriceBase() {
        return getData().getGasPriceBase();
    }

    public int gasPriceFactor() {
        return getData().getGasPriceFactor();
    }

    public int upgradeTimeBase() {
        return getData().getUpgradeTimeBase();
    }

    public int upgradeTimeFactor() {
        return getData().getUpgradeTimeFactor();
    }

    public int maxRepeats() {
        return getData().getMaxRepeats();
    }

    public UnitType whatUpgrades() {
        return new UnitType(getData().getWhatUpgrades());
    }

    public Set<UnitType> whatUses() {
        HashSet<UnitType> ret = new HashSet<UnitType>();
        for (GameMessages.UnitType t : getData().getWhatUsesList()) {
            ret.add(new UnitType(t));
        }
        return ret;
    }

    public static final UpgradeType TERRAN_INFANTRY_ARMOR = new UpgradeType(0);
    public static final UpgradeType TERRAN_VEHICLE_PLATING = new UpgradeType(1);
    public static final UpgradeType TERRAN_SHIP_PLATING = new UpgradeType(2);
    public static final UpgradeType ZERG_CARAPACE = new UpgradeType(3);
    public static final UpgradeType ZERG_FLYER_CARAPACE = new UpgradeType(4);
    public static final UpgradeType PROTOSS_ARMOR = new UpgradeType(5);
    public static final UpgradeType PROTOSS_PLATING = new UpgradeType(6);
    public static final UpgradeType TERRAN_INFANTRY_WEAPONS = new UpgradeType(7);
    public static final UpgradeType TERRAN_VEHICLE_WEAPONS = new UpgradeType(8);
    public static final UpgradeType TERRAN_SHIP_WEAPONS = new UpgradeType(9);
    public static final UpgradeType ZERG_MELEE_ATTACKS = new UpgradeType(10);
    public static final UpgradeType ZERG_MISSILE_ATTACKS = new UpgradeType(11);
    public static final UpgradeType ZERG_FLYER_ATTACKS = new UpgradeType(12);
    public static final UpgradeType PROTOSS_GROUND_WEAPONS = new UpgradeType(13);
    public static final UpgradeType PROTOSS_AIR_WEAPONS = new UpgradeType(14);
    public static final UpgradeType PROTOSS_PLASMA_SHIELDS = new UpgradeType(15);
    public static final UpgradeType U_238_SHELLS = new UpgradeType(16);
    public static final UpgradeType ION_THRUSTERS = new UpgradeType(17);
    public static final UpgradeType TITAN_REACTOR = new UpgradeType(19);
    public static final UpgradeType OCULAR_IMPLANTS = new UpgradeType(20);
    public static final UpgradeType MOEBIUS_REACTOR = new UpgradeType(21);
    public static final UpgradeType APOLLO_REACTOR = new UpgradeType(22);
    public static final UpgradeType COLOSSUS_REACTOR = new UpgradeType(23);
    public static final UpgradeType VENTRAL_SACS = new UpgradeType(24);
    public static final UpgradeType ANTENNAE = new UpgradeType(25);
    public static final UpgradeType PNEUMATIZED_CARAPACE = new UpgradeType(26);
    public static final UpgradeType METABOLIC_BOOST = new UpgradeType(27);
    public static final UpgradeType ADRENAL_GLANDS = new UpgradeType(28);
    public static final UpgradeType MUSCULAR_AUGMENTS = new UpgradeType(29);
    public static final UpgradeType GROOVED_SPINES = new UpgradeType(30);
    public static final UpgradeType GAMETE_MEIOSIS = new UpgradeType(31);
    public static final UpgradeType METASYNAPTIC_NODE = new UpgradeType(32);
    public static final UpgradeType SINGULARITY_CHARGE = new UpgradeType(33);
    public static final UpgradeType LEG_ENHANCEMENTS = new UpgradeType(34);
    public static final UpgradeType SCARAB_DAMAGE = new UpgradeType(35);
    public static final UpgradeType REAVER_CAPACITY = new UpgradeType(36);
    public static final UpgradeType GRAVITIC_DRIVE = new UpgradeType(37);
    public static final UpgradeType SENSOR_ARRAY = new UpgradeType(38);
    public static final UpgradeType GRAVITIC_BOOSTERS = new UpgradeType(39);
    public static final UpgradeType KHAYDARIN_AMULET = new UpgradeType(40);
    public static final UpgradeType APIAL_SENSORS = new UpgradeType(41);
    public static final UpgradeType GRAVITIC_THRUSTERS = new UpgradeType(42);
    public static final UpgradeType CARRIER_CAPACITY = new UpgradeType(43);
    public static final UpgradeType KHAYDARIN_CORE = new UpgradeType(44);
    public static final UpgradeType ARGUS_JEWEL = new UpgradeType(47);
    public static final UpgradeType ARGUS_TALISMAN = new UpgradeType(49);
    public static final UpgradeType CADUCEUS_REACTOR = new UpgradeType(51);
    public static final UpgradeType CHITINOUS_PLATING = new UpgradeType(52);
    public static final UpgradeType ANABOLIC_SYNTHESIS = new UpgradeType(53);
    public static final UpgradeType CHARON_BOOSTER = new UpgradeType(54);
    public static final UpgradeType NONE = new UpgradeType(61);
    public static final UpgradeType UNKNOWN = new UpgradeType(62);

    protected static final Map<String, UpgradeType> gNamesToUpgradeTypes = new HashMap<String, UpgradeType>();
    protected static final Set<UpgradeType> gAllUpgradeTypes;
    protected static final UpgradeType[] gIdsToUpgradeTypes;

    static {
        Set<UpgradeType> allUpgradeTypes = new HashSet<UpgradeType>();
        gIdsToUpgradeTypes = new UpgradeType[63];
        gNamesToUpgradeTypes.put("Terran Infantry Armor",
                UpgradeType.TERRAN_INFANTRY_ARMOR);
        allUpgradeTypes.add(UpgradeType.TERRAN_INFANTRY_ARMOR);
        gIdsToUpgradeTypes[0] = UpgradeType.TERRAN_INFANTRY_ARMOR;
        gNamesToUpgradeTypes.put("Terran Vehicle Plating",
                UpgradeType.TERRAN_VEHICLE_PLATING);
        allUpgradeTypes.add(UpgradeType.TERRAN_VEHICLE_PLATING);
        gIdsToUpgradeTypes[1] = UpgradeType.TERRAN_VEHICLE_PLATING;
        gNamesToUpgradeTypes.put("Terran Ship Plating",
                UpgradeType.TERRAN_SHIP_PLATING);
        allUpgradeTypes.add(UpgradeType.TERRAN_SHIP_PLATING);
        gIdsToUpgradeTypes[2] = UpgradeType.TERRAN_SHIP_PLATING;
        gNamesToUpgradeTypes.put("Zerg Carapace", UpgradeType.ZERG_CARAPACE);
        allUpgradeTypes.add(UpgradeType.ZERG_CARAPACE);
        gIdsToUpgradeTypes[3] = UpgradeType.ZERG_CARAPACE;
        gNamesToUpgradeTypes.put("Zerg Flyer Carapace",
                UpgradeType.ZERG_FLYER_CARAPACE);
        allUpgradeTypes.add(UpgradeType.ZERG_FLYER_CARAPACE);
        gIdsToUpgradeTypes[4] = UpgradeType.ZERG_FLYER_CARAPACE;
        gNamesToUpgradeTypes.put("Protoss Armor", UpgradeType.PROTOSS_ARMOR);
        allUpgradeTypes.add(UpgradeType.PROTOSS_ARMOR);
        gIdsToUpgradeTypes[5] = UpgradeType.PROTOSS_ARMOR;
        gNamesToUpgradeTypes
                .put("Protoss Plating", UpgradeType.PROTOSS_PLATING);
        allUpgradeTypes.add(UpgradeType.PROTOSS_PLATING);
        gIdsToUpgradeTypes[6] = UpgradeType.PROTOSS_PLATING;
        gNamesToUpgradeTypes.put("Terran Infantry Weapons",
                UpgradeType.TERRAN_INFANTRY_WEAPONS);
        allUpgradeTypes.add(UpgradeType.TERRAN_INFANTRY_WEAPONS);
        gIdsToUpgradeTypes[7] = UpgradeType.TERRAN_INFANTRY_WEAPONS;
        gNamesToUpgradeTypes.put("Terran Vehicle Weapons",
                UpgradeType.TERRAN_VEHICLE_WEAPONS);
        allUpgradeTypes.add(UpgradeType.TERRAN_VEHICLE_WEAPONS);
        gIdsToUpgradeTypes[8] = UpgradeType.TERRAN_VEHICLE_WEAPONS;
        gNamesToUpgradeTypes.put("Terran Ship Weapons",
                UpgradeType.TERRAN_SHIP_WEAPONS);
        allUpgradeTypes.add(UpgradeType.TERRAN_SHIP_WEAPONS);
        gIdsToUpgradeTypes[9] = UpgradeType.TERRAN_SHIP_WEAPONS;
        gNamesToUpgradeTypes.put("Zerg Melee Attacks",
                UpgradeType.ZERG_MELEE_ATTACKS);
        allUpgradeTypes.add(UpgradeType.ZERG_MELEE_ATTACKS);
        gIdsToUpgradeTypes[10] = UpgradeType.ZERG_MELEE_ATTACKS;
        gNamesToUpgradeTypes.put("Zerg Missile Attacks",
                UpgradeType.ZERG_MISSILE_ATTACKS);
        allUpgradeTypes.add(UpgradeType.ZERG_MISSILE_ATTACKS);
        gIdsToUpgradeTypes[11] = UpgradeType.ZERG_MISSILE_ATTACKS;
        gNamesToUpgradeTypes.put("Zerg Flyer Attacks",
                UpgradeType.ZERG_FLYER_ATTACKS);
        allUpgradeTypes.add(UpgradeType.ZERG_FLYER_ATTACKS);
        gIdsToUpgradeTypes[12] = UpgradeType.ZERG_FLYER_ATTACKS;
        gNamesToUpgradeTypes.put("Protoss Ground Weapons",
                UpgradeType.PROTOSS_GROUND_WEAPONS);
        allUpgradeTypes.add(UpgradeType.PROTOSS_GROUND_WEAPONS);
        gIdsToUpgradeTypes[13] = UpgradeType.PROTOSS_GROUND_WEAPONS;
        gNamesToUpgradeTypes.put("Protoss Air Weapons",
                UpgradeType.PROTOSS_AIR_WEAPONS);
        allUpgradeTypes.add(UpgradeType.PROTOSS_AIR_WEAPONS);
        gIdsToUpgradeTypes[14] = UpgradeType.PROTOSS_AIR_WEAPONS;
        gNamesToUpgradeTypes.put("Protoss Plasma Shields",
                UpgradeType.PROTOSS_PLASMA_SHIELDS);
        allUpgradeTypes.add(UpgradeType.PROTOSS_PLASMA_SHIELDS);
        gIdsToUpgradeTypes[15] = UpgradeType.PROTOSS_PLASMA_SHIELDS;
        gNamesToUpgradeTypes.put("U-238 Shells", UpgradeType.U_238_SHELLS);
        allUpgradeTypes.add(UpgradeType.U_238_SHELLS);
        gIdsToUpgradeTypes[16] = UpgradeType.U_238_SHELLS;
        gNamesToUpgradeTypes.put("Ion Thrusters", UpgradeType.ION_THRUSTERS);
        allUpgradeTypes.add(UpgradeType.ION_THRUSTERS);
        gIdsToUpgradeTypes[17] = UpgradeType.ION_THRUSTERS;
        gNamesToUpgradeTypes.put("Titan Reactor", UpgradeType.TITAN_REACTOR);
        allUpgradeTypes.add(UpgradeType.TITAN_REACTOR);
        gIdsToUpgradeTypes[19] = UpgradeType.TITAN_REACTOR;
        gNamesToUpgradeTypes
                .put("Ocular Implants", UpgradeType.OCULAR_IMPLANTS);
        allUpgradeTypes.add(UpgradeType.OCULAR_IMPLANTS);
        gIdsToUpgradeTypes[20] = UpgradeType.OCULAR_IMPLANTS;
        gNamesToUpgradeTypes
                .put("Moebius Reactor", UpgradeType.MOEBIUS_REACTOR);
        allUpgradeTypes.add(UpgradeType.MOEBIUS_REACTOR);
        gIdsToUpgradeTypes[21] = UpgradeType.MOEBIUS_REACTOR;
        gNamesToUpgradeTypes.put("Apollo Reactor", UpgradeType.APOLLO_REACTOR);
        allUpgradeTypes.add(UpgradeType.APOLLO_REACTOR);
        gIdsToUpgradeTypes[22] = UpgradeType.APOLLO_REACTOR;
        gNamesToUpgradeTypes.put("Colossus Reactor",
                UpgradeType.COLOSSUS_REACTOR);
        allUpgradeTypes.add(UpgradeType.COLOSSUS_REACTOR);
        gIdsToUpgradeTypes[23] = UpgradeType.COLOSSUS_REACTOR;
        gNamesToUpgradeTypes.put("Ventral Sacs", UpgradeType.VENTRAL_SACS);
        allUpgradeTypes.add(UpgradeType.VENTRAL_SACS);
        gIdsToUpgradeTypes[24] = UpgradeType.VENTRAL_SACS;
        gNamesToUpgradeTypes.put("Antennae", UpgradeType.ANTENNAE);
        allUpgradeTypes.add(UpgradeType.ANTENNAE);
        gIdsToUpgradeTypes[25] = UpgradeType.ANTENNAE;
        gNamesToUpgradeTypes.put("Pneumatized Carapace",
                UpgradeType.PNEUMATIZED_CARAPACE);
        allUpgradeTypes.add(UpgradeType.PNEUMATIZED_CARAPACE);
        gIdsToUpgradeTypes[26] = UpgradeType.PNEUMATIZED_CARAPACE;
        gNamesToUpgradeTypes
                .put("Metabolic Boost", UpgradeType.METABOLIC_BOOST);
        allUpgradeTypes.add(UpgradeType.METABOLIC_BOOST);
        gIdsToUpgradeTypes[27] = UpgradeType.METABOLIC_BOOST;
        gNamesToUpgradeTypes.put("Adrenal Glands", UpgradeType.ADRENAL_GLANDS);
        allUpgradeTypes.add(UpgradeType.ADRENAL_GLANDS);
        gIdsToUpgradeTypes[28] = UpgradeType.ADRENAL_GLANDS;
        gNamesToUpgradeTypes.put("Muscular Augments",
                UpgradeType.MUSCULAR_AUGMENTS);
        allUpgradeTypes.add(UpgradeType.MUSCULAR_AUGMENTS);
        gIdsToUpgradeTypes[29] = UpgradeType.MUSCULAR_AUGMENTS;
        gNamesToUpgradeTypes.put("Grooved Spines", UpgradeType.GROOVED_SPINES);
        allUpgradeTypes.add(UpgradeType.GROOVED_SPINES);
        gIdsToUpgradeTypes[30] = UpgradeType.GROOVED_SPINES;
        gNamesToUpgradeTypes.put("Gamete Meiosis", UpgradeType.GAMETE_MEIOSIS);
        allUpgradeTypes.add(UpgradeType.GAMETE_MEIOSIS);
        gIdsToUpgradeTypes[31] = UpgradeType.GAMETE_MEIOSIS;
        gNamesToUpgradeTypes.put("Metasynaptic Node",
                UpgradeType.METASYNAPTIC_NODE);
        allUpgradeTypes.add(UpgradeType.METASYNAPTIC_NODE);
        gIdsToUpgradeTypes[32] = UpgradeType.METASYNAPTIC_NODE;
        gNamesToUpgradeTypes.put("Singularity Charge",
                UpgradeType.SINGULARITY_CHARGE);
        allUpgradeTypes.add(UpgradeType.SINGULARITY_CHARGE);
        gIdsToUpgradeTypes[33] = UpgradeType.SINGULARITY_CHARGE;
        gNamesToUpgradeTypes.put("Leg Enhancements",
                UpgradeType.LEG_ENHANCEMENTS);
        allUpgradeTypes.add(UpgradeType.LEG_ENHANCEMENTS);
        gIdsToUpgradeTypes[34] = UpgradeType.LEG_ENHANCEMENTS;
        gNamesToUpgradeTypes.put("Scarab Damage", UpgradeType.SCARAB_DAMAGE);
        allUpgradeTypes.add(UpgradeType.SCARAB_DAMAGE);
        gIdsToUpgradeTypes[35] = UpgradeType.SCARAB_DAMAGE;
        gNamesToUpgradeTypes
                .put("Reaver Capacity", UpgradeType.REAVER_CAPACITY);
        allUpgradeTypes.add(UpgradeType.REAVER_CAPACITY);
        gIdsToUpgradeTypes[36] = UpgradeType.REAVER_CAPACITY;
        gNamesToUpgradeTypes.put("Gravitic Drive", UpgradeType.GRAVITIC_DRIVE);
        allUpgradeTypes.add(UpgradeType.GRAVITIC_DRIVE);
        gIdsToUpgradeTypes[37] = UpgradeType.GRAVITIC_DRIVE;
        gNamesToUpgradeTypes.put("Sensor Array", UpgradeType.SENSOR_ARRAY);
        allUpgradeTypes.add(UpgradeType.SENSOR_ARRAY);
        gIdsToUpgradeTypes[38] = UpgradeType.SENSOR_ARRAY;
        gNamesToUpgradeTypes.put("Gravitic Boosters",
                UpgradeType.GRAVITIC_BOOSTERS);
        allUpgradeTypes.add(UpgradeType.GRAVITIC_BOOSTERS);
        gIdsToUpgradeTypes[39] = UpgradeType.GRAVITIC_BOOSTERS;
        gNamesToUpgradeTypes.put("Khaydarin Amulet",
                UpgradeType.KHAYDARIN_AMULET);
        allUpgradeTypes.add(UpgradeType.KHAYDARIN_AMULET);
        gIdsToUpgradeTypes[40] = UpgradeType.KHAYDARIN_AMULET;
        gNamesToUpgradeTypes.put("Apial Sensors", UpgradeType.APIAL_SENSORS);
        allUpgradeTypes.add(UpgradeType.APIAL_SENSORS);
        gIdsToUpgradeTypes[41] = UpgradeType.APIAL_SENSORS;
        gNamesToUpgradeTypes.put("Gravitic Thrusters",
                UpgradeType.GRAVITIC_THRUSTERS);
        allUpgradeTypes.add(UpgradeType.GRAVITIC_THRUSTERS);
        gIdsToUpgradeTypes[42] = UpgradeType.GRAVITIC_THRUSTERS;
        gNamesToUpgradeTypes.put("Carrier Capacity",
                UpgradeType.CARRIER_CAPACITY);
        allUpgradeTypes.add(UpgradeType.CARRIER_CAPACITY);
        gIdsToUpgradeTypes[43] = UpgradeType.CARRIER_CAPACITY;
        gNamesToUpgradeTypes.put("Khaydarin Core", UpgradeType.KHAYDARIN_CORE);
        allUpgradeTypes.add(UpgradeType.KHAYDARIN_CORE);
        gIdsToUpgradeTypes[44] = UpgradeType.KHAYDARIN_CORE;
        gNamesToUpgradeTypes.put("Argus Jewel", UpgradeType.ARGUS_JEWEL);
        allUpgradeTypes.add(UpgradeType.ARGUS_JEWEL);
        gIdsToUpgradeTypes[47] = UpgradeType.ARGUS_JEWEL;
        gNamesToUpgradeTypes.put("Argus Talisman", UpgradeType.ARGUS_TALISMAN);
        allUpgradeTypes.add(UpgradeType.ARGUS_TALISMAN);
        gIdsToUpgradeTypes[49] = UpgradeType.ARGUS_TALISMAN;
        gNamesToUpgradeTypes.put("Caduceus Reactor",
                UpgradeType.CADUCEUS_REACTOR);
        allUpgradeTypes.add(UpgradeType.CADUCEUS_REACTOR);
        gIdsToUpgradeTypes[51] = UpgradeType.CADUCEUS_REACTOR;
        gNamesToUpgradeTypes.put("Chitinous Plating",
                UpgradeType.CHITINOUS_PLATING);
        allUpgradeTypes.add(UpgradeType.CHITINOUS_PLATING);
        gIdsToUpgradeTypes[52] = UpgradeType.CHITINOUS_PLATING;
        gNamesToUpgradeTypes.put("Anabolic Synthesis",
                UpgradeType.ANABOLIC_SYNTHESIS);
        allUpgradeTypes.add(UpgradeType.ANABOLIC_SYNTHESIS);
        gIdsToUpgradeTypes[53] = UpgradeType.ANABOLIC_SYNTHESIS;
        gNamesToUpgradeTypes.put("Charon Booster", UpgradeType.CHARON_BOOSTER);
        allUpgradeTypes.add(UpgradeType.CHARON_BOOSTER);
        gIdsToUpgradeTypes[54] = UpgradeType.CHARON_BOOSTER;
        gNamesToUpgradeTypes.put("None", UpgradeType.NONE);
        allUpgradeTypes.add(UpgradeType.NONE);
        gIdsToUpgradeTypes[61] = UpgradeType.NONE;
        gNamesToUpgradeTypes.put("Unknown", UpgradeType.UNKNOWN);
        allUpgradeTypes.add(UpgradeType.UNKNOWN);
        gIdsToUpgradeTypes[62] = UpgradeType.UNKNOWN;
        gAllUpgradeTypes = Collections.unmodifiableSet(allUpgradeTypes);
    }

    public static final UpgradeType getUpgradeType(String name) {
        return gNamesToUpgradeTypes.get(name);
    }

    public static final Set<UpgradeType> allUpgradeTypes() {
        return gAllUpgradeTypes;
    }

    static final UpgradeType getUpgradeTypeFromId(int id) {
        return gIdsToUpgradeTypes[id];
    }

    static final int getMaxIdPlusOne() {
        return gIdsToUpgradeTypes.length;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        } else if (this instanceof UpgradeType) {
            final UpgradeType other = (UpgradeType) object;
            return this.id == other.id;
        } else {
            return false;
        }
    }

    public final int hashCode() {
        return this.id;
    }

    GameMessages.UpgradeType getTypeMessage() {
        return GameMessages.UpgradeType.newBuilder().setId(this.id).build();
    }
}
