package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.messages.GameMessages.UnitTypeIntPair;

public final class UnitType {
	@Override
	public String toString() {
		return "UnitType [" + getName() + "]";
	}

	protected int id;

	protected UnitType(int id) {
		this.id = id;
	}

	protected UnitType(GameMessages.UnitType type) {
		this.id = type.getId();
	}

	public final int getID() {
		return id;
	}

	private GameMessages.UnitTypeData getData() {
		return data.get(getID());
	}

	public String getName() {
		return getData().getName();
	}

	public String getSubLabel() {
		return getData().getSublabel();
	}

	public Race getRace() {
		getData();
		getData().getRace();
		getData().getRace().getNumber();
		return Race.getRaceFromId(getData().getRace().getNumber());
	}

	public Map.Entry<UnitType, Integer> whatBuilds() {
		final UnitType type = new UnitType(getData().getWhatBuildsType().getId());
		final int n = getData().getWhatBuildsNumber();
		return new Map.Entry<UnitType, Integer>() {

			@Override
			public UnitType getKey() {
				return type;
			}

			@Override
			public Integer getValue() {
				return n;
			}

			@Override
			public Integer setValue(Integer arg0) {
				throw new UnsupportedOperationException("Can't set this value.");
			}
		};
	}

	public Map<UnitType, Integer> requiredUnits() {
		Map<UnitType, Integer> ret = new HashMap<UnitType, Integer>();
		for (UnitTypeIntPair pair : getData().getRequiredUnitsList()) {
			UnitType type = new UnitType(pair.getType());
			int n = pair.getCount();
			ret.put(type, n);
		}
		return ret;
	}

	public TechType requiredTech() {
		return new TechType(getData().getRequiredTech());
	}

	public Set<TechType> abilities() {
		HashSet<TechType> techs = new HashSet<TechType>();
		for (GameMessages.TechType t : getData().getAbilitiesList()) {
			techs.add(new TechType(t));
		}
		return techs;
	}

	public Set<UpgradeType> upgrades() {
		HashSet<UpgradeType> techs = new HashSet<UpgradeType>();
		for (GameMessages.UpgradeType t : getData().getUpgradesList()) {
			techs.add(new UpgradeType(t));
		}
		return techs;
	}

	public UpgradeType armorUpgrade() {
		return new UpgradeType(getData().getArmorUpgrade());
	}

	public int maxHitPoints() {
		return getData().getMaxHitPoints();
	}

	public int maxShields() {
		return getData().getMaxShields();
	}

	public int maxEnergy() {
		return getData().getMaxEnergy();
	}

	public int armor() {
		return getData().getArmor();
	}

	public int mineralPrice() {
		return getData().getMineralPrice();
	}

	public int gasPrice() {
		return getData().getGasPrice();
	}

	public int buildTime() {
		return getData().getBuildTime();
	}

	public int supplyRequired() {
		return getData().getSupplyRequired();
	}

	public int supplyProvided() {
		return getData().getSupplyProvided();
	}

	public int spaceRequired() {
		return getData().getSpaceRequired();
	}

	public int spaceProvided() {
		return getData().getSpaceProvided();
	}

	public int buildScore() {
		return getData().getBuildScore();
	}

	public int destroyScore() {
		return getData().getDestroyScore();
	}

	public UnitSizeType size() {
		return UnitSizeType.values()[getData().getSize().getNumber()];
	}

	public int tileWidth() {
		return getData().getTileWidth();
	}

	public int tileHeight() {
		return getData().getTileHeight();
	}

	public int dimensionLeft() {
		return getData().getDimensionLeft();
	}

	public int dimensionUp() {
		return getData().getDimensionUp();
	}

	public int dimensionRight() {
		return getData().getDimensionRight();
	}

	public int dimensionDown() {
		return getData().getDimensionDown();
	}

	public int seekRange() {
		return getData().getSeekRange();
	}

	public int sightRange() {
		return getData().getSightRange();
	}

	public WeaponType groundWeapon() {
		return new WeaponType(getData().getGroundWeapon());
	}

	public int maxGroundHits() {
		return getData().getMaxGroundHits();
	}

	public WeaponType airWeapon() {
		return new WeaponType(getData().getAirWeapon());
	}

	public int maxAirHits() {
		return getData().getMaxAirHits();
	}

	public double topSpeed() {
		return getData().getTopSpeed();
	}

	public int acceleration() {
		return getData().getAcceleration();
	}

	public int haltDistance() {
		return getData().getHaltDistance();
	}

	public int turnRadius() {
		return getData().getTurnRadius();
	}

	public boolean canProduce() {
		return getData().getCanProduce();
	}

	public boolean canAttack() {
		return getData().getCanAttack();
	}

	public boolean canMove() {
		return getData().getCanMove();
	}

	public boolean isFlyer() {
		return getData().getIsFlyer();
	}

	public boolean regeneratesHP() {
		return getData().getRegeneratesHP();
	}

	public boolean isSpellcaster() {
		return getData().getIsSpellcaster();
	}

	public boolean hasPermanentCloak() {
		return getData().getHasPermanentCloak();
	}

	public boolean isInvincible() {
		return getData().getIsInvincible();
	}

	public boolean isOrganic() {
		return getData().getIsOrganic();
	}

	public boolean isMechanical() {
		return getData().getIsMechanical();
	}

	public boolean isRobotic() {
		return getData().getIsRobotic();
	}

	public boolean isDetector() {
		return getData().getIsDetector();
	}

	public boolean isResourceContainer() {
		return getData().getIsResourceContainer();
	}

	public boolean isResourceDepot() {
		return getData().getIsResourceDepot();
	}

	public boolean isRefinery() {
		return getData().getIsRefinery();
	}

	public boolean isWorker() {
		return getData().getIsWorker();
	}

	public boolean requiresPsi() {
		return getData().getRequiresPsi();
	}

	public boolean requiresCreep() {
		return getData().getRequiresCreep();
	}

	public boolean isTwoUnitsInOneEgg() {
		return getData().getIsTwoUnitsInOneEgg();
	}

	public boolean isBurrowable() {
		return getData().getIsBurrowable();
	}

	public boolean isCloakable() {
		return getData().getIsCloakable();
	}

	public boolean isBuilding() {
		return getData().getIsBuilding();
	}

	public boolean isAddon() {
		return getData().getIsAddon();
	}

	public boolean isFlyingBuilding() {
		return getData().getIsFlyingBuilding();
	}

	public boolean isNeutral() {
		return getData().getIsNeutral();
	}

	// Additional getter
	public boolean hasAirAreaOfEffectAttack() {
		return equals(UnitType.PROTOSS_HIGH_TEMPLAR) || equals(UnitType.PROTOSS_CORSAIR) || equals(UnitType.PROTOSS_ARCHON)
		    || equals(UnitType.PROTOSS_DARK_ARCHON) || equals(UnitType.ZERG_DEFILER) || equals(UnitType.ZERG_QUEEN)
		    || equals(UnitType.TERRAN_SCIENCE_VESSEL) || equals(UnitType.TERRAN_VALKYRIE);
	}

	public boolean hasGroundAreaOfEffectAttack() {
		return equals(UnitType.PROTOSS_HIGH_TEMPLAR) || equals(UnitType.PROTOSS_REAVER) || equals(UnitType.PROTOSS_ARCHON)
		    || equals(UnitType.PROTOSS_DARK_ARCHON) || equals(UnitType.ZERG_DEFILER) || equals(UnitType.ZERG_QUEEN)
		    || equals(UnitType.ZERG_LURKER) || equals(UnitType.ZERG_INFESTED_TERRAN)
		    || equals(UnitType.TERRAN_SCIENCE_VESSEL) || equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE);
	}

	public double diagonalLength() {
		double halfWidth = Math.max(dimensionLeft(), dimensionRight());
		double halfHeight = Math.max(dimensionUp(), dimensionDown());
		return Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
	}

	WeaponType pickWeapon(boolean vsAir) {
		return vsAir ? airWeapon() : groundWeapon();
	}

	public static UnitType myWorkerType() {
		return Game.getInstance().self().getRace().getWorker();
	}

	protected static final Map<String, UnitType> unitTypesByName = new HashMap<String, UnitType>();
	protected static final Set<UnitType> gAllUnitTypes;
	protected static final UnitType[] unitTypesById;

	protected static List<GameMessages.UnitTypeData> data;

	static void setUnitTypes(List<GameMessages.UnitTypeData> _data) {
		data = new ArrayList<GameMessages.UnitTypeData>(_data);
	}

	public static final UnitType TERRAN_MARINE = new UnitType(0);
	public static final UnitType TERRAN_GHOST = new UnitType(1);
	public static final UnitType TERRAN_VULTURE = new UnitType(2);
	public static final UnitType TERRAN_GOLIATH = new UnitType(3);
	public static final UnitType TERRAN_SIEGE_TANK_TANK_MODE = new UnitType(5);
	public static final UnitType TERRAN_SCV = new UnitType(7);
	public static final UnitType TERRAN_WRAITH = new UnitType(8);
	public static final UnitType TERRAN_SCIENCE_VESSEL = new UnitType(9);
	public static final UnitType TERRAN_DROPSHIP = new UnitType(11);
	public static final UnitType TERRAN_BATTLECRUISER = new UnitType(12);
	public static final UnitType TERRAN_VULTURE_SPIDER_MINE = new UnitType(13);
	public static final UnitType TERRAN_NUCLEAR_MISSILE = new UnitType(14);
	public static final UnitType TERRAN_SIEGE_TANK_SIEGE_MODE = new UnitType(30);
	public static final UnitType TERRAN_FIREBAT = new UnitType(32);
	public static final UnitType SPELL_SCANNER_SWEEP = new UnitType(33);
	public static final UnitType TERRAN_MEDIC = new UnitType(34);
	public static final UnitType ZERG_LARVA = new UnitType(35);
	public static final UnitType ZERG_EGG = new UnitType(36);
	public static final UnitType ZERG_ZERGLING = new UnitType(37);
	public static final UnitType ZERG_HYDRALISK = new UnitType(38);
	public static final UnitType ZERG_ULTRALISK = new UnitType(39);
	public static final UnitType ZERG_BROODLING = new UnitType(40);
	public static final UnitType ZERG_DRONE = new UnitType(41);
	public static final UnitType ZERG_OVERLORD = new UnitType(42);
	public static final UnitType ZERG_MUTALISK = new UnitType(43);
	public static final UnitType ZERG_GUARDIAN = new UnitType(44);
	public static final UnitType ZERG_QUEEN = new UnitType(45);
	public static final UnitType ZERG_DEFILER = new UnitType(46);
	public static final UnitType ZERG_SCOURGE = new UnitType(47);
	public static final UnitType ZERG_INFESTED_TERRAN = new UnitType(50);
	public static final UnitType TERRAN_VALKYRIE = new UnitType(58);
	public static final UnitType ZERG_COCOON = new UnitType(59);
	public static final UnitType PROTOSS_CORSAIR = new UnitType(60);
	public static final UnitType PROTOSS_DARK_TEMPLAR = new UnitType(61);
	public static final UnitType ZERG_DEVOURER = new UnitType(62);
	public static final UnitType PROTOSS_DARK_ARCHON = new UnitType(63);
	public static final UnitType PROTOSS_PROBE = new UnitType(64);
	public static final UnitType PROTOSS_ZEALOT = new UnitType(65);
	public static final UnitType PROTOSS_DRAGOON = new UnitType(66);
	public static final UnitType PROTOSS_HIGH_TEMPLAR = new UnitType(67);
	public static final UnitType PROTOSS_ARCHON = new UnitType(68);
	public static final UnitType PROTOSS_SHUTTLE = new UnitType(69);
	public static final UnitType PROTOSS_SCOUT = new UnitType(70);
	public static final UnitType PROTOSS_ARBITER = new UnitType(71);
	public static final UnitType PROTOSS_CARRIER = new UnitType(72);
	public static final UnitType PROTOSS_INTERCEPTOR = new UnitType(73);
	public static final UnitType PROTOSS_REAVER = new UnitType(83);
	public static final UnitType PROTOSS_OBSERVER = new UnitType(84);
	public static final UnitType PROTOSS_SCARAB = new UnitType(85);
	public static final UnitType CRITTER_RHYNADON = new UnitType(89);
	public static final UnitType CRITTER_BENGALAAS = new UnitType(90);
	public static final UnitType CRITTER_SCANTID = new UnitType(93);
	public static final UnitType CRITTER_KAKARU = new UnitType(94);
	public static final UnitType CRITTER_RAGNASAUR = new UnitType(95);
	public static final UnitType CRITTER_URSADON = new UnitType(96);
	public static final UnitType ZERG_LURKER_EGG = new UnitType(97);
	public static final UnitType ZERG_LURKER = new UnitType(103);
	public static final UnitType SPELL_DISRUPTION_WEB = new UnitType(105);
	public static final UnitType TERRAN_COMMAND_CENTER = new UnitType(106);
	public static final UnitType TERRAN_COMSAT_STATION = new UnitType(107);
	public static final UnitType TERRAN_NUCLEAR_SILO = new UnitType(108);
	public static final UnitType TERRAN_SUPPLY_DEPOT = new UnitType(109);
	public static final UnitType TERRAN_REFINERY = new UnitType(110);
	public static final UnitType TERRAN_BARRACKS = new UnitType(111);
	public static final UnitType TERRAN_ACADEMY = new UnitType(112);
	public static final UnitType TERRAN_FACTORY = new UnitType(113);
	public static final UnitType TERRAN_STARPORT = new UnitType(114);
	public static final UnitType TERRAN_CONTROL_TOWER = new UnitType(115);
	public static final UnitType TERRAN_SCIENCE_FACILITY = new UnitType(116);
	public static final UnitType TERRAN_COVERT_OPS = new UnitType(117);
	public static final UnitType TERRAN_PHYSICS_LAB = new UnitType(118);
	public static final UnitType TERRAN_MACHINE_SHOP = new UnitType(120);
	public static final UnitType TERRAN_ENGINEERING_BAY = new UnitType(122);
	public static final UnitType TERRAN_ARMORY = new UnitType(123);
	public static final UnitType TERRAN_MISSILE_TURRET = new UnitType(124);
	public static final UnitType TERRAN_BUNKER = new UnitType(125);
	public static final UnitType SPECIAL_CRASHED_NORAD_II = new UnitType(126);
	public static final UnitType SPECIAL_ION_CANNON = new UnitType(127);
	public static final UnitType ZERG_INFESTED_COMMAND_CENTER = new UnitType(130);
	public static final UnitType ZERG_HATCHERY = new UnitType(131);
	public static final UnitType ZERG_LAIR = new UnitType(132);
	public static final UnitType ZERG_HIVE = new UnitType(133);
	public static final UnitType ZERG_NYDUS_CANAL = new UnitType(134);
	public static final UnitType ZERG_HYDRALISK_DEN = new UnitType(135);
	public static final UnitType ZERG_DEFILER_MOUND = new UnitType(136);
	public static final UnitType ZERG_GREATER_SPIRE = new UnitType(137);
	public static final UnitType ZERG_QUEENS_NEST = new UnitType(138);
	public static final UnitType ZERG_EVOLUTION_CHAMBER = new UnitType(139);
	public static final UnitType ZERG_ULTRALISK_CAVERN = new UnitType(140);
	public static final UnitType ZERG_SPIRE = new UnitType(141);
	public static final UnitType ZERG_SPAWNING_POOL = new UnitType(142);
	public static final UnitType ZERG_CREEP_COLONY = new UnitType(143);
	public static final UnitType ZERG_SPORE_COLONY = new UnitType(144);
	public static final UnitType ZERG_SUNKEN_COLONY = new UnitType(146);
	public static final UnitType SPECIAL_OVERMIND_WITH_SHELL = new UnitType(147);
	public static final UnitType SPECIAL_OVERMIND = new UnitType(148);
	public static final UnitType ZERG_EXTRACTOR = new UnitType(149);
	public static final UnitType SPECIAL_MATURE_CHRYSALIS = new UnitType(150);
	public static final UnitType SPECIAL_CEREBRATE = new UnitType(151);
	public static final UnitType SPECIAL_CEREBRATE_DAGGOTH = new UnitType(152);
	public static final UnitType PROTOSS_NEXUS = new UnitType(154);
	public static final UnitType PROTOSS_ROBOTICS_FACILITY = new UnitType(155);
	public static final UnitType PROTOSS_PYLON = new UnitType(156);
	public static final UnitType PROTOSS_ASSIMILATOR = new UnitType(157);
	public static final UnitType PROTOSS_OBSERVATORY = new UnitType(159);
	public static final UnitType PROTOSS_GATEWAY = new UnitType(160);
	public static final UnitType PROTOSS_PHOTON_CANNON = new UnitType(162);
	public static final UnitType PROTOSS_CITADEL_OF_ADUN = new UnitType(163);
	public static final UnitType PROTOSS_CYBERNETICS_CORE = new UnitType(164);
	public static final UnitType PROTOSS_TEMPLAR_ARCHIVES = new UnitType(165);
	public static final UnitType PROTOSS_FORGE = new UnitType(166);
	public static final UnitType PROTOSS_STARGATE = new UnitType(167);
	public static final UnitType SPECIAL_STASIS_CELL_PRISON = new UnitType(168);
	public static final UnitType PROTOSS_FLEET_BEACON = new UnitType(169);
	public static final UnitType PROTOSS_ARBITER_TRIBUNAL = new UnitType(170);
	public static final UnitType PROTOSS_ROBOTICS_SUPPORT_BAY = new UnitType(171);
	public static final UnitType PROTOSS_SHIELD_BATTERY = new UnitType(172);
	public static final UnitType SPECIAL_KHAYDARIN_CRYSTAL_FORM = new UnitType(173);
	public static final UnitType SPECIAL_PROTOSS_TEMPLE = new UnitType(174);
	public static final UnitType SPECIAL_XEL_NAGA_TEMPLE = new UnitType(175);
	public static final UnitType RESOURCE_MINERAL_FIELD = new UnitType(176);
	public static final UnitType RESOURCE_VESPENE_GEYSER = new UnitType(188);
	public static final UnitType SPECIAL_WARP_GATE = new UnitType(189);
	public static final UnitType SPECIAL_PSI_DISRUPTER = new UnitType(190);
	public static final UnitType SPECIAL_POWER_GENERATOR = new UnitType(200);
	public static final UnitType SPECIAL_OVERMIND_COCOON = new UnitType(201);
	public static final UnitType SPELL_DARK_SWARM = new UnitType(202);
	public static final UnitType NONE = new UnitType(228);
	public static final UnitType UNKNOWN = new UnitType(233);

	static {
		Set<UnitType> allUnitTypes = new HashSet<UnitType>();
		unitTypesById = new UnitType[234];
		unitTypesByName.put("Terran Marine", UnitType.TERRAN_MARINE);
		allUnitTypes.add(UnitType.TERRAN_MARINE);
		unitTypesById[0] = UnitType.TERRAN_MARINE;
		unitTypesByName.put("Terran Ghost", UnitType.TERRAN_GHOST);
		allUnitTypes.add(UnitType.TERRAN_GHOST);
		unitTypesById[1] = UnitType.TERRAN_GHOST;
		unitTypesByName.put("Terran Vulture", UnitType.TERRAN_VULTURE);
		allUnitTypes.add(UnitType.TERRAN_VULTURE);
		unitTypesById[2] = UnitType.TERRAN_VULTURE;
		unitTypesByName.put("Terran Goliath", UnitType.TERRAN_GOLIATH);
		allUnitTypes.add(UnitType.TERRAN_GOLIATH);
		unitTypesById[3] = UnitType.TERRAN_GOLIATH;
		unitTypesByName.put("Terran Siege Tank Tank Mode", UnitType.TERRAN_SIEGE_TANK_TANK_MODE);
		allUnitTypes.add(UnitType.TERRAN_SIEGE_TANK_TANK_MODE);
		unitTypesById[5] = UnitType.TERRAN_SIEGE_TANK_TANK_MODE;
		unitTypesByName.put("Terran SCV", UnitType.TERRAN_SCV);
		allUnitTypes.add(UnitType.TERRAN_SCV);
		unitTypesById[7] = UnitType.TERRAN_SCV;
		unitTypesByName.put("Terran Wraith", UnitType.TERRAN_WRAITH);
		allUnitTypes.add(UnitType.TERRAN_WRAITH);
		unitTypesById[8] = UnitType.TERRAN_WRAITH;
		unitTypesByName.put("Terran Science Vessel", UnitType.TERRAN_SCIENCE_VESSEL);
		allUnitTypes.add(UnitType.TERRAN_SCIENCE_VESSEL);
		unitTypesById[9] = UnitType.TERRAN_SCIENCE_VESSEL;
		unitTypesByName.put("Terran Dropship", UnitType.TERRAN_DROPSHIP);
		allUnitTypes.add(UnitType.TERRAN_DROPSHIP);
		unitTypesById[11] = UnitType.TERRAN_DROPSHIP;
		unitTypesByName.put("Terran Battlecruiser", UnitType.TERRAN_BATTLECRUISER);
		allUnitTypes.add(UnitType.TERRAN_BATTLECRUISER);
		unitTypesById[12] = UnitType.TERRAN_BATTLECRUISER;
		unitTypesByName.put("Terran Vulture Spider Mine", UnitType.TERRAN_VULTURE_SPIDER_MINE);
		allUnitTypes.add(UnitType.TERRAN_VULTURE_SPIDER_MINE);
		unitTypesById[13] = UnitType.TERRAN_VULTURE_SPIDER_MINE;
		unitTypesByName.put("Terran Nuclear Missile", UnitType.TERRAN_NUCLEAR_MISSILE);
		allUnitTypes.add(UnitType.TERRAN_NUCLEAR_MISSILE);
		unitTypesById[14] = UnitType.TERRAN_NUCLEAR_MISSILE;
		unitTypesByName.put("Terran Siege Tank Siege Mode", UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE);
		allUnitTypes.add(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE);
		unitTypesById[30] = UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE;
		unitTypesByName.put("Terran Firebat", UnitType.TERRAN_FIREBAT);
		allUnitTypes.add(UnitType.TERRAN_FIREBAT);
		unitTypesById[32] = UnitType.TERRAN_FIREBAT;
		unitTypesByName.put("Spell Scanner Sweep", UnitType.SPELL_SCANNER_SWEEP);
		allUnitTypes.add(UnitType.SPELL_SCANNER_SWEEP);
		unitTypesById[33] = UnitType.SPELL_SCANNER_SWEEP;
		unitTypesByName.put("Terran Medic", UnitType.TERRAN_MEDIC);
		allUnitTypes.add(UnitType.TERRAN_MEDIC);
		unitTypesById[34] = UnitType.TERRAN_MEDIC;
		unitTypesByName.put("Zerg Larva", UnitType.ZERG_LARVA);
		allUnitTypes.add(UnitType.ZERG_LARVA);
		unitTypesById[35] = UnitType.ZERG_LARVA;
		unitTypesByName.put("Zerg Egg", UnitType.ZERG_EGG);
		allUnitTypes.add(UnitType.ZERG_EGG);
		unitTypesById[36] = UnitType.ZERG_EGG;
		unitTypesByName.put("Zerg Zergling", UnitType.ZERG_ZERGLING);
		allUnitTypes.add(UnitType.ZERG_ZERGLING);
		unitTypesById[37] = UnitType.ZERG_ZERGLING;
		unitTypesByName.put("Zerg Hydralisk", UnitType.ZERG_HYDRALISK);
		allUnitTypes.add(UnitType.ZERG_HYDRALISK);
		unitTypesById[38] = UnitType.ZERG_HYDRALISK;
		unitTypesByName.put("Zerg Ultralisk", UnitType.ZERG_ULTRALISK);
		allUnitTypes.add(UnitType.ZERG_ULTRALISK);
		unitTypesById[39] = UnitType.ZERG_ULTRALISK;
		unitTypesByName.put("Zerg Broodling", UnitType.ZERG_BROODLING);
		allUnitTypes.add(UnitType.ZERG_BROODLING);
		unitTypesById[40] = UnitType.ZERG_BROODLING;
		unitTypesByName.put("Zerg Drone", UnitType.ZERG_DRONE);
		allUnitTypes.add(UnitType.ZERG_DRONE);
		unitTypesById[41] = UnitType.ZERG_DRONE;
		unitTypesByName.put("Zerg Overlord", UnitType.ZERG_OVERLORD);
		allUnitTypes.add(UnitType.ZERG_OVERLORD);
		unitTypesById[42] = UnitType.ZERG_OVERLORD;
		unitTypesByName.put("Zerg Mutalisk", UnitType.ZERG_MUTALISK);
		allUnitTypes.add(UnitType.ZERG_MUTALISK);
		unitTypesById[43] = UnitType.ZERG_MUTALISK;
		unitTypesByName.put("Zerg Guardian", UnitType.ZERG_GUARDIAN);
		allUnitTypes.add(UnitType.ZERG_GUARDIAN);
		unitTypesById[44] = UnitType.ZERG_GUARDIAN;
		unitTypesByName.put("Zerg Queen", UnitType.ZERG_QUEEN);
		allUnitTypes.add(UnitType.ZERG_QUEEN);
		unitTypesById[45] = UnitType.ZERG_QUEEN;
		unitTypesByName.put("Zerg Defiler", UnitType.ZERG_DEFILER);
		allUnitTypes.add(UnitType.ZERG_DEFILER);
		unitTypesById[46] = UnitType.ZERG_DEFILER;
		unitTypesByName.put("Zerg Scourge", UnitType.ZERG_SCOURGE);
		allUnitTypes.add(UnitType.ZERG_SCOURGE);
		unitTypesById[47] = UnitType.ZERG_SCOURGE;
		unitTypesByName.put("Zerg Infested Terran", UnitType.ZERG_INFESTED_TERRAN);
		allUnitTypes.add(UnitType.ZERG_INFESTED_TERRAN);
		unitTypesById[50] = UnitType.ZERG_INFESTED_TERRAN;
		unitTypesByName.put("Terran Valkyrie", UnitType.TERRAN_VALKYRIE);
		allUnitTypes.add(UnitType.TERRAN_VALKYRIE);
		unitTypesById[58] = UnitType.TERRAN_VALKYRIE;
		unitTypesByName.put("Zerg Cocoon", UnitType.ZERG_COCOON);
		allUnitTypes.add(UnitType.ZERG_COCOON);
		unitTypesById[59] = UnitType.ZERG_COCOON;
		unitTypesByName.put("Protoss Corsair", UnitType.PROTOSS_CORSAIR);
		allUnitTypes.add(UnitType.PROTOSS_CORSAIR);
		unitTypesById[60] = UnitType.PROTOSS_CORSAIR;
		unitTypesByName.put("Protoss Dark Templar", UnitType.PROTOSS_DARK_TEMPLAR);
		allUnitTypes.add(UnitType.PROTOSS_DARK_TEMPLAR);
		unitTypesById[61] = UnitType.PROTOSS_DARK_TEMPLAR;
		unitTypesByName.put("Zerg Devourer", UnitType.ZERG_DEVOURER);
		allUnitTypes.add(UnitType.ZERG_DEVOURER);
		unitTypesById[62] = UnitType.ZERG_DEVOURER;
		unitTypesByName.put("Protoss Dark Archon", UnitType.PROTOSS_DARK_ARCHON);
		allUnitTypes.add(UnitType.PROTOSS_DARK_ARCHON);
		unitTypesById[63] = UnitType.PROTOSS_DARK_ARCHON;
		unitTypesByName.put("Protoss Probe", UnitType.PROTOSS_PROBE);
		allUnitTypes.add(UnitType.PROTOSS_PROBE);
		unitTypesById[64] = UnitType.PROTOSS_PROBE;
		unitTypesByName.put("Protoss Zealot", UnitType.PROTOSS_ZEALOT);
		allUnitTypes.add(UnitType.PROTOSS_ZEALOT);
		unitTypesById[65] = UnitType.PROTOSS_ZEALOT;
		unitTypesByName.put("Protoss Dragoon", UnitType.PROTOSS_DRAGOON);
		allUnitTypes.add(UnitType.PROTOSS_DRAGOON);
		unitTypesById[66] = UnitType.PROTOSS_DRAGOON;
		unitTypesByName.put("Protoss High Templar", UnitType.PROTOSS_HIGH_TEMPLAR);
		allUnitTypes.add(UnitType.PROTOSS_HIGH_TEMPLAR);
		unitTypesById[67] = UnitType.PROTOSS_HIGH_TEMPLAR;
		unitTypesByName.put("Protoss Archon", UnitType.PROTOSS_ARCHON);
		allUnitTypes.add(UnitType.PROTOSS_ARCHON);
		unitTypesById[68] = UnitType.PROTOSS_ARCHON;
		unitTypesByName.put("Protoss Shuttle", UnitType.PROTOSS_SHUTTLE);
		allUnitTypes.add(UnitType.PROTOSS_SHUTTLE);
		unitTypesById[69] = UnitType.PROTOSS_SHUTTLE;
		unitTypesByName.put("Protoss Scout", UnitType.PROTOSS_SCOUT);
		allUnitTypes.add(UnitType.PROTOSS_SCOUT);
		unitTypesById[70] = UnitType.PROTOSS_SCOUT;
		unitTypesByName.put("Protoss Arbiter", UnitType.PROTOSS_ARBITER);
		allUnitTypes.add(UnitType.PROTOSS_ARBITER);
		unitTypesById[71] = UnitType.PROTOSS_ARBITER;
		unitTypesByName.put("Protoss Carrier", UnitType.PROTOSS_CARRIER);
		allUnitTypes.add(UnitType.PROTOSS_CARRIER);
		unitTypesById[72] = UnitType.PROTOSS_CARRIER;
		unitTypesByName.put("Protoss Interceptor", UnitType.PROTOSS_INTERCEPTOR);
		allUnitTypes.add(UnitType.PROTOSS_INTERCEPTOR);
		unitTypesById[73] = UnitType.PROTOSS_INTERCEPTOR;
		unitTypesByName.put("Protoss Reaver", UnitType.PROTOSS_REAVER);
		allUnitTypes.add(UnitType.PROTOSS_REAVER);
		unitTypesById[83] = UnitType.PROTOSS_REAVER;
		unitTypesByName.put("Protoss Observer", UnitType.PROTOSS_OBSERVER);
		allUnitTypes.add(UnitType.PROTOSS_OBSERVER);
		unitTypesById[84] = UnitType.PROTOSS_OBSERVER;
		unitTypesByName.put("Protoss Scarab", UnitType.PROTOSS_SCARAB);
		allUnitTypes.add(UnitType.PROTOSS_SCARAB);
		unitTypesById[85] = UnitType.PROTOSS_SCARAB;
		unitTypesByName.put("Critter Rhynadon", UnitType.CRITTER_RHYNADON);
		allUnitTypes.add(UnitType.CRITTER_RHYNADON);
		unitTypesById[89] = UnitType.CRITTER_RHYNADON;
		unitTypesByName.put("Critter Bengalaas", UnitType.CRITTER_BENGALAAS);
		allUnitTypes.add(UnitType.CRITTER_BENGALAAS);
		unitTypesById[90] = UnitType.CRITTER_BENGALAAS;
		unitTypesByName.put("Critter Scantid", UnitType.CRITTER_SCANTID);
		allUnitTypes.add(UnitType.CRITTER_SCANTID);
		unitTypesById[93] = UnitType.CRITTER_SCANTID;
		unitTypesByName.put("Critter Kakaru", UnitType.CRITTER_KAKARU);
		allUnitTypes.add(UnitType.CRITTER_KAKARU);
		unitTypesById[94] = UnitType.CRITTER_KAKARU;
		unitTypesByName.put("Critter Ragnasaur", UnitType.CRITTER_RAGNASAUR);
		allUnitTypes.add(UnitType.CRITTER_RAGNASAUR);
		unitTypesById[95] = UnitType.CRITTER_RAGNASAUR;
		unitTypesByName.put("Critter Ursadon", UnitType.CRITTER_URSADON);
		allUnitTypes.add(UnitType.CRITTER_URSADON);
		unitTypesById[96] = UnitType.CRITTER_URSADON;
		unitTypesByName.put("Zerg Lurker Egg", UnitType.ZERG_LURKER_EGG);
		allUnitTypes.add(UnitType.ZERG_LURKER_EGG);
		unitTypesById[97] = UnitType.ZERG_LURKER_EGG;
		unitTypesByName.put("Zerg Lurker", UnitType.ZERG_LURKER);
		allUnitTypes.add(UnitType.ZERG_LURKER);
		unitTypesById[103] = UnitType.ZERG_LURKER;
		unitTypesByName.put("Spell Disruption Web", UnitType.SPELL_DISRUPTION_WEB);
		allUnitTypes.add(UnitType.SPELL_DISRUPTION_WEB);
		unitTypesById[105] = UnitType.SPELL_DISRUPTION_WEB;
		unitTypesByName.put("Terran Command Center", UnitType.TERRAN_COMMAND_CENTER);
		allUnitTypes.add(UnitType.TERRAN_COMMAND_CENTER);
		unitTypesById[106] = UnitType.TERRAN_COMMAND_CENTER;
		unitTypesByName.put("Terran Comsat Station", UnitType.TERRAN_COMSAT_STATION);
		allUnitTypes.add(UnitType.TERRAN_COMSAT_STATION);
		unitTypesById[107] = UnitType.TERRAN_COMSAT_STATION;
		unitTypesByName.put("Terran Nuclear Silo", UnitType.TERRAN_NUCLEAR_SILO);
		allUnitTypes.add(UnitType.TERRAN_NUCLEAR_SILO);
		unitTypesById[108] = UnitType.TERRAN_NUCLEAR_SILO;
		unitTypesByName.put("Terran Supply Depot", UnitType.TERRAN_SUPPLY_DEPOT);
		allUnitTypes.add(UnitType.TERRAN_SUPPLY_DEPOT);
		unitTypesById[109] = UnitType.TERRAN_SUPPLY_DEPOT;
		unitTypesByName.put("Terran Refinery", UnitType.TERRAN_REFINERY);
		allUnitTypes.add(UnitType.TERRAN_REFINERY);
		unitTypesById[110] = UnitType.TERRAN_REFINERY;
		unitTypesByName.put("Terran Barracks", UnitType.TERRAN_BARRACKS);
		allUnitTypes.add(UnitType.TERRAN_BARRACKS);
		unitTypesById[111] = UnitType.TERRAN_BARRACKS;
		unitTypesByName.put("Terran Academy", UnitType.TERRAN_ACADEMY);
		allUnitTypes.add(UnitType.TERRAN_ACADEMY);
		unitTypesById[112] = UnitType.TERRAN_ACADEMY;
		unitTypesByName.put("Terran Factory", UnitType.TERRAN_FACTORY);
		allUnitTypes.add(UnitType.TERRAN_FACTORY);
		unitTypesById[113] = UnitType.TERRAN_FACTORY;
		unitTypesByName.put("Terran Starport", UnitType.TERRAN_STARPORT);
		allUnitTypes.add(UnitType.TERRAN_STARPORT);
		unitTypesById[114] = UnitType.TERRAN_STARPORT;
		unitTypesByName.put("Terran Control Tower", UnitType.TERRAN_CONTROL_TOWER);
		allUnitTypes.add(UnitType.TERRAN_CONTROL_TOWER);
		unitTypesById[115] = UnitType.TERRAN_CONTROL_TOWER;
		unitTypesByName.put("Terran Science Facility", UnitType.TERRAN_SCIENCE_FACILITY);
		allUnitTypes.add(UnitType.TERRAN_SCIENCE_FACILITY);
		unitTypesById[116] = UnitType.TERRAN_SCIENCE_FACILITY;
		unitTypesByName.put("Terran Covert Ops", UnitType.TERRAN_COVERT_OPS);
		allUnitTypes.add(UnitType.TERRAN_COVERT_OPS);
		unitTypesById[117] = UnitType.TERRAN_COVERT_OPS;
		unitTypesByName.put("Terran Physics Lab", UnitType.TERRAN_PHYSICS_LAB);
		allUnitTypes.add(UnitType.TERRAN_PHYSICS_LAB);
		unitTypesById[118] = UnitType.TERRAN_PHYSICS_LAB;
		unitTypesByName.put("Terran Machine Shop", UnitType.TERRAN_MACHINE_SHOP);
		allUnitTypes.add(UnitType.TERRAN_MACHINE_SHOP);
		unitTypesById[120] = UnitType.TERRAN_MACHINE_SHOP;
		unitTypesByName.put("Terran Engineering Bay", UnitType.TERRAN_ENGINEERING_BAY);
		allUnitTypes.add(UnitType.TERRAN_ENGINEERING_BAY);
		unitTypesById[122] = UnitType.TERRAN_ENGINEERING_BAY;
		unitTypesByName.put("Terran Armory", UnitType.TERRAN_ARMORY);
		allUnitTypes.add(UnitType.TERRAN_ARMORY);
		unitTypesById[123] = UnitType.TERRAN_ARMORY;
		unitTypesByName.put("Terran Missile Turret", UnitType.TERRAN_MISSILE_TURRET);
		allUnitTypes.add(UnitType.TERRAN_MISSILE_TURRET);
		unitTypesById[124] = UnitType.TERRAN_MISSILE_TURRET;
		unitTypesByName.put("Terran Bunker", UnitType.TERRAN_BUNKER);
		allUnitTypes.add(UnitType.TERRAN_BUNKER);
		unitTypesById[125] = UnitType.TERRAN_BUNKER;
		unitTypesByName.put("Special Crashed Norad II", UnitType.SPECIAL_CRASHED_NORAD_II);
		allUnitTypes.add(UnitType.SPECIAL_CRASHED_NORAD_II);
		unitTypesById[126] = UnitType.SPECIAL_CRASHED_NORAD_II;
		unitTypesByName.put("Special Ion Cannon", UnitType.SPECIAL_ION_CANNON);
		allUnitTypes.add(UnitType.SPECIAL_ION_CANNON);
		unitTypesById[127] = UnitType.SPECIAL_ION_CANNON;
		unitTypesByName.put("Zerg Infested Command Center", UnitType.ZERG_INFESTED_COMMAND_CENTER);
		allUnitTypes.add(UnitType.ZERG_INFESTED_COMMAND_CENTER);
		unitTypesById[130] = UnitType.ZERG_INFESTED_COMMAND_CENTER;
		unitTypesByName.put("Zerg Hatchery", UnitType.ZERG_HATCHERY);
		allUnitTypes.add(UnitType.ZERG_HATCHERY);
		unitTypesById[131] = UnitType.ZERG_HATCHERY;
		unitTypesByName.put("Zerg Lair", UnitType.ZERG_LAIR);
		allUnitTypes.add(UnitType.ZERG_LAIR);
		unitTypesById[132] = UnitType.ZERG_LAIR;
		unitTypesByName.put("Zerg Hive", UnitType.ZERG_HIVE);
		allUnitTypes.add(UnitType.ZERG_HIVE);
		unitTypesById[133] = UnitType.ZERG_HIVE;
		unitTypesByName.put("Zerg Nydus Canal", UnitType.ZERG_NYDUS_CANAL);
		allUnitTypes.add(UnitType.ZERG_NYDUS_CANAL);
		unitTypesById[134] = UnitType.ZERG_NYDUS_CANAL;
		unitTypesByName.put("Zerg Hydralisk Den", UnitType.ZERG_HYDRALISK_DEN);
		allUnitTypes.add(UnitType.ZERG_HYDRALISK_DEN);
		unitTypesById[135] = UnitType.ZERG_HYDRALISK_DEN;
		unitTypesByName.put("Zerg Defiler Mound", UnitType.ZERG_DEFILER_MOUND);
		allUnitTypes.add(UnitType.ZERG_DEFILER_MOUND);
		unitTypesById[136] = UnitType.ZERG_DEFILER_MOUND;
		unitTypesByName.put("Zerg Greater Spire", UnitType.ZERG_GREATER_SPIRE);
		allUnitTypes.add(UnitType.ZERG_GREATER_SPIRE);
		unitTypesById[137] = UnitType.ZERG_GREATER_SPIRE;
		unitTypesByName.put("Zerg Queens Nest", UnitType.ZERG_QUEENS_NEST);
		allUnitTypes.add(UnitType.ZERG_QUEENS_NEST);
		unitTypesById[138] = UnitType.ZERG_QUEENS_NEST;
		unitTypesByName.put("Zerg Evolution Chamber", UnitType.ZERG_EVOLUTION_CHAMBER);
		allUnitTypes.add(UnitType.ZERG_EVOLUTION_CHAMBER);
		unitTypesById[139] = UnitType.ZERG_EVOLUTION_CHAMBER;
		unitTypesByName.put("Zerg Ultralisk Cavern", UnitType.ZERG_ULTRALISK_CAVERN);
		allUnitTypes.add(UnitType.ZERG_ULTRALISK_CAVERN);
		unitTypesById[140] = UnitType.ZERG_ULTRALISK_CAVERN;
		unitTypesByName.put("Zerg Spire", UnitType.ZERG_SPIRE);
		allUnitTypes.add(UnitType.ZERG_SPIRE);
		unitTypesById[141] = UnitType.ZERG_SPIRE;
		unitTypesByName.put("Zerg Spawning Pool", UnitType.ZERG_SPAWNING_POOL);
		allUnitTypes.add(UnitType.ZERG_SPAWNING_POOL);
		unitTypesById[142] = UnitType.ZERG_SPAWNING_POOL;
		unitTypesByName.put("Zerg Creep Colony", UnitType.ZERG_CREEP_COLONY);
		allUnitTypes.add(UnitType.ZERG_CREEP_COLONY);
		unitTypesById[143] = UnitType.ZERG_CREEP_COLONY;
		unitTypesByName.put("Zerg Spore Colony", UnitType.ZERG_SPORE_COLONY);
		allUnitTypes.add(UnitType.ZERG_SPORE_COLONY);
		unitTypesById[144] = UnitType.ZERG_SPORE_COLONY;
		unitTypesByName.put("Zerg Sunken Colony", UnitType.ZERG_SUNKEN_COLONY);
		allUnitTypes.add(UnitType.ZERG_SUNKEN_COLONY);
		unitTypesById[146] = UnitType.ZERG_SUNKEN_COLONY;
		unitTypesByName.put("Special Overmind With Shell", UnitType.SPECIAL_OVERMIND_WITH_SHELL);
		allUnitTypes.add(UnitType.SPECIAL_OVERMIND_WITH_SHELL);
		unitTypesById[147] = UnitType.SPECIAL_OVERMIND_WITH_SHELL;
		unitTypesByName.put("Special Overmind", UnitType.SPECIAL_OVERMIND);
		allUnitTypes.add(UnitType.SPECIAL_OVERMIND);
		unitTypesById[148] = UnitType.SPECIAL_OVERMIND;
		unitTypesByName.put("Zerg Extractor", UnitType.ZERG_EXTRACTOR);
		allUnitTypes.add(UnitType.ZERG_EXTRACTOR);
		unitTypesById[149] = UnitType.ZERG_EXTRACTOR;
		unitTypesByName.put("Special Mature Chrysalis", UnitType.SPECIAL_MATURE_CHRYSALIS);
		allUnitTypes.add(UnitType.SPECIAL_MATURE_CHRYSALIS);
		unitTypesById[150] = UnitType.SPECIAL_MATURE_CHRYSALIS;
		unitTypesByName.put("Special Cerebrate", UnitType.SPECIAL_CEREBRATE);
		allUnitTypes.add(UnitType.SPECIAL_CEREBRATE);
		unitTypesById[151] = UnitType.SPECIAL_CEREBRATE;
		unitTypesByName.put("Special Cerebrate Daggoth", UnitType.SPECIAL_CEREBRATE_DAGGOTH);
		allUnitTypes.add(UnitType.SPECIAL_CEREBRATE_DAGGOTH);
		unitTypesById[152] = UnitType.SPECIAL_CEREBRATE_DAGGOTH;
		unitTypesByName.put("Protoss Nexus", UnitType.PROTOSS_NEXUS);
		allUnitTypes.add(UnitType.PROTOSS_NEXUS);
		unitTypesById[154] = UnitType.PROTOSS_NEXUS;
		unitTypesByName.put("Protoss Robotics Facility", UnitType.PROTOSS_ROBOTICS_FACILITY);
		allUnitTypes.add(UnitType.PROTOSS_ROBOTICS_FACILITY);
		unitTypesById[155] = UnitType.PROTOSS_ROBOTICS_FACILITY;
		unitTypesByName.put("Protoss Pylon", UnitType.PROTOSS_PYLON);
		allUnitTypes.add(UnitType.PROTOSS_PYLON);
		unitTypesById[156] = UnitType.PROTOSS_PYLON;
		unitTypesByName.put("Protoss Assimilator", UnitType.PROTOSS_ASSIMILATOR);
		allUnitTypes.add(UnitType.PROTOSS_ASSIMILATOR);
		unitTypesById[157] = UnitType.PROTOSS_ASSIMILATOR;
		unitTypesByName.put("Protoss Observatory", UnitType.PROTOSS_OBSERVATORY);
		allUnitTypes.add(UnitType.PROTOSS_OBSERVATORY);
		unitTypesById[159] = UnitType.PROTOSS_OBSERVATORY;
		unitTypesByName.put("Protoss Gateway", UnitType.PROTOSS_GATEWAY);
		allUnitTypes.add(UnitType.PROTOSS_GATEWAY);
		unitTypesById[160] = UnitType.PROTOSS_GATEWAY;
		unitTypesByName.put("Protoss Photon Cannon", UnitType.PROTOSS_PHOTON_CANNON);
		allUnitTypes.add(UnitType.PROTOSS_PHOTON_CANNON);
		unitTypesById[162] = UnitType.PROTOSS_PHOTON_CANNON;
		unitTypesByName.put("Protoss Citadel of Adun", UnitType.PROTOSS_CITADEL_OF_ADUN);
		allUnitTypes.add(UnitType.PROTOSS_CITADEL_OF_ADUN);
		unitTypesById[163] = UnitType.PROTOSS_CITADEL_OF_ADUN;
		unitTypesByName.put("Protoss Cybernetics Core", UnitType.PROTOSS_CYBERNETICS_CORE);
		allUnitTypes.add(UnitType.PROTOSS_CYBERNETICS_CORE);
		unitTypesById[164] = UnitType.PROTOSS_CYBERNETICS_CORE;
		unitTypesByName.put("Protoss Templar Archives", UnitType.PROTOSS_TEMPLAR_ARCHIVES);
		allUnitTypes.add(UnitType.PROTOSS_TEMPLAR_ARCHIVES);
		unitTypesById[165] = UnitType.PROTOSS_TEMPLAR_ARCHIVES;
		unitTypesByName.put("Protoss Forge", UnitType.PROTOSS_FORGE);
		allUnitTypes.add(UnitType.PROTOSS_FORGE);
		unitTypesById[166] = UnitType.PROTOSS_FORGE;
		unitTypesByName.put("Protoss Stargate", UnitType.PROTOSS_STARGATE);
		allUnitTypes.add(UnitType.PROTOSS_STARGATE);
		unitTypesById[167] = UnitType.PROTOSS_STARGATE;
		unitTypesByName.put("Special Stasis Cell Prison", UnitType.SPECIAL_STASIS_CELL_PRISON);
		allUnitTypes.add(UnitType.SPECIAL_STASIS_CELL_PRISON);
		unitTypesById[168] = UnitType.SPECIAL_STASIS_CELL_PRISON;
		unitTypesByName.put("Protoss Fleet Beacon", UnitType.PROTOSS_FLEET_BEACON);
		allUnitTypes.add(UnitType.PROTOSS_FLEET_BEACON);
		unitTypesById[169] = UnitType.PROTOSS_FLEET_BEACON;
		unitTypesByName.put("Protoss Arbiter Tribunal", UnitType.PROTOSS_ARBITER_TRIBUNAL);
		allUnitTypes.add(UnitType.PROTOSS_ARBITER_TRIBUNAL);
		unitTypesById[170] = UnitType.PROTOSS_ARBITER_TRIBUNAL;
		unitTypesByName.put("Protoss Robotics Support Bay", UnitType.PROTOSS_ROBOTICS_SUPPORT_BAY);
		allUnitTypes.add(UnitType.PROTOSS_ROBOTICS_SUPPORT_BAY);
		unitTypesById[171] = UnitType.PROTOSS_ROBOTICS_SUPPORT_BAY;
		unitTypesByName.put("Protoss Shield Battery", UnitType.PROTOSS_SHIELD_BATTERY);
		allUnitTypes.add(UnitType.PROTOSS_SHIELD_BATTERY);
		unitTypesById[172] = UnitType.PROTOSS_SHIELD_BATTERY;
		unitTypesByName.put("Special Khaydarin Crystal Form", UnitType.SPECIAL_KHAYDARIN_CRYSTAL_FORM);
		allUnitTypes.add(UnitType.SPECIAL_KHAYDARIN_CRYSTAL_FORM);
		unitTypesById[173] = UnitType.SPECIAL_KHAYDARIN_CRYSTAL_FORM;
		unitTypesByName.put("Special Protoss Temple", UnitType.SPECIAL_PROTOSS_TEMPLE);
		allUnitTypes.add(UnitType.SPECIAL_PROTOSS_TEMPLE);
		unitTypesById[174] = UnitType.SPECIAL_PROTOSS_TEMPLE;
		unitTypesByName.put("Special XelNaga Temple", UnitType.SPECIAL_XEL_NAGA_TEMPLE);
		allUnitTypes.add(UnitType.SPECIAL_XEL_NAGA_TEMPLE);
		unitTypesById[175] = UnitType.SPECIAL_XEL_NAGA_TEMPLE;
		unitTypesByName.put("Resource Mineral Field", UnitType.RESOURCE_MINERAL_FIELD);
		allUnitTypes.add(UnitType.RESOURCE_MINERAL_FIELD);
		unitTypesById[176] = UnitType.RESOURCE_MINERAL_FIELD;
		unitTypesByName.put("Resource Vespene Geyser", UnitType.RESOURCE_VESPENE_GEYSER);
		allUnitTypes.add(UnitType.RESOURCE_VESPENE_GEYSER);
		unitTypesById[188] = UnitType.RESOURCE_VESPENE_GEYSER;
		unitTypesByName.put("Special Warp Gate", UnitType.SPECIAL_WARP_GATE);
		allUnitTypes.add(UnitType.SPECIAL_WARP_GATE);
		unitTypesById[189] = UnitType.SPECIAL_WARP_GATE;
		unitTypesByName.put("Special Psi Disrupter", UnitType.SPECIAL_PSI_DISRUPTER);
		allUnitTypes.add(UnitType.SPECIAL_PSI_DISRUPTER);
		unitTypesById[190] = UnitType.SPECIAL_PSI_DISRUPTER;
		unitTypesByName.put("Special Power Generator", UnitType.SPECIAL_POWER_GENERATOR);
		allUnitTypes.add(UnitType.SPECIAL_POWER_GENERATOR);
		unitTypesById[200] = UnitType.SPECIAL_POWER_GENERATOR;
		unitTypesByName.put("Special Overmind Cocoon", UnitType.SPECIAL_OVERMIND_COCOON);
		allUnitTypes.add(UnitType.SPECIAL_OVERMIND_COCOON);
		unitTypesById[201] = UnitType.SPECIAL_OVERMIND_COCOON;
		unitTypesByName.put("Spell Dark Swarm", UnitType.SPELL_DARK_SWARM);
		allUnitTypes.add(UnitType.SPELL_DARK_SWARM);
		unitTypesById[202] = UnitType.SPELL_DARK_SWARM;
		unitTypesByName.put("None", UnitType.NONE);
		allUnitTypes.add(UnitType.NONE);
		unitTypesById[228] = UnitType.NONE;
		unitTypesByName.put("Unknown", UnitType.UNKNOWN);
		allUnitTypes.add(UnitType.UNKNOWN);
		unitTypesById[233] = UnitType.UNKNOWN;
		gAllUnitTypes = Collections.unmodifiableSet(allUnitTypes);

	}

	public static final UnitType getUnitType(String name) {
		return unitTypesByName.get(name);
	}

	public static final Set<UnitType> allUnitTypes() {
		return gAllUnitTypes;
	}

	static final UnitType getUnitTypeFromId(int id) {
		return unitTypesById[id];
	}

	static final int getMaxIdPlusOne() {
		return unitTypesById.length;
	}

	@Override
  public final boolean equals(Object object) {
		if (this == object) {
			return true;
		} else if (this instanceof UnitType) {
			final UnitType other = (UnitType) object;
			return this.id == other.id;
		} else {
			return false;
		}
	}

	@Override
  public final int hashCode() {
		return this.id;
	}

	GameMessages.UnitType getTypeMessage() {
		return GameMessages.UnitType.newBuilder().setId(this.id).build();
	}
	
	public boolean isProducedFromMorphOrder() {
		// TODO: Is this really correct?
		// Most Zerg unit types are produced from a morph order.
		return this.getRace().getID() == Race.ZERG.getID()
			&& (!this.isBuilding() || equals(UnitType.ZERG_GREATER_SPIRE) 
					|| equals(UnitType.ZERG_LAIR) || equals(UnitType.ZERG_HIVE))
			&& getID() != UnitType.ZERG_LARVA.getID()
			&& getID() != UnitType.ZERG_EGG.getID()
			&& getID() != UnitType.ZERG_LURKER_EGG.getID()
			&& getID() != UnitType.ZERG_COCOON.getID()
			&& getID() != UnitType.ZERG_EXTRACTOR.getID()
			&& getID() != UnitType.ZERG_INFESTED_COMMAND_CENTER.getID()
			&& getID() != UnitType.ZERG_INFESTED_TERRAN.getID()
			&& getID() != UnitType.ZERG_BROODLING.getID();
	}

	public boolean canHaveAddon() {
		return this.getID() == UnitType.TERRAN_COMMAND_CENTER.getID()
				|| this.getID() == UnitType.TERRAN_FACTORY.getID()
				|| this.getID() == UnitType.TERRAN_STARPORT.getID()
				|| this.getID() == UnitType.TERRAN_SCIENCE_FACILITY.getID();
	}
	
}
