package org.bwapi.proxy.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

//Auto-generated code
public enum UnitSizeType {
    INDEPENDENT (0, "Independent"),
    SMALL (1, "Small"),
    MEDIUM (2, "Medium"),
    LARGE (3, "Large"),
    NONE (4, "None"),
   UNKNOWN (5, "Unknown");


	private int id;
    private String name;

	private UnitSizeType(int id, String name) {
		this.id = id;
		this.name = name;
	}

	public final int getID() {
		return id;
	}
	public String getName() { return name; }

;

	protected static final Map<String, UnitSizeType> gNamesToUnitSizeTypes = new HashMap<String, UnitSizeType>();
	protected static final Set<UnitSizeType> gAllUnitSizeTypes;
	protected static final UnitSizeType[] gIdsToUnitSizeTypes;

	static {
		Set<UnitSizeType> allUnitSizeTypes = new HashSet<UnitSizeType>();
		gIdsToUnitSizeTypes = new UnitSizeType[6];
		gNamesToUnitSizeTypes.put("Independent", UnitSizeType.INDEPENDENT);
		allUnitSizeTypes.add(UnitSizeType.INDEPENDENT);
		gIdsToUnitSizeTypes[0] = UnitSizeType.INDEPENDENT;
		gNamesToUnitSizeTypes.put("Small", UnitSizeType.SMALL);
		allUnitSizeTypes.add(UnitSizeType.SMALL);
		gIdsToUnitSizeTypes[1] = UnitSizeType.SMALL;
		gNamesToUnitSizeTypes.put("Medium", UnitSizeType.MEDIUM);
		allUnitSizeTypes.add(UnitSizeType.MEDIUM);
		gIdsToUnitSizeTypes[2] = UnitSizeType.MEDIUM;
		gNamesToUnitSizeTypes.put("Large", UnitSizeType.LARGE);
		allUnitSizeTypes.add(UnitSizeType.LARGE);
		gIdsToUnitSizeTypes[3] = UnitSizeType.LARGE;
		gNamesToUnitSizeTypes.put("None", UnitSizeType.NONE);
		allUnitSizeTypes.add(UnitSizeType.NONE);
		gIdsToUnitSizeTypes[4] = UnitSizeType.NONE;
		gNamesToUnitSizeTypes.put("Unknown", UnitSizeType.UNKNOWN);
		allUnitSizeTypes.add(UnitSizeType.UNKNOWN);
		gIdsToUnitSizeTypes[5] = UnitSizeType.UNKNOWN;
		gAllUnitSizeTypes = Collections.unmodifiableSet(allUnitSizeTypes);
	}

	public static final UnitSizeType getUnitSizeType(String name) {
		return gNamesToUnitSizeTypes.get(name);
	}

	public static final Set<UnitSizeType> allUnitSizeTypes() {
		return gAllUnitSizeTypes;
	}

	static final UnitSizeType getUnitSizeTypeFromId(int id) {
		return gIdsToUnitSizeTypes[id];
	}

	static final int getMaxIdPlusOne() {
		return gIdsToUnitSizeTypes.length;
	}

}
