package org.bwapi.proxy.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.messages.GameMessages;

class UnitManager {
	private Map<Integer, GameMessages.Unit> unitMessages = new HashMap<Integer, GameMessages.Unit>();
	private Map<Integer, GameMessages.Unit> initialUnitMessages = new HashMap<Integer, GameMessages.Unit>();
	private Map<Integer, GameMessages.Unit> previousUnitMessages = new HashMap<Integer, GameMessages.Unit>();
	private Set<Unit> allUnits = new HashSet<Unit>();
	
	protected void setUnitMessage(int id, GameMessages.Unit message) {
		if (!initialUnitMessages.containsKey(id)) {
			initialUnitMessages.put(id, message);
		}
		if (unitMessages.containsKey(id)) {
			previousUnitMessages.put(id, unitMessages.get(id));
		}
		unitMessages.put(id, message);
	}
	
	protected void clearUnits() {
		allUnits.clear();
	}
	
	protected void addUnit(Unit u) {
		allUnits.add(u);
	}
	
	public GameMessages.Unit getMessage(int id) {
		return unitMessages.get(id);
	}

	public GameMessages.Unit getInitialMessage(int id) {
		return initialUnitMessages.get(id);
	}
	
	public GameMessages.Unit getPreviousMessage(int id) {
		return previousUnitMessages.get(id);
	}

	public Set<? extends ROUnit> getAllUnits() {
		return new HashSet<Unit>(allUnits);
	}

}
