package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.messages.GameMessages.TechTypeData;

public class TechType {
	protected int id;

	protected TechType(int id) {
		this.id = id;
	}
	
	protected TechType(GameMessages.TechType type) {
	    this(type.getId());
	}

	public final int getID() {
		return id;
	}
	
    private TechTypeData getData() {
        return data.get(id);
    }
	
	public String getName() {
	    return getData().getName();
	}
	public Race getRace() {
	    return Race.getRaceFromId(getData().getRace().getNumber());
	}
	
	public int mineralPrice() {
	    return getData().getMineralPrice();
	}
	public int gasPrice() {
	    return getData().getGasPrice();
	}
	public int energyUsed() {
	    return getData().getEnergyUsed();
	}
	public UnitType whatResearches() {
	    return UnitType.getUnitTypeFromId(getData().getWhatResearches().getId());
	}
	public WeaponType getWeapon() {
	    return WeaponType.getWeaponTypeFromId(getData().getWeapon().getId());
	}
	public Set<UnitType> whatUses() {
	    Set<UnitType> r = new HashSet<UnitType>();
	    for(GameMessages.UnitType u: getData().getWhatUsesList()) {
	        r.add(UnitType.getUnitTypeFromId(u.getId()));
	    }
	    return r;
	}


	protected static final Map<String, TechType> gNamesToTechTypes = new HashMap<String, TechType>();
	protected static final Set<TechType> gAllTechTypes;
	protected static final TechType[] gIdsToTechTypes;
	
	protected static List<GameMessages.TechTypeData> data;
    static void setTechTypes(List<GameMessages.TechTypeData> _data) {
        data = new ArrayList<GameMessages.TechTypeData>(_data);
    }
    
    public static final TechType STIM_PACKS = new TechType(0);
    public static final TechType LOCKDOWN = new TechType(1);
    public static final TechType EMP_SHOCKWAVE = new TechType(2);
    public static final TechType SPIDER_MINES = new TechType(3);
    public static final TechType SCANNER_SWEEP = new TechType(4);
    public static final TechType TANK_SIEGE_MODE = new TechType(5);
    public static final TechType DEFENSIVE_MATRIX = new TechType(6);
    public static final TechType IRRADIATE = new TechType(7);
    public static final TechType YAMATO_GUN = new TechType(8);
    public static final TechType CLOAKING_FIELD = new TechType(9);
    public static final TechType PERSONNEL_CLOAKING = new TechType(10);
    public static final TechType BURROWING = new TechType(11);
    public static final TechType INFESTATION = new TechType(12);
    public static final TechType SPAWN_BROODLINGS = new TechType(13);
    public static final TechType DARK_SWARM = new TechType(14);
    public static final TechType PLAGUE = new TechType(15);
    public static final TechType CONSUME = new TechType(16);
    public static final TechType ENSNARE = new TechType(17);
    public static final TechType PARASITE = new TechType(18);
    public static final TechType PSIONIC_STORM = new TechType(19);
    public static final TechType HALLUCINATION = new TechType(20);
    public static final TechType RECALL = new TechType(21);
    public static final TechType STASIS_FIELD = new TechType(22);
    public static final TechType ARCHON_WARP = new TechType(23);
    public static final TechType RESTORATION = new TechType(24);
    public static final TechType DISRUPTION_WEB = new TechType(25);
    public static final TechType MIND_CONTROL = new TechType(27);
    public static final TechType DARK_ARCHON_MELD = new TechType(28);
    public static final TechType FEEDBACK = new TechType(29);
    public static final TechType OPTICAL_FLARE = new TechType(30);
    public static final TechType MAELSTROM = new TechType(31);
    public static final TechType LURKER_ASPECT = new TechType(32);
    public static final TechType HEALING = new TechType(34);
    public static final TechType NONE = new TechType(44);
    public static final TechType UNKNOWN = new TechType(45);
    public static final TechType NUCLEAR_STRIKE = new TechType(46);



	static {
		Set<TechType> allTechTypes = new HashSet<TechType>();
		gIdsToTechTypes = new TechType[47];
		gNamesToTechTypes.put("Stim Packs", TechType.STIM_PACKS);
		allTechTypes.add(TechType.STIM_PACKS);
		gIdsToTechTypes[0] = TechType.STIM_PACKS;
		gNamesToTechTypes.put("Lockdown", TechType.LOCKDOWN);
		allTechTypes.add(TechType.LOCKDOWN);
		gIdsToTechTypes[1] = TechType.LOCKDOWN;
		gNamesToTechTypes.put("EMP Shockwave", TechType.EMP_SHOCKWAVE);
		allTechTypes.add(TechType.EMP_SHOCKWAVE);
		gIdsToTechTypes[2] = TechType.EMP_SHOCKWAVE;
		gNamesToTechTypes.put("Spider Mines", TechType.SPIDER_MINES);
		allTechTypes.add(TechType.SPIDER_MINES);
		gIdsToTechTypes[3] = TechType.SPIDER_MINES;
		gNamesToTechTypes.put("Scanner Sweep", TechType.SCANNER_SWEEP);
		allTechTypes.add(TechType.SCANNER_SWEEP);
		gIdsToTechTypes[4] = TechType.SCANNER_SWEEP;
		gNamesToTechTypes.put("Tank Siege Mode", TechType.TANK_SIEGE_MODE);
		allTechTypes.add(TechType.TANK_SIEGE_MODE);
		gIdsToTechTypes[5] = TechType.TANK_SIEGE_MODE;
		gNamesToTechTypes.put("Defensive Matrix", TechType.DEFENSIVE_MATRIX);
		allTechTypes.add(TechType.DEFENSIVE_MATRIX);
		gIdsToTechTypes[6] = TechType.DEFENSIVE_MATRIX;
		gNamesToTechTypes.put("Irradiate", TechType.IRRADIATE);
		allTechTypes.add(TechType.IRRADIATE);
		gIdsToTechTypes[7] = TechType.IRRADIATE;
		gNamesToTechTypes.put("Yamato Gun", TechType.YAMATO_GUN);
		allTechTypes.add(TechType.YAMATO_GUN);
		gIdsToTechTypes[8] = TechType.YAMATO_GUN;
		gNamesToTechTypes.put("Cloaking Field", TechType.CLOAKING_FIELD);
		allTechTypes.add(TechType.CLOAKING_FIELD);
		gIdsToTechTypes[9] = TechType.CLOAKING_FIELD;
		gNamesToTechTypes.put("Personnel Cloaking", TechType.PERSONNEL_CLOAKING);
		allTechTypes.add(TechType.PERSONNEL_CLOAKING);
		gIdsToTechTypes[10] = TechType.PERSONNEL_CLOAKING;
		gNamesToTechTypes.put("Burrowing", TechType.BURROWING);
		allTechTypes.add(TechType.BURROWING);
		gIdsToTechTypes[11] = TechType.BURROWING;
		gNamesToTechTypes.put("Infestation", TechType.INFESTATION);
		allTechTypes.add(TechType.INFESTATION);
		gIdsToTechTypes[12] = TechType.INFESTATION;
		gNamesToTechTypes.put("Spawn Broodlings", TechType.SPAWN_BROODLINGS);
		allTechTypes.add(TechType.SPAWN_BROODLINGS);
		gIdsToTechTypes[13] = TechType.SPAWN_BROODLINGS;
		gNamesToTechTypes.put("Dark Swarm", TechType.DARK_SWARM);
		allTechTypes.add(TechType.DARK_SWARM);
		gIdsToTechTypes[14] = TechType.DARK_SWARM;
		gNamesToTechTypes.put("Plague", TechType.PLAGUE);
		allTechTypes.add(TechType.PLAGUE);
		gIdsToTechTypes[15] = TechType.PLAGUE;
		gNamesToTechTypes.put("Consume", TechType.CONSUME);
		allTechTypes.add(TechType.CONSUME);
		gIdsToTechTypes[16] = TechType.CONSUME;
		gNamesToTechTypes.put("Ensnare", TechType.ENSNARE);
		allTechTypes.add(TechType.ENSNARE);
		gIdsToTechTypes[17] = TechType.ENSNARE;
		gNamesToTechTypes.put("Parasite", TechType.PARASITE);
		allTechTypes.add(TechType.PARASITE);
		gIdsToTechTypes[18] = TechType.PARASITE;
		gNamesToTechTypes.put("Psionic Storm", TechType.PSIONIC_STORM);
		allTechTypes.add(TechType.PSIONIC_STORM);
		gIdsToTechTypes[19] = TechType.PSIONIC_STORM;
		gNamesToTechTypes.put("Hallucination", TechType.HALLUCINATION);
		allTechTypes.add(TechType.HALLUCINATION);
		gIdsToTechTypes[20] = TechType.HALLUCINATION;
		gNamesToTechTypes.put("Recall", TechType.RECALL);
		allTechTypes.add(TechType.RECALL);
		gIdsToTechTypes[21] = TechType.RECALL;
		gNamesToTechTypes.put("Stasis Field", TechType.STASIS_FIELD);
		allTechTypes.add(TechType.STASIS_FIELD);
		gIdsToTechTypes[22] = TechType.STASIS_FIELD;
		gNamesToTechTypes.put("Archon Warp", TechType.ARCHON_WARP);
		allTechTypes.add(TechType.ARCHON_WARP);
		gIdsToTechTypes[23] = TechType.ARCHON_WARP;
		gNamesToTechTypes.put("Restoration", TechType.RESTORATION);
		allTechTypes.add(TechType.RESTORATION);
		gIdsToTechTypes[24] = TechType.RESTORATION;
		gNamesToTechTypes.put("Disruption Web", TechType.DISRUPTION_WEB);
		allTechTypes.add(TechType.DISRUPTION_WEB);
		gIdsToTechTypes[25] = TechType.DISRUPTION_WEB;
		gNamesToTechTypes.put("Mind Control", TechType.MIND_CONTROL);
		allTechTypes.add(TechType.MIND_CONTROL);
		gIdsToTechTypes[27] = TechType.MIND_CONTROL;
		gNamesToTechTypes.put("Dark Archon Meld", TechType.DARK_ARCHON_MELD);
		allTechTypes.add(TechType.DARK_ARCHON_MELD);
		gIdsToTechTypes[28] = TechType.DARK_ARCHON_MELD;
		gNamesToTechTypes.put("Feedback", TechType.FEEDBACK);
		allTechTypes.add(TechType.FEEDBACK);
		gIdsToTechTypes[29] = TechType.FEEDBACK;
		gNamesToTechTypes.put("Optical Flare", TechType.OPTICAL_FLARE);
		allTechTypes.add(TechType.OPTICAL_FLARE);
		gIdsToTechTypes[30] = TechType.OPTICAL_FLARE;
		gNamesToTechTypes.put("Maelstrom", TechType.MAELSTROM);
		allTechTypes.add(TechType.MAELSTROM);
		gIdsToTechTypes[31] = TechType.MAELSTROM;
		gNamesToTechTypes.put("Lurker Aspect", TechType.LURKER_ASPECT);
		allTechTypes.add(TechType.LURKER_ASPECT);
		gIdsToTechTypes[32] = TechType.LURKER_ASPECT;
		gNamesToTechTypes.put("Healing", TechType.HEALING);
		allTechTypes.add(TechType.HEALING);
		gIdsToTechTypes[34] = TechType.HEALING;
		gNamesToTechTypes.put("None", TechType.NONE);
		allTechTypes.add(TechType.NONE);
		gIdsToTechTypes[44] = TechType.NONE;
		gNamesToTechTypes.put("Unknown", TechType.UNKNOWN);
		allTechTypes.add(TechType.UNKNOWN);
		gIdsToTechTypes[45] = TechType.UNKNOWN;
		gNamesToTechTypes.put("Nuclear Strike", TechType.NUCLEAR_STRIKE);
		allTechTypes.add(TechType.NUCLEAR_STRIKE);
		gIdsToTechTypes[46] = TechType.NUCLEAR_STRIKE;
		gAllTechTypes = Collections.unmodifiableSet(allTechTypes);
	}

	public static final TechType getTechType(String name) {
		return gNamesToTechTypes.get(name);
	}

	public static final Set<TechType> allTechTypes() {
		return gAllTechTypes;
	}

	static final TechType getTechTypeFromId(int id) {
		return gIdsToTechTypes[id];
	}

	static final int getMaxIdPlusOne() {
		return gIdsToTechTypes.length;
	}

	public final boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		else if (this instanceof TechType) {
			final TechType other = (TechType) object;
			return this.id == other.id;
		}
		else {
			return false;
		}
	}

	public final int hashCode() {
		return this.id;
	}

    GameMessages.TechType getTypeMessage() {
        return GameMessages.TechType.newBuilder().setId(id).build();
    }
}
