package org.bwapi.proxy.model;

import java.util.Set;

import org.bwapi.proxy.messages.TerrainMessages;

public class Region {
	final int id;
	private final Polygon polygon;
	private Bwta bwta;
	private TerrainMessages.Region region;
	
	Region(TerrainMessages.Region region, Bwta bwta) {
	  id = region.getId();
	  polygon = new Polygon(region.getPolygon());
	  this.bwta = bwta;
	  this.region = region;
  }

	public Polygon getPolygon() {
	  return polygon;
  }
	
	public Position getCenter() {
	  return polygon.getCenter();
  }
	
	
	public Set<Chokepoint> getChokepoints() {
	  return Bwta.wrap(bwta.chokepointsList,region.getChokepointsList());
  }
	
	public Set<BaseLocation> getBaseLocations() {
	  return Bwta.wrap(bwta.baselocationsList,region.getBaseLocationsList());
  }
	

	@Override
  public int hashCode() {
	  final int prime = 31;
	  int result = 1;
	  result = prime * result + id;
	  return result;
  }

	@Override
  public boolean equals(Object obj) {
	  if (this == obj)
		  return true;
	  if (obj == null)
		  return false;
	  if (getClass() != obj.getClass())
		  return false;
	  Region other = (Region) obj;
	  if (id != other.id)
		  return false;
	  return true;
  }

	public boolean contains(TilePosition tp) {
		return getPolygon().isInside(new Position(tp));
  }
	
	public boolean contains(Position tp) {
		return getPolygon().isInside(tp);
  }


}
