package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.messages.GameMessages.RaceData;

//Auto-generated code
public class Race {
    private GameMessages.Race id;

	protected Race(GameMessages.Race id) {
	  this.id = id;
	}

	public final int getID() {
		return id.getNumber();
	}
	
	public String getName() {
	    return getData().getName();
	}
	public UnitType getWorker() {
	    return UnitType.getUnitTypeFromId(getData().getWorker().getId());
	}

    private RaceData getData() {
        return data.get(id.getNumber());
    }
    public UnitType getCenter() {
        return UnitType.getUnitTypeFromId(getData().getCenter().getId());
    }
	public UnitType getRefinery() {
	    return UnitType.getUnitTypeFromId(getData().getRefinery().getId());
	}
	public UnitType getTransport() {
	    return UnitType.getUnitTypeFromId(getData().getTransport().getId());
	}
	public UnitType getSupplyProvider() {
	    return UnitType.getUnitTypeFromId(getData().getSupplyProvider().getId());
	}

	public static final Race ZERG = new Race(GameMessages.Race.Zerg);
	public static final Race TERRAN = new Race(GameMessages.Race.Terran);
	public static final Race PROTOSS = new Race(GameMessages.Race.Protoss);
	public static final Race OTHER = new Race(GameMessages.Race.Other);
	public static final Race NONE = new Race(GameMessages.Race.None);
	public static final Race UNKNOWN = new Race(GameMessages.Race.Unknown);

	protected static final Map<String, Race> gNamesToRaces = new HashMap<String, Race>();
	protected static final Set<Race> gAllRaces;
	protected static final Race[] gIdsToRaces;
	
	protected static List<GameMessages.RaceData> data;
	static void setRaces(List<GameMessages.RaceData> _data) {
	    data = new ArrayList<GameMessages.RaceData>(_data);
	}

	static {
		Set<Race> allRaces = new HashSet<Race>();
		gIdsToRaces = new Race[7];
		gNamesToRaces.put("Zerg", Race.ZERG);
		allRaces.add(Race.ZERG);
		gIdsToRaces[0] = Race.ZERG;
		
		gNamesToRaces.put("Terran", Race.TERRAN);
		allRaces.add(Race.TERRAN);
		gIdsToRaces[1] = Race.TERRAN;
		gNamesToRaces.put("Protoss", Race.PROTOSS);
		allRaces.add(Race.PROTOSS);
		gIdsToRaces[2] = Race.PROTOSS;
		gNamesToRaces.put("Other", Race.OTHER);
		allRaces.add(Race.OTHER);
		gIdsToRaces[4] = Race.OTHER;
		gNamesToRaces.put("None", Race.NONE);
		allRaces.add(Race.NONE);
		gIdsToRaces[5] = Race.NONE;
		gNamesToRaces.put("Unknown", Race.UNKNOWN);
		allRaces.add(Race.UNKNOWN);
		gIdsToRaces[6] = Race.UNKNOWN;
		gAllRaces = Collections.unmodifiableSet(allRaces);
	}

	public static final Race getRace(String name) {
		return gNamesToRaces.get(name);
	}

	public static final Set<Race> allRaces() {
		return gAllRaces;
	}

	static final Race getRaceFromId(int id) {
		return gIdsToRaces[id];
	}

	static final int getMaxIdPlusOne() {
		return gIdsToRaces.length;
	}

	public final boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		else if (this instanceof Race) {
			final Race other = (Race) object;
			return this.id == other.id;
		}
		else {
			return false;
		}
	}

	public final int hashCode() {
		return this.id.getNumber();
	}
}
