package org.bwapi.proxy.model;

import java.util.List;
import java.util.Set;

import org.bwapi.proxy.messages.GameMessages.UnitId;

public interface ROUnit {
	public int getID();
	
	public boolean exists();
    public ROUnit getAddon();
    public int getAirWeaponCooldown();
    public int getArmor();
    public double getAngle();
    public ROUnit getBuildUnit();
    public ROUnit getCarrier();
    public int getDefenseMatrixPoints();
    public int getDefenseMatrixTimer();
    public double getDistance(Position target);
    public double getCenterDistance(ROUnit target);
    public int getDistance(ROUnit target);
    public int getEnergy();
    public int getEnsnareTimer();
    public int getGroundWeaponCooldown();
    public int getHitPoints();
    public int getInitialHitPoints();
    public Position getInitialPosition();
    public int getInitialResources();
    public TilePosition getInitialTilePosition();
    public UnitType getInitialType();
    public int getInterceptorCount();
    public Set<? extends ROUnit> getInterceptors();
    public int getIrradiateTimer();
    public int getKillCount();
    public Set<? extends ROUnit> getLoadedUnits();
    public int getLockdownTimer();
    public int getMaelstromTimer();
    public ROUnit getNydusExit();
    public Order getOrder();
    public ROUnit getOrderTarget();
    public int getOrderTimer();
    public int getPlagueTimer();
    public Player getPlayer();
    public Position getPosition();
    public Position getRallyPosition();
    public ROUnit getRallyUnit();
    public int getRemainingBuildTime();
    public int getRemainingResearchTime();
    public int getRemainingTrainTime();
    public int getRemainingUpgradeTime();
    public int getRemoveTimer();
    public int getResources();
    public int getScarabCount();
    public Order getSecondaryOrder();
    public int getShields();
    public int getSpellCooldown();
    public int getSpiderMineCount();
    public int getStasisTimer();
    public int getStimTimer();
    public ROUnit getTarget();
    public Position getTargetPosition();
    public TechType getTech();
    public TilePosition getTilePosition();
    public List<UnitType> getTrainingQueue();
    public ROUnit getTransport();
    public UnitType getType();
    public UpgradeType getUpgrade();
    public int getUpgradeLevel(UpgradeType upgrade);
    public double getVelocityX();
    public double getVelocityY();
    public boolean isAccelerating();
    public boolean isAttacking();
    public boolean isBeingConstructed();
    public boolean isBeingGathered();
    public boolean isBeingHealed();
    public boolean isBlind();
    public boolean isBraking();
    public boolean isBurrowed();
    public boolean isCarryingGas();
    public boolean isCarryingMinerals();
    public boolean isCloaked();
    public boolean isCompleted();
    public boolean isConstructing();
    public boolean isDetected();
    public boolean isDefenseMatrixed();
    public boolean isEnsnared();
    public boolean isFollowing();
    public boolean isGatheringGas();
    public boolean isGatheringMinerals();
    public boolean isHallucination();
    public boolean isIdle();
    public boolean isIrradiated();
    public boolean isLifted();
    public boolean isLoaded();
    public boolean isLockedDown();
    public boolean isMaelstrommed();
    public boolean isMorphing();
    public boolean isMoving();
    public boolean isParasited();
    public boolean isPatrolling();
    public boolean isPlagued();
    public boolean isRepairing();
    public boolean isResearching();
    public boolean isSelected();
    public boolean isSieged();
    public boolean isStartingAttack();
    public boolean isStasised();
    public boolean isStimmed();
    public boolean isStuck();
    public boolean isTraining();
    public boolean isUnderStorm();
    public boolean isUnpowered();
    public boolean isUpgrading();
    public boolean isVisible();
    
	public ROUnit getPreviousUnitData();
    
	// determine if the target can ever be attacked (does not check range or cloaking)
	public boolean canAttack(ROUnit target);
	// does the target have the ability to cloak?
	public boolean canCloak();
	public int getAirRange();
	public int getAirWeaponDamage();
	public int getAttackRange(ROUnit target);
	public double getDamagePerShot(ROUnit target);
	public double getDamagePerShot(boolean vsAir);
	//DPS = damage per second.  Calculations are not necessarily exact.
	public double getDps(ROUnit target);
	public double getDps(boolean vsAir);
	public int getGroundRange();
	public int getGroundWeaponDamage();
	public int getLastKnownHitPoints();
	public Position getLastKnownPosition();
	public int getLastKnownResources();
	public int getLastKnownShields();
	public TilePosition getLastKnownTilePosition();
	public int getShieldUpgradeLevel();
	public boolean isFlying();
	public boolean isInRange(ROUnit target);
	public boolean isStopped();
	public boolean isTargetable();
	public boolean wasCompleted();
	
  public boolean isUnderDarkSwarm();
  public boolean isUnderAttack();
	
	public UnitId toMessage();
	
	/**
	 * Returns the set of build tile positions this unit touches
	 * @return
	 */
	public Set<TilePosition> getBuildTilePositions();

	public TilePosition getAddonTilePosition();
}
