package org.bwapi.proxy.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Order {
	@Override
  public String toString() {
	  return "Order ["+ id + " " + name + "]";
  }

	private final int id;
    private final String name;

	protected Order(int id, String name) {
		this.id = id;
		this.name = name;
	}

	public final int getID() {
		return id;
	}
	public String getName() {
	    return name;
	}

	public static final Order DIE = new Order(0, "Die");
	public static final Order STOP = new Order(1, "Stop");
	public static final Order GUARD = new Order(2, "Guard");
	public static final Order PLAYER_GUARD = new Order(3, "PlayerGuard");
	public static final Order TURRET_GUARD = new Order(4, "TurretGuard");
	public static final Order BUNKER_GUARD = new Order(5, "BunkerGuard");
	public static final Order MOVE = new Order(6, "Move");
	public static final Order REAVER_STOP = new Order(7, "ReaverStop");
	public static final Order ATTACK_1 = new Order(8, "Attack1");
	public static final Order ATTACK_2 = new Order(9, "Attack2");
	public static final Order ATTACK_UNIT = new Order(10, "AttackUnit");
	public static final Order ATTACK_FIXED_RANGE = new Order(11, "AttackFixedRange");
	public static final Order ATTACK_TILE = new Order(12, "AttackTile");
	public static final Order HOVER = new Order(13, "Hover");
	public static final Order ATTACK_MOVE = new Order(14, "AttackMove");
	public static final Order INFEST_MINE_1 = new Order(15, "InfestMine1");
	public static final Order UNUSED_NOTHING = new Order(16, "UnusedNothing");
	public static final Order UNUSED_POWERUP = new Order(17, "UnusedPowerup");
	public static final Order TOWER_GUARD = new Order(18, "TowerGuard");
	public static final Order TOWER_ATTACK = new Order(19, "TowerAttack");
	public static final Order VULTURE_MINE = new Order(20, "VultureMine");
	public static final Order STAYIN_RANGE = new Order(21, "StayinRange");
	public static final Order TURRET_ATTACK = new Order(22, "TurretAttack");
	public static final Order NOTHING = new Order(23, "Nothing");
	public static final Order NOTHING_3 = new Order(24, "Nothing3");
	public static final Order DRONE_START_BUILD = new Order(25, "DroneStartBuild");
	public static final Order DRONE_BUILD = new Order(26, "DroneBuild");
	public static final Order INFEST_MINE_2 = new Order(27, "InfestMine2");
	public static final Order INFEST_MINE_3 = new Order(28, "InfestMine3");
	public static final Order INFEST_MINE_4 = new Order(29, "InfestMine4");
	public static final Order BUILD_TERRAN = new Order(30, "BuildTerran");
	public static final Order BUILD_PROTOSS_1 = new Order(31, "BuildProtoss1");
	public static final Order BUILD_PROTOSS_2 = new Order(32, "BuildProtoss2");
	public static final Order CONSTRUCTING_BUILDING = new Order(33, "ConstructingBuilding");
	public static final Order REPAIR_1 = new Order(34, "Repair1");
	public static final Order REPAIR_2 = new Order(35, "Repair2");
	public static final Order PLACE_ADDON = new Order(36, "PlaceAddon");
	public static final Order BUILD_ADDON = new Order(37, "BuildAddon");
	public static final Order TRAIN = new Order(38, "Train");
	public static final Order RALLY_POINT_UNIT = new Order(39, "RallyPointUnit");
	public static final Order RALLY_POINT_TILE = new Order(40, "RallyPointTile");
	public static final Order ZERG_BIRTH = new Order(41, "ZergBirth");
	public static final Order ZERG_UNIT_MORPH = new Order(42, "ZergUnitMorph");
	public static final Order ZERG_BUILDING_MORPH = new Order(43, "ZergBuildingMorph");
	public static final Order TERRAN_BUILD_SELF = new Order(44, "TerranBuildSelf");
	public static final Order ZERG_BUILD_SELF = new Order(45, "ZergBuildSelf");
	public static final Order BUILD_NYDUS_EXIT = new Order(46, "BuildNydusExit");
	public static final Order ENTER_NYDUS_CANAL = new Order(47, "EnterNydusCanal");
	public static final Order PROTOSS_BUILD_SELF = new Order(48, "ProtossBuildSelf");
	public static final Order FOLLOW = new Order(49, "Follow");
	public static final Order CARRIER = new Order(50, "Carrier");
	public static final Order REAVER_CARRIER_MOVE = new Order(51, "ReaverCarrierMove");
	public static final Order CARRIER_STOP = new Order(52, "CarrierStop");
	public static final Order CARRIER_ATTACK_1 = new Order(53, "CarrierAttack1");
	public static final Order CARRIER_ATTACK_2 = new Order(54, "CarrierAttack2");
	public static final Order CARRIER_IGNORE_2 = new Order(55, "CarrierIgnore2");
	public static final Order CARRIER_FIGHT = new Order(56, "CarrierFight");
	public static final Order CARRIER_HOLD_POSITION = new Order(57, "CarrierHoldPosition");
	public static final Order REAVER = new Order(58, "Reaver");
	public static final Order REAVER_ATTACK_1 = new Order(59, "ReaverAttack1");
	public static final Order REAVER_ATTACK_2 = new Order(60, "ReaverAttack2");
	public static final Order REAVER_FIGHT = new Order(61, "ReaverFight");
	public static final Order REAVER_HOLD_POSITION = new Order(62, "ReaverHoldPosition");
	public static final Order TRAIN_FIGHTER = new Order(63, "TrainFighter");
	public static final Order STRAFE_UNIT_1 = new Order(64, "StrafeUnit1");
	public static final Order STRAFE_UNIT_2 = new Order(65, "StrafeUnit2");
	public static final Order RECHARGE_SHIELDS_UNIT = new Order(66, "RechargeShieldsUnit");
	public static final Order RECHARGE_SHIELDS_BATTERY = new Order(67, "RechargeShieldsBattery");
	public static final Order SHIELD_BATTERY = new Order(68, "ShieldBattery");
	public static final Order RETURN = new Order(69, "Return");
	public static final Order DRONE_LAND = new Order(70, "DroneLand");
	public static final Order BUILDING_LAND = new Order(71, "BuildingLand");
	public static final Order BUILDING_LIFT_OFF = new Order(72, "BuildingLiftOff");
	public static final Order DRONE_LIFT_OFF = new Order(73, "DroneLiftOff");
	public static final Order LIFTING_OFF = new Order(74, "LiftingOff");
	public static final Order RESEARCH_TECH = new Order(75, "ResearchTech");
	public static final Order UPGRADE = new Order(76, "Upgrade");
	public static final Order LARVA = new Order(77, "Larva");
	public static final Order SPAWNING_LARVA = new Order(78, "SpawningLarva");
	public static final Order HARVEST_1 = new Order(79, "Harvest1");
	public static final Order HARVEST_2 = new Order(80, "Harvest2");
	public static final Order MOVE_TO_GAS = new Order(81, "MoveToGas");
	public static final Order WAIT_FOR_GAS = new Order(82, "WaitForGas");
	public static final Order HARVEST_GAS = new Order(83, "HarvestGas");
	public static final Order RETURN_GAS = new Order(84, "ReturnGas");
	public static final Order MOVE_TO_MINERALS = new Order(85, "MoveToMinerals");
	public static final Order WAIT_FOR_MINERALS = new Order(86, "WaitForMinerals");
	public static final Order MINING_MINERALS = new Order(87, "MiningMinerals");
	public static final Order HARVEST_3 = new Order(88, "Harvest3");
	public static final Order HARVEST_4 = new Order(89, "Harvest4");
	public static final Order RETURN_MINERALS = new Order(90, "ReturnMinerals");
	public static final Order INTERRUPTED = new Order(91, "Interrupted");
	public static final Order ENTER_TRANSPORT = new Order(92, "EnterTransport");
	public static final Order PICKUP_IDLE = new Order(93, "PickupIdle");
	public static final Order PICKUP_TRANSPORT = new Order(94, "PickupTransport");
	public static final Order PICKUP_BUNKER = new Order(95, "PickupBunker");
	public static final Order PICKUP_4 = new Order(96, "Pickup4");
	public static final Order POWERUP_IDLE = new Order(97, "PowerupIdle");
	public static final Order SIEGE_MODE = new Order(98, "SiegeMode");
	public static final Order TANK_MODE = new Order(99, "TankMode");
	public static final Order WATCH_TARGET = new Order(100, "WatchTarget");
	public static final Order INIT_CREEP_GROWTH = new Order(101, "InitCreepGrowth");
	public static final Order SPREAD_CREEP = new Order(102, "SpreadCreep");
	public static final Order STOPPING_CREEP_GROWTH = new Order(103, "StoppingCreepGrowth");
	public static final Order GUARDIAN_ASPECT = new Order(104, "GuardianAspect");
	public static final Order WARPING_ARCHON = new Order(105, "WarpingArchon");
	public static final Order COMPLETING_ARCHONSUMMON = new Order(106, "CompletingArchonsummon");
	public static final Order HOLD_POSITION = new Order(107, "HoldPosition");
	public static final Order QUEEN_HOLD_POSITION = new Order(108, "QueenHoldPosition");
	public static final Order CLOAK = new Order(109, "Cloak");
	public static final Order DECLOAK = new Order(110, "Decloak");
	public static final Order UNLOAD = new Order(111, "Unload");
	public static final Order MOVE_UNLOAD = new Order(112, "MoveUnload");
	public static final Order FIRE_YAMATO_GUN_1 = new Order(113, "FireYamatoGun1");
	public static final Order FIRE_YAMATO_GUN_2 = new Order(114, "FireYamatoGun2");
	public static final Order MAGNA_PULSE = new Order(115, "MagnaPulse");
	public static final Order BURROW = new Order(116, "Burrow");
	public static final Order BURROWED = new Order(117, "Burrowed");
	public static final Order UNBURROW = new Order(118, "Unburrow");
	public static final Order DARK_SWARM = new Order(119, "DarkSwarm");
	public static final Order CAST_PARASITE = new Order(120, "CastParasite");
	public static final Order SUMMON_BROODLINGS = new Order(121, "SummonBroodlings");
	public static final Order EMP_SHOCKWAVE = new Order(122, "EmpShockwave");
	public static final Order NUKE_WAIT = new Order(123, "NukeWait");
	public static final Order NUKE_TRAIN = new Order(124, "NukeTrain");
	public static final Order NUKE_LAUNCH = new Order(125, "NukeLaunch");
	public static final Order NUKE_PAINT = new Order(126, "NukePaint");
	public static final Order NUKE_UNIT = new Order(127, "NukeUnit");
	public static final Order NUKE_GROUND = new Order(128, "NukeGround");
	public static final Order NUKE_TRACK = new Order(129, "NukeTrack");
	public static final Order INIT_ARBITER = new Order(130, "InitArbiter");
	public static final Order CLOAK_NEARBY_UNITS = new Order(131, "CloakNearbyUnits");
	public static final Order PLACE_MINE = new Order(132, "PlaceMine");
	public static final Order RIGHTCLICKACTION = new Order(133, "Rightclickaction");
	public static final Order SAP_UNIT = new Order(134, "SapUnit");
	public static final Order SAP_LOCATION = new Order(135, "SapLocation");
	public static final Order SUICIDE_HOLD_POSITION = new Order(136, "SuicideHoldPosition");
	public static final Order TELEPORT = new Order(137, "Teleport");
	public static final Order TELEPORTTO_LOCATION = new Order(138, "TeleporttoLocation");
	public static final Order PLACE_SCANNER = new Order(139, "PlaceScanner");
	public static final Order SCANNER = new Order(140, "Scanner");
	public static final Order DEFENSIVE_MATRIX = new Order(141, "DefensiveMatrix");
	public static final Order PSI_STORM = new Order(142, "PsiStorm");
	public static final Order IRRADIATE = new Order(143, "Irradiate");
	public static final Order PLAGUE = new Order(144, "Plague");
	public static final Order CONSUME = new Order(145, "Consume");
	public static final Order ENSNARE = new Order(146, "Ensnare");
	public static final Order STASIS_FIELD = new Order(147, "StasisField");
	public static final Order HALLUCINATION_1 = new Order(148, "Hallucination1");
	public static final Order HALLUCINATION_2 = new Order(149, "Hallucination2");
	public static final Order RESET_COLLISION_1 = new Order(150, "ResetCollision1");
	public static final Order RESET_COLLISION_2 = new Order(151, "ResetCollision2");
	public static final Order PATROL = new Order(152, "Patrol");
	public static final Order CTFCOPINIT = new Order(153, "CTFCOPInit");
	public static final Order CTFCOP_1 = new Order(154, "CTFCOP1");
	public static final Order CTFCOP_2 = new Order(155, "CTFCOP2");
	public static final Order COMPUTER_AI = new Order(156, "ComputerAI");
	public static final Order ATK_MOVE_EP = new Order(157, "AtkMoveEP");
	public static final Order HARASS_MOVE = new Order(158, "HarassMove");
	public static final Order AIPATROL = new Order(159, "AIPatrol");
	public static final Order GUARD_POST = new Order(160, "GuardPost");
	public static final Order RESCUE_PASSIVE = new Order(161, "RescuePassive");
	public static final Order NEUTRAL = new Order(162, "Neutral");
	public static final Order COMPUTER_RETURN = new Order(163, "ComputerReturn");
	public static final Order INIT_PSI_PROVIDER = new Order(164, "InitPsiProvider");
	public static final Order SELF_DESTRUCING = new Order(165, "SelfDestrucing");
	public static final Order CRITTER = new Order(166, "Critter");
	public static final Order HIDDEN_GUN = new Order(167, "HiddenGun");
	public static final Order OPEN_DOOR = new Order(168, "OpenDoor");
	public static final Order CLOSE_DOOR = new Order(169, "CloseDoor");
	public static final Order HIDE_TRAP = new Order(170, "HideTrap");
	public static final Order REVEAL_TRAP = new Order(171, "RevealTrap");
	public static final Order ENABLEDOODAD = new Order(172, "Enabledoodad");
	public static final Order DISABLEDOODAD = new Order(173, "Disabledoodad");
	public static final Order WARPIN = new Order(174, "Warpin");
	public static final Order MEDIC = new Order(175, "Medic");
	public static final Order MEDIC_HEAL_1 = new Order(176, "MedicHeal1");
	public static final Order HEAL_MOVE = new Order(177, "HealMove");
	public static final Order MEDIC_HOLD_POSITION = new Order(178, "MedicHoldPosition");
	public static final Order MEDIC_HEAL_2 = new Order(179, "MedicHeal2");
	public static final Order RESTORATION = new Order(180, "Restoration");
	public static final Order CAST_DISRUPTION_WEB = new Order(181, "CastDisruptionWeb");
	public static final Order CAST_MIND_CONTROL = new Order(182, "CastMindControl");
	public static final Order WARPING_DARK_ARCHON = new Order(183, "WarpingDarkArchon");
	public static final Order CAST_FEEDBACK = new Order(184, "CastFeedback");
	public static final Order CAST_OPTICAL_FLARE = new Order(185, "CastOpticalFlare");
	public static final Order CAST_MAELSTROM = new Order(186, "CastMaelstrom");
	public static final Order JUNK_YARD_DOG = new Order(187, "JunkYardDog");
	public static final Order FATAL = new Order(188, "Fatal");
	public static final Order NONE = new Order(189, "None");
	public static final Order UNKNOWN = new Order(190, "Unknown");

	protected static final Map<String, Order> gNamesToOrders = new HashMap<String, Order>();
	protected static final Set<Order> gAllOrders;
	protected static final Order[] gIdsToOrders;

	static {
		Set<Order> allOrders = new HashSet<Order>();
		gIdsToOrders = new Order[191];
		gNamesToOrders.put("Die", Order.DIE);
		allOrders.add(Order.DIE);
		gIdsToOrders[0] = Order.DIE;
		gNamesToOrders.put("Stop", Order.STOP);
		allOrders.add(Order.STOP);
		gIdsToOrders[1] = Order.STOP;
		gNamesToOrders.put("Guard", Order.GUARD);
		allOrders.add(Order.GUARD);
		gIdsToOrders[2] = Order.GUARD;
		gNamesToOrders.put("PlayerGuard", Order.PLAYER_GUARD);
		allOrders.add(Order.PLAYER_GUARD);
		gIdsToOrders[3] = Order.PLAYER_GUARD;
		gNamesToOrders.put("TurretGuard", Order.TURRET_GUARD);
		allOrders.add(Order.TURRET_GUARD);
		gIdsToOrders[4] = Order.TURRET_GUARD;
		gNamesToOrders.put("BunkerGuard", Order.BUNKER_GUARD);
		allOrders.add(Order.BUNKER_GUARD);
		gIdsToOrders[5] = Order.BUNKER_GUARD;
		gNamesToOrders.put("Move", Order.MOVE);
		allOrders.add(Order.MOVE);
		gIdsToOrders[6] = Order.MOVE;
		gNamesToOrders.put("ReaverStop", Order.REAVER_STOP);
		allOrders.add(Order.REAVER_STOP);
		gIdsToOrders[7] = Order.REAVER_STOP;
		gNamesToOrders.put("Attack1", Order.ATTACK_1);
		allOrders.add(Order.ATTACK_1);
		gIdsToOrders[8] = Order.ATTACK_1;
		gNamesToOrders.put("Attack2", Order.ATTACK_2);
		allOrders.add(Order.ATTACK_2);
		gIdsToOrders[9] = Order.ATTACK_2;
		gNamesToOrders.put("AttackUnit", Order.ATTACK_UNIT);
		allOrders.add(Order.ATTACK_UNIT);
		gIdsToOrders[10] = Order.ATTACK_UNIT;
		gNamesToOrders.put("AttackFixedRange", Order.ATTACK_FIXED_RANGE);
		allOrders.add(Order.ATTACK_FIXED_RANGE);
		gIdsToOrders[11] = Order.ATTACK_FIXED_RANGE;
		gNamesToOrders.put("AttackTile", Order.ATTACK_TILE);
		allOrders.add(Order.ATTACK_TILE);
		gIdsToOrders[12] = Order.ATTACK_TILE;
		gNamesToOrders.put("Hover", Order.HOVER);
		allOrders.add(Order.HOVER);
		gIdsToOrders[13] = Order.HOVER;
		gNamesToOrders.put("AttackMove", Order.ATTACK_MOVE);
		allOrders.add(Order.ATTACK_MOVE);
		gIdsToOrders[14] = Order.ATTACK_MOVE;
		gNamesToOrders.put("InfestMine1", Order.INFEST_MINE_1);
		allOrders.add(Order.INFEST_MINE_1);
		gIdsToOrders[15] = Order.INFEST_MINE_1;
		gNamesToOrders.put("UnusedNothing", Order.UNUSED_NOTHING);
		allOrders.add(Order.UNUSED_NOTHING);
		gIdsToOrders[16] = Order.UNUSED_NOTHING;
		gNamesToOrders.put("UnusedPowerup", Order.UNUSED_POWERUP);
		allOrders.add(Order.UNUSED_POWERUP);
		gIdsToOrders[17] = Order.UNUSED_POWERUP;
		gNamesToOrders.put("TowerGuard", Order.TOWER_GUARD);
		allOrders.add(Order.TOWER_GUARD);
		gIdsToOrders[18] = Order.TOWER_GUARD;
		gNamesToOrders.put("TowerAttack", Order.TOWER_ATTACK);
		allOrders.add(Order.TOWER_ATTACK);
		gIdsToOrders[19] = Order.TOWER_ATTACK;
		gNamesToOrders.put("VultureMine", Order.VULTURE_MINE);
		allOrders.add(Order.VULTURE_MINE);
		gIdsToOrders[20] = Order.VULTURE_MINE;
		gNamesToOrders.put("StayinRange", Order.STAYIN_RANGE);
		allOrders.add(Order.STAYIN_RANGE);
		gIdsToOrders[21] = Order.STAYIN_RANGE;
		gNamesToOrders.put("TurretAttack", Order.TURRET_ATTACK);
		allOrders.add(Order.TURRET_ATTACK);
		gIdsToOrders[22] = Order.TURRET_ATTACK;
		gNamesToOrders.put("Nothing", Order.NOTHING);
		allOrders.add(Order.NOTHING);
		gIdsToOrders[23] = Order.NOTHING;
		gNamesToOrders.put("Nothing3", Order.NOTHING_3);
		allOrders.add(Order.NOTHING_3);
		gIdsToOrders[24] = Order.NOTHING_3;
		gNamesToOrders.put("DroneStartBuild", Order.DRONE_START_BUILD);
		allOrders.add(Order.DRONE_START_BUILD);
		gIdsToOrders[25] = Order.DRONE_START_BUILD;
		gNamesToOrders.put("DroneBuild", Order.DRONE_BUILD);
		allOrders.add(Order.DRONE_BUILD);
		gIdsToOrders[26] = Order.DRONE_BUILD;
		gNamesToOrders.put("InfestMine2", Order.INFEST_MINE_2);
		allOrders.add(Order.INFEST_MINE_2);
		gIdsToOrders[27] = Order.INFEST_MINE_2;
		gNamesToOrders.put("InfestMine3", Order.INFEST_MINE_3);
		allOrders.add(Order.INFEST_MINE_3);
		gIdsToOrders[28] = Order.INFEST_MINE_3;
		gNamesToOrders.put("InfestMine4", Order.INFEST_MINE_4);
		allOrders.add(Order.INFEST_MINE_4);
		gIdsToOrders[29] = Order.INFEST_MINE_4;
		gNamesToOrders.put("BuildTerran", Order.BUILD_TERRAN);
		allOrders.add(Order.BUILD_TERRAN);
		gIdsToOrders[30] = Order.BUILD_TERRAN;
		gNamesToOrders.put("BuildProtoss1", Order.BUILD_PROTOSS_1);
		allOrders.add(Order.BUILD_PROTOSS_1);
		gIdsToOrders[31] = Order.BUILD_PROTOSS_1;
		gNamesToOrders.put("BuildProtoss2", Order.BUILD_PROTOSS_2);
		allOrders.add(Order.BUILD_PROTOSS_2);
		gIdsToOrders[32] = Order.BUILD_PROTOSS_2;
		gNamesToOrders.put("ConstructingBuilding", Order.CONSTRUCTING_BUILDING);
		allOrders.add(Order.CONSTRUCTING_BUILDING);
		gIdsToOrders[33] = Order.CONSTRUCTING_BUILDING;
		gNamesToOrders.put("Repair1", Order.REPAIR_1);
		allOrders.add(Order.REPAIR_1);
		gIdsToOrders[34] = Order.REPAIR_1;
		gNamesToOrders.put("Repair2", Order.REPAIR_2);
		allOrders.add(Order.REPAIR_2);
		gIdsToOrders[35] = Order.REPAIR_2;
		gNamesToOrders.put("PlaceAddon", Order.PLACE_ADDON);
		allOrders.add(Order.PLACE_ADDON);
		gIdsToOrders[36] = Order.PLACE_ADDON;
		gNamesToOrders.put("BuildAddon", Order.BUILD_ADDON);
		allOrders.add(Order.BUILD_ADDON);
		gIdsToOrders[37] = Order.BUILD_ADDON;
		gNamesToOrders.put("Train", Order.TRAIN);
		allOrders.add(Order.TRAIN);
		gIdsToOrders[38] = Order.TRAIN;
		gNamesToOrders.put("RallyPointUnit", Order.RALLY_POINT_UNIT);
		allOrders.add(Order.RALLY_POINT_UNIT);
		gIdsToOrders[39] = Order.RALLY_POINT_UNIT;
		gNamesToOrders.put("RallyPointTile", Order.RALLY_POINT_TILE);
		allOrders.add(Order.RALLY_POINT_TILE);
		gIdsToOrders[40] = Order.RALLY_POINT_TILE;
		gNamesToOrders.put("ZergBirth", Order.ZERG_BIRTH);
		allOrders.add(Order.ZERG_BIRTH);
		gIdsToOrders[41] = Order.ZERG_BIRTH;
		gNamesToOrders.put("ZergUnitMorph", Order.ZERG_UNIT_MORPH);
		allOrders.add(Order.ZERG_UNIT_MORPH);
		gIdsToOrders[42] = Order.ZERG_UNIT_MORPH;
		gNamesToOrders.put("ZergBuildingMorph", Order.ZERG_BUILDING_MORPH);
		allOrders.add(Order.ZERG_BUILDING_MORPH);
		gIdsToOrders[43] = Order.ZERG_BUILDING_MORPH;
		gNamesToOrders.put("TerranBuildSelf", Order.TERRAN_BUILD_SELF);
		allOrders.add(Order.TERRAN_BUILD_SELF);
		gIdsToOrders[44] = Order.TERRAN_BUILD_SELF;
		gNamesToOrders.put("ZergBuildSelf", Order.ZERG_BUILD_SELF);
		allOrders.add(Order.ZERG_BUILD_SELF);
		gIdsToOrders[45] = Order.ZERG_BUILD_SELF;
		gNamesToOrders.put("BuildNydusExit", Order.BUILD_NYDUS_EXIT);
		allOrders.add(Order.BUILD_NYDUS_EXIT);
		gIdsToOrders[46] = Order.BUILD_NYDUS_EXIT;
		gNamesToOrders.put("EnterNydusCanal", Order.ENTER_NYDUS_CANAL);
		allOrders.add(Order.ENTER_NYDUS_CANAL);
		gIdsToOrders[47] = Order.ENTER_NYDUS_CANAL;
		gNamesToOrders.put("ProtossBuildSelf", Order.PROTOSS_BUILD_SELF);
		allOrders.add(Order.PROTOSS_BUILD_SELF);
		gIdsToOrders[48] = Order.PROTOSS_BUILD_SELF;
		gNamesToOrders.put("Follow", Order.FOLLOW);
		allOrders.add(Order.FOLLOW);
		gIdsToOrders[49] = Order.FOLLOW;
		gNamesToOrders.put("Carrier", Order.CARRIER);
		allOrders.add(Order.CARRIER);
		gIdsToOrders[50] = Order.CARRIER;
		gNamesToOrders.put("ReaverCarrierMove", Order.REAVER_CARRIER_MOVE);
		allOrders.add(Order.REAVER_CARRIER_MOVE);
		gIdsToOrders[51] = Order.REAVER_CARRIER_MOVE;
		gNamesToOrders.put("CarrierStop", Order.CARRIER_STOP);
		allOrders.add(Order.CARRIER_STOP);
		gIdsToOrders[52] = Order.CARRIER_STOP;
		gNamesToOrders.put("CarrierAttack1", Order.CARRIER_ATTACK_1);
		allOrders.add(Order.CARRIER_ATTACK_1);
		gIdsToOrders[53] = Order.CARRIER_ATTACK_1;
		gNamesToOrders.put("CarrierAttack2", Order.CARRIER_ATTACK_2);
		allOrders.add(Order.CARRIER_ATTACK_2);
		gIdsToOrders[54] = Order.CARRIER_ATTACK_2;
		gNamesToOrders.put("CarrierIgnore2", Order.CARRIER_IGNORE_2);
		allOrders.add(Order.CARRIER_IGNORE_2);
		gIdsToOrders[55] = Order.CARRIER_IGNORE_2;
		gNamesToOrders.put("CarrierFight", Order.CARRIER_FIGHT);
		allOrders.add(Order.CARRIER_FIGHT);
		gIdsToOrders[56] = Order.CARRIER_FIGHT;
		gNamesToOrders.put("CarrierHoldPosition", Order.CARRIER_HOLD_POSITION);
		allOrders.add(Order.CARRIER_HOLD_POSITION);
		gIdsToOrders[57] = Order.CARRIER_HOLD_POSITION;
		gNamesToOrders.put("Reaver", Order.REAVER);
		allOrders.add(Order.REAVER);
		gIdsToOrders[58] = Order.REAVER;
		gNamesToOrders.put("ReaverAttack1", Order.REAVER_ATTACK_1);
		allOrders.add(Order.REAVER_ATTACK_1);
		gIdsToOrders[59] = Order.REAVER_ATTACK_1;
		gNamesToOrders.put("ReaverAttack2", Order.REAVER_ATTACK_2);
		allOrders.add(Order.REAVER_ATTACK_2);
		gIdsToOrders[60] = Order.REAVER_ATTACK_2;
		gNamesToOrders.put("ReaverFight", Order.REAVER_FIGHT);
		allOrders.add(Order.REAVER_FIGHT);
		gIdsToOrders[61] = Order.REAVER_FIGHT;
		gNamesToOrders.put("ReaverHoldPosition", Order.REAVER_HOLD_POSITION);
		allOrders.add(Order.REAVER_HOLD_POSITION);
		gIdsToOrders[62] = Order.REAVER_HOLD_POSITION;
		gNamesToOrders.put("TrainFighter", Order.TRAIN_FIGHTER);
		allOrders.add(Order.TRAIN_FIGHTER);
		gIdsToOrders[63] = Order.TRAIN_FIGHTER;
		gNamesToOrders.put("StrafeUnit1", Order.STRAFE_UNIT_1);
		allOrders.add(Order.STRAFE_UNIT_1);
		gIdsToOrders[64] = Order.STRAFE_UNIT_1;
		gNamesToOrders.put("StrafeUnit2", Order.STRAFE_UNIT_2);
		allOrders.add(Order.STRAFE_UNIT_2);
		gIdsToOrders[65] = Order.STRAFE_UNIT_2;
		gNamesToOrders.put("RechargeShieldsUnit", Order.RECHARGE_SHIELDS_UNIT);
		allOrders.add(Order.RECHARGE_SHIELDS_UNIT);
		gIdsToOrders[66] = Order.RECHARGE_SHIELDS_UNIT;
		gNamesToOrders.put("RechargeShieldsBattery", Order.RECHARGE_SHIELDS_BATTERY);
		allOrders.add(Order.RECHARGE_SHIELDS_BATTERY);
		gIdsToOrders[67] = Order.RECHARGE_SHIELDS_BATTERY;
		gNamesToOrders.put("ShieldBattery", Order.SHIELD_BATTERY);
		allOrders.add(Order.SHIELD_BATTERY);
		gIdsToOrders[68] = Order.SHIELD_BATTERY;
		gNamesToOrders.put("Return", Order.RETURN);
		allOrders.add(Order.RETURN);
		gIdsToOrders[69] = Order.RETURN;
		gNamesToOrders.put("DroneLand", Order.DRONE_LAND);
		allOrders.add(Order.DRONE_LAND);
		gIdsToOrders[70] = Order.DRONE_LAND;
		gNamesToOrders.put("BuildingLand", Order.BUILDING_LAND);
		allOrders.add(Order.BUILDING_LAND);
		gIdsToOrders[71] = Order.BUILDING_LAND;
		gNamesToOrders.put("BuildingLiftOff", Order.BUILDING_LIFT_OFF);
		allOrders.add(Order.BUILDING_LIFT_OFF);
		gIdsToOrders[72] = Order.BUILDING_LIFT_OFF;
		gNamesToOrders.put("DroneLiftOff", Order.DRONE_LIFT_OFF);
		allOrders.add(Order.DRONE_LIFT_OFF);
		gIdsToOrders[73] = Order.DRONE_LIFT_OFF;
		gNamesToOrders.put("LiftingOff", Order.LIFTING_OFF);
		allOrders.add(Order.LIFTING_OFF);
		gIdsToOrders[74] = Order.LIFTING_OFF;
		gNamesToOrders.put("ResearchTech", Order.RESEARCH_TECH);
		allOrders.add(Order.RESEARCH_TECH);
		gIdsToOrders[75] = Order.RESEARCH_TECH;
		gNamesToOrders.put("Upgrade", Order.UPGRADE);
		allOrders.add(Order.UPGRADE);
		gIdsToOrders[76] = Order.UPGRADE;
		gNamesToOrders.put("Larva", Order.LARVA);
		allOrders.add(Order.LARVA);
		gIdsToOrders[77] = Order.LARVA;
		gNamesToOrders.put("SpawningLarva", Order.SPAWNING_LARVA);
		allOrders.add(Order.SPAWNING_LARVA);
		gIdsToOrders[78] = Order.SPAWNING_LARVA;
		gNamesToOrders.put("Harvest1", Order.HARVEST_1);
		allOrders.add(Order.HARVEST_1);
		gIdsToOrders[79] = Order.HARVEST_1;
		gNamesToOrders.put("Harvest2", Order.HARVEST_2);
		allOrders.add(Order.HARVEST_2);
		gIdsToOrders[80] = Order.HARVEST_2;
		gNamesToOrders.put("MoveToGas", Order.MOVE_TO_GAS);
		allOrders.add(Order.MOVE_TO_GAS);
		gIdsToOrders[81] = Order.MOVE_TO_GAS;
		gNamesToOrders.put("WaitForGas", Order.WAIT_FOR_GAS);
		allOrders.add(Order.WAIT_FOR_GAS);
		gIdsToOrders[82] = Order.WAIT_FOR_GAS;
		gNamesToOrders.put("HarvestGas", Order.HARVEST_GAS);
		allOrders.add(Order.HARVEST_GAS);
		gIdsToOrders[83] = Order.HARVEST_GAS;
		gNamesToOrders.put("ReturnGas", Order.RETURN_GAS);
		allOrders.add(Order.RETURN_GAS);
		gIdsToOrders[84] = Order.RETURN_GAS;
		gNamesToOrders.put("MoveToMinerals", Order.MOVE_TO_MINERALS);
		allOrders.add(Order.MOVE_TO_MINERALS);
		gIdsToOrders[85] = Order.MOVE_TO_MINERALS;
		gNamesToOrders.put("WaitForMinerals", Order.WAIT_FOR_MINERALS);
		allOrders.add(Order.WAIT_FOR_MINERALS);
		gIdsToOrders[86] = Order.WAIT_FOR_MINERALS;
		gNamesToOrders.put("MiningMinerals", Order.MINING_MINERALS);
		allOrders.add(Order.MINING_MINERALS);
		gIdsToOrders[87] = Order.MINING_MINERALS;
		gNamesToOrders.put("Harvest3", Order.HARVEST_3);
		allOrders.add(Order.HARVEST_3);
		gIdsToOrders[88] = Order.HARVEST_3;
		gNamesToOrders.put("Harvest4", Order.HARVEST_4);
		allOrders.add(Order.HARVEST_4);
		gIdsToOrders[89] = Order.HARVEST_4;
		gNamesToOrders.put("ReturnMinerals", Order.RETURN_MINERALS);
		allOrders.add(Order.RETURN_MINERALS);
		gIdsToOrders[90] = Order.RETURN_MINERALS;
		gNamesToOrders.put("Interrupted", Order.INTERRUPTED);
		allOrders.add(Order.INTERRUPTED);
		gIdsToOrders[91] = Order.INTERRUPTED;
		gNamesToOrders.put("EnterTransport", Order.ENTER_TRANSPORT);
		allOrders.add(Order.ENTER_TRANSPORT);
		gIdsToOrders[92] = Order.ENTER_TRANSPORT;
		gNamesToOrders.put("PickupIdle", Order.PICKUP_IDLE);
		allOrders.add(Order.PICKUP_IDLE);
		gIdsToOrders[93] = Order.PICKUP_IDLE;
		gNamesToOrders.put("PickupTransport", Order.PICKUP_TRANSPORT);
		allOrders.add(Order.PICKUP_TRANSPORT);
		gIdsToOrders[94] = Order.PICKUP_TRANSPORT;
		gNamesToOrders.put("PickupBunker", Order.PICKUP_BUNKER);
		allOrders.add(Order.PICKUP_BUNKER);
		gIdsToOrders[95] = Order.PICKUP_BUNKER;
		gNamesToOrders.put("Pickup4", Order.PICKUP_4);
		allOrders.add(Order.PICKUP_4);
		gIdsToOrders[96] = Order.PICKUP_4;
		gNamesToOrders.put("PowerupIdle", Order.POWERUP_IDLE);
		allOrders.add(Order.POWERUP_IDLE);
		gIdsToOrders[97] = Order.POWERUP_IDLE;
		gNamesToOrders.put("SiegeMode", Order.SIEGE_MODE);
		allOrders.add(Order.SIEGE_MODE);
		gIdsToOrders[98] = Order.SIEGE_MODE;
		gNamesToOrders.put("TankMode", Order.TANK_MODE);
		allOrders.add(Order.TANK_MODE);
		gIdsToOrders[99] = Order.TANK_MODE;
		gNamesToOrders.put("WatchTarget", Order.WATCH_TARGET);
		allOrders.add(Order.WATCH_TARGET);
		gIdsToOrders[100] = Order.WATCH_TARGET;
		gNamesToOrders.put("InitCreepGrowth", Order.INIT_CREEP_GROWTH);
		allOrders.add(Order.INIT_CREEP_GROWTH);
		gIdsToOrders[101] = Order.INIT_CREEP_GROWTH;
		gNamesToOrders.put("SpreadCreep", Order.SPREAD_CREEP);
		allOrders.add(Order.SPREAD_CREEP);
		gIdsToOrders[102] = Order.SPREAD_CREEP;
		gNamesToOrders.put("StoppingCreepGrowth", Order.STOPPING_CREEP_GROWTH);
		allOrders.add(Order.STOPPING_CREEP_GROWTH);
		gIdsToOrders[103] = Order.STOPPING_CREEP_GROWTH;
		gNamesToOrders.put("GuardianAspect", Order.GUARDIAN_ASPECT);
		allOrders.add(Order.GUARDIAN_ASPECT);
		gIdsToOrders[104] = Order.GUARDIAN_ASPECT;
		gNamesToOrders.put("WarpingArchon", Order.WARPING_ARCHON);
		allOrders.add(Order.WARPING_ARCHON);
		gIdsToOrders[105] = Order.WARPING_ARCHON;
		gNamesToOrders.put("CompletingArchonsummon", Order.COMPLETING_ARCHONSUMMON);
		allOrders.add(Order.COMPLETING_ARCHONSUMMON);
		gIdsToOrders[106] = Order.COMPLETING_ARCHONSUMMON;
		gNamesToOrders.put("HoldPosition", Order.HOLD_POSITION);
		allOrders.add(Order.HOLD_POSITION);
		gIdsToOrders[107] = Order.HOLD_POSITION;
		gNamesToOrders.put("QueenHoldPosition", Order.QUEEN_HOLD_POSITION);
		allOrders.add(Order.QUEEN_HOLD_POSITION);
		gIdsToOrders[108] = Order.QUEEN_HOLD_POSITION;
		gNamesToOrders.put("Cloak", Order.CLOAK);
		allOrders.add(Order.CLOAK);
		gIdsToOrders[109] = Order.CLOAK;
		gNamesToOrders.put("Decloak", Order.DECLOAK);
		allOrders.add(Order.DECLOAK);
		gIdsToOrders[110] = Order.DECLOAK;
		gNamesToOrders.put("Unload", Order.UNLOAD);
		allOrders.add(Order.UNLOAD);
		gIdsToOrders[111] = Order.UNLOAD;
		gNamesToOrders.put("MoveUnload", Order.MOVE_UNLOAD);
		allOrders.add(Order.MOVE_UNLOAD);
		gIdsToOrders[112] = Order.MOVE_UNLOAD;
		gNamesToOrders.put("FireYamatoGun1", Order.FIRE_YAMATO_GUN_1);
		allOrders.add(Order.FIRE_YAMATO_GUN_1);
		gIdsToOrders[113] = Order.FIRE_YAMATO_GUN_1;
		gNamesToOrders.put("FireYamatoGun2", Order.FIRE_YAMATO_GUN_2);
		allOrders.add(Order.FIRE_YAMATO_GUN_2);
		gIdsToOrders[114] = Order.FIRE_YAMATO_GUN_2;
		gNamesToOrders.put("MagnaPulse", Order.MAGNA_PULSE);
		allOrders.add(Order.MAGNA_PULSE);
		gIdsToOrders[115] = Order.MAGNA_PULSE;
		gNamesToOrders.put("Burrow", Order.BURROW);
		allOrders.add(Order.BURROW);
		gIdsToOrders[116] = Order.BURROW;
		gNamesToOrders.put("Burrowed", Order.BURROWED);
		allOrders.add(Order.BURROWED);
		gIdsToOrders[117] = Order.BURROWED;
		gNamesToOrders.put("Unburrow", Order.UNBURROW);
		allOrders.add(Order.UNBURROW);
		gIdsToOrders[118] = Order.UNBURROW;
		gNamesToOrders.put("DarkSwarm", Order.DARK_SWARM);
		allOrders.add(Order.DARK_SWARM);
		gIdsToOrders[119] = Order.DARK_SWARM;
		gNamesToOrders.put("CastParasite", Order.CAST_PARASITE);
		allOrders.add(Order.CAST_PARASITE);
		gIdsToOrders[120] = Order.CAST_PARASITE;
		gNamesToOrders.put("SummonBroodlings", Order.SUMMON_BROODLINGS);
		allOrders.add(Order.SUMMON_BROODLINGS);
		gIdsToOrders[121] = Order.SUMMON_BROODLINGS;
		gNamesToOrders.put("EmpShockwave", Order.EMP_SHOCKWAVE);
		allOrders.add(Order.EMP_SHOCKWAVE);
		gIdsToOrders[122] = Order.EMP_SHOCKWAVE;
		gNamesToOrders.put("NukeWait", Order.NUKE_WAIT);
		allOrders.add(Order.NUKE_WAIT);
		gIdsToOrders[123] = Order.NUKE_WAIT;
		gNamesToOrders.put("NukeTrain", Order.NUKE_TRAIN);
		allOrders.add(Order.NUKE_TRAIN);
		gIdsToOrders[124] = Order.NUKE_TRAIN;
		gNamesToOrders.put("NukeLaunch", Order.NUKE_LAUNCH);
		allOrders.add(Order.NUKE_LAUNCH);
		gIdsToOrders[125] = Order.NUKE_LAUNCH;
		gNamesToOrders.put("NukePaint", Order.NUKE_PAINT);
		allOrders.add(Order.NUKE_PAINT);
		gIdsToOrders[126] = Order.NUKE_PAINT;
		gNamesToOrders.put("NukeUnit", Order.NUKE_UNIT);
		allOrders.add(Order.NUKE_UNIT);
		gIdsToOrders[127] = Order.NUKE_UNIT;
		gNamesToOrders.put("NukeGround", Order.NUKE_GROUND);
		allOrders.add(Order.NUKE_GROUND);
		gIdsToOrders[128] = Order.NUKE_GROUND;
		gNamesToOrders.put("NukeTrack", Order.NUKE_TRACK);
		allOrders.add(Order.NUKE_TRACK);
		gIdsToOrders[129] = Order.NUKE_TRACK;
		gNamesToOrders.put("InitArbiter", Order.INIT_ARBITER);
		allOrders.add(Order.INIT_ARBITER);
		gIdsToOrders[130] = Order.INIT_ARBITER;
		gNamesToOrders.put("CloakNearbyUnits", Order.CLOAK_NEARBY_UNITS);
		allOrders.add(Order.CLOAK_NEARBY_UNITS);
		gIdsToOrders[131] = Order.CLOAK_NEARBY_UNITS;
		gNamesToOrders.put("PlaceMine", Order.PLACE_MINE);
		allOrders.add(Order.PLACE_MINE);
		gIdsToOrders[132] = Order.PLACE_MINE;
		gNamesToOrders.put("Rightclickaction", Order.RIGHTCLICKACTION);
		allOrders.add(Order.RIGHTCLICKACTION);
		gIdsToOrders[133] = Order.RIGHTCLICKACTION;
		gNamesToOrders.put("SapUnit", Order.SAP_UNIT);
		allOrders.add(Order.SAP_UNIT);
		gIdsToOrders[134] = Order.SAP_UNIT;
		gNamesToOrders.put("SapLocation", Order.SAP_LOCATION);
		allOrders.add(Order.SAP_LOCATION);
		gIdsToOrders[135] = Order.SAP_LOCATION;
		gNamesToOrders.put("SuicideHoldPosition", Order.SUICIDE_HOLD_POSITION);
		allOrders.add(Order.SUICIDE_HOLD_POSITION);
		gIdsToOrders[136] = Order.SUICIDE_HOLD_POSITION;
		gNamesToOrders.put("Teleport", Order.TELEPORT);
		allOrders.add(Order.TELEPORT);
		gIdsToOrders[137] = Order.TELEPORT;
		gNamesToOrders.put("TeleporttoLocation", Order.TELEPORTTO_LOCATION);
		allOrders.add(Order.TELEPORTTO_LOCATION);
		gIdsToOrders[138] = Order.TELEPORTTO_LOCATION;
		gNamesToOrders.put("PlaceScanner", Order.PLACE_SCANNER);
		allOrders.add(Order.PLACE_SCANNER);
		gIdsToOrders[139] = Order.PLACE_SCANNER;
		gNamesToOrders.put("Scanner", Order.SCANNER);
		allOrders.add(Order.SCANNER);
		gIdsToOrders[140] = Order.SCANNER;
		gNamesToOrders.put("DefensiveMatrix", Order.DEFENSIVE_MATRIX);
		allOrders.add(Order.DEFENSIVE_MATRIX);
		gIdsToOrders[141] = Order.DEFENSIVE_MATRIX;
		gNamesToOrders.put("PsiStorm", Order.PSI_STORM);
		allOrders.add(Order.PSI_STORM);
		gIdsToOrders[142] = Order.PSI_STORM;
		gNamesToOrders.put("Irradiate", Order.IRRADIATE);
		allOrders.add(Order.IRRADIATE);
		gIdsToOrders[143] = Order.IRRADIATE;
		gNamesToOrders.put("Plague", Order.PLAGUE);
		allOrders.add(Order.PLAGUE);
		gIdsToOrders[144] = Order.PLAGUE;
		gNamesToOrders.put("Consume", Order.CONSUME);
		allOrders.add(Order.CONSUME);
		gIdsToOrders[145] = Order.CONSUME;
		gNamesToOrders.put("Ensnare", Order.ENSNARE);
		allOrders.add(Order.ENSNARE);
		gIdsToOrders[146] = Order.ENSNARE;
		gNamesToOrders.put("StasisField", Order.STASIS_FIELD);
		allOrders.add(Order.STASIS_FIELD);
		gIdsToOrders[147] = Order.STASIS_FIELD;
		gNamesToOrders.put("Hallucination1", Order.HALLUCINATION_1);
		allOrders.add(Order.HALLUCINATION_1);
		gIdsToOrders[148] = Order.HALLUCINATION_1;
		gNamesToOrders.put("Hallucination2", Order.HALLUCINATION_2);
		allOrders.add(Order.HALLUCINATION_2);
		gIdsToOrders[149] = Order.HALLUCINATION_2;
		gNamesToOrders.put("ResetCollision1", Order.RESET_COLLISION_1);
		allOrders.add(Order.RESET_COLLISION_1);
		gIdsToOrders[150] = Order.RESET_COLLISION_1;
		gNamesToOrders.put("ResetCollision2", Order.RESET_COLLISION_2);
		allOrders.add(Order.RESET_COLLISION_2);
		gIdsToOrders[151] = Order.RESET_COLLISION_2;
		gNamesToOrders.put("Patrol", Order.PATROL);
		allOrders.add(Order.PATROL);
		gIdsToOrders[152] = Order.PATROL;
		gNamesToOrders.put("CTFCOPInit", Order.CTFCOPINIT);
		allOrders.add(Order.CTFCOPINIT);
		gIdsToOrders[153] = Order.CTFCOPINIT;
		gNamesToOrders.put("CTFCOP1", Order.CTFCOP_1);
		allOrders.add(Order.CTFCOP_1);
		gIdsToOrders[154] = Order.CTFCOP_1;
		gNamesToOrders.put("CTFCOP2", Order.CTFCOP_2);
		allOrders.add(Order.CTFCOP_2);
		gIdsToOrders[155] = Order.CTFCOP_2;
		gNamesToOrders.put("ComputerAI", Order.COMPUTER_AI);
		allOrders.add(Order.COMPUTER_AI);
		gIdsToOrders[156] = Order.COMPUTER_AI;
		gNamesToOrders.put("AtkMoveEP", Order.ATK_MOVE_EP);
		allOrders.add(Order.ATK_MOVE_EP);
		gIdsToOrders[157] = Order.ATK_MOVE_EP;
		gNamesToOrders.put("HarassMove", Order.HARASS_MOVE);
		allOrders.add(Order.HARASS_MOVE);
		gIdsToOrders[158] = Order.HARASS_MOVE;
		gNamesToOrders.put("AIPatrol", Order.AIPATROL);
		allOrders.add(Order.AIPATROL);
		gIdsToOrders[159] = Order.AIPATROL;
		gNamesToOrders.put("GuardPost", Order.GUARD_POST);
		allOrders.add(Order.GUARD_POST);
		gIdsToOrders[160] = Order.GUARD_POST;
		gNamesToOrders.put("RescuePassive", Order.RESCUE_PASSIVE);
		allOrders.add(Order.RESCUE_PASSIVE);
		gIdsToOrders[161] = Order.RESCUE_PASSIVE;
		gNamesToOrders.put("Neutral", Order.NEUTRAL);
		allOrders.add(Order.NEUTRAL);
		gIdsToOrders[162] = Order.NEUTRAL;
		gNamesToOrders.put("ComputerReturn", Order.COMPUTER_RETURN);
		allOrders.add(Order.COMPUTER_RETURN);
		gIdsToOrders[163] = Order.COMPUTER_RETURN;
		gNamesToOrders.put("InitPsiProvider", Order.INIT_PSI_PROVIDER);
		allOrders.add(Order.INIT_PSI_PROVIDER);
		gIdsToOrders[164] = Order.INIT_PSI_PROVIDER;
		gNamesToOrders.put("SelfDestrucing", Order.SELF_DESTRUCING);
		allOrders.add(Order.SELF_DESTRUCING);
		gIdsToOrders[165] = Order.SELF_DESTRUCING;
		gNamesToOrders.put("Critter", Order.CRITTER);
		allOrders.add(Order.CRITTER);
		gIdsToOrders[166] = Order.CRITTER;
		gNamesToOrders.put("HiddenGun", Order.HIDDEN_GUN);
		allOrders.add(Order.HIDDEN_GUN);
		gIdsToOrders[167] = Order.HIDDEN_GUN;
		gNamesToOrders.put("OpenDoor", Order.OPEN_DOOR);
		allOrders.add(Order.OPEN_DOOR);
		gIdsToOrders[168] = Order.OPEN_DOOR;
		gNamesToOrders.put("CloseDoor", Order.CLOSE_DOOR);
		allOrders.add(Order.CLOSE_DOOR);
		gIdsToOrders[169] = Order.CLOSE_DOOR;
		gNamesToOrders.put("HideTrap", Order.HIDE_TRAP);
		allOrders.add(Order.HIDE_TRAP);
		gIdsToOrders[170] = Order.HIDE_TRAP;
		gNamesToOrders.put("RevealTrap", Order.REVEAL_TRAP);
		allOrders.add(Order.REVEAL_TRAP);
		gIdsToOrders[171] = Order.REVEAL_TRAP;
		gNamesToOrders.put("Enabledoodad", Order.ENABLEDOODAD);
		allOrders.add(Order.ENABLEDOODAD);
		gIdsToOrders[172] = Order.ENABLEDOODAD;
		gNamesToOrders.put("Disabledoodad", Order.DISABLEDOODAD);
		allOrders.add(Order.DISABLEDOODAD);
		gIdsToOrders[173] = Order.DISABLEDOODAD;
		gNamesToOrders.put("Warpin", Order.WARPIN);
		allOrders.add(Order.WARPIN);
		gIdsToOrders[174] = Order.WARPIN;
		gNamesToOrders.put("Medic", Order.MEDIC);
		allOrders.add(Order.MEDIC);
		gIdsToOrders[175] = Order.MEDIC;
		gNamesToOrders.put("MedicHeal1", Order.MEDIC_HEAL_1);
		allOrders.add(Order.MEDIC_HEAL_1);
		gIdsToOrders[176] = Order.MEDIC_HEAL_1;
		gNamesToOrders.put("HealMove", Order.HEAL_MOVE);
		allOrders.add(Order.HEAL_MOVE);
		gIdsToOrders[177] = Order.HEAL_MOVE;
		gNamesToOrders.put("MedicHoldPosition", Order.MEDIC_HOLD_POSITION);
		allOrders.add(Order.MEDIC_HOLD_POSITION);
		gIdsToOrders[178] = Order.MEDIC_HOLD_POSITION;
		gNamesToOrders.put("MedicHeal2", Order.MEDIC_HEAL_2);
		allOrders.add(Order.MEDIC_HEAL_2);
		gIdsToOrders[179] = Order.MEDIC_HEAL_2;
		gNamesToOrders.put("Restoration", Order.RESTORATION);
		allOrders.add(Order.RESTORATION);
		gIdsToOrders[180] = Order.RESTORATION;
		gNamesToOrders.put("CastDisruptionWeb", Order.CAST_DISRUPTION_WEB);
		allOrders.add(Order.CAST_DISRUPTION_WEB);
		gIdsToOrders[181] = Order.CAST_DISRUPTION_WEB;
		gNamesToOrders.put("CastMindControl", Order.CAST_MIND_CONTROL);
		allOrders.add(Order.CAST_MIND_CONTROL);
		gIdsToOrders[182] = Order.CAST_MIND_CONTROL;
		gNamesToOrders.put("WarpingDarkArchon", Order.WARPING_DARK_ARCHON);
		allOrders.add(Order.WARPING_DARK_ARCHON);
		gIdsToOrders[183] = Order.WARPING_DARK_ARCHON;
		gNamesToOrders.put("CastFeedback", Order.CAST_FEEDBACK);
		allOrders.add(Order.CAST_FEEDBACK);
		gIdsToOrders[184] = Order.CAST_FEEDBACK;
		gNamesToOrders.put("CastOpticalFlare", Order.CAST_OPTICAL_FLARE);
		allOrders.add(Order.CAST_OPTICAL_FLARE);
		gIdsToOrders[185] = Order.CAST_OPTICAL_FLARE;
		gNamesToOrders.put("CastMaelstrom", Order.CAST_MAELSTROM);
		allOrders.add(Order.CAST_MAELSTROM);
		gIdsToOrders[186] = Order.CAST_MAELSTROM;
		gNamesToOrders.put("JunkYardDog", Order.JUNK_YARD_DOG);
		allOrders.add(Order.JUNK_YARD_DOG);
		gIdsToOrders[187] = Order.JUNK_YARD_DOG;
		gNamesToOrders.put("Fatal", Order.FATAL);
		allOrders.add(Order.FATAL);
		gIdsToOrders[188] = Order.FATAL;
		gNamesToOrders.put("None", Order.NONE);
		allOrders.add(Order.NONE);
		gIdsToOrders[189] = Order.NONE;
		gNamesToOrders.put("Unknown", Order.UNKNOWN);
		allOrders.add(Order.UNKNOWN);
		gIdsToOrders[190] = Order.UNKNOWN;
		gAllOrders = Collections.unmodifiableSet(allOrders);
	}

	public static final Order getOrder(String name) {
		return gNamesToOrders.get(name);
	}

	public static final Set<Order> allOrders() {
		return gAllOrders;
	}

	static final Order getOrderFromId(int id) {
		return gIdsToOrders[id];
	}

	static final int getMaxIdPlusOne() {
		return gIdsToOrders.length;
	}

	@Override
  public final boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		else if (this instanceof Order) {
			final Order other = (Order) object;
			return this.id == other.id;
		}
		else {
			return false;
		}
	}

	@Override
  public final int hashCode() {
		return this.id;
	}
}
