package org.bwapi.proxy.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum ExplosionType {
    NONE(0, "None"),
    NORMAL(1, "Normal"),
    RADIAL_SPLASH(2, "Radial Splash"),
    ENEMY_SPLASH(3, "Enemy Splash"),
    LOCKDOWN(4, "Lockdown"),
    NUCLEAR_MISSILE(5, "Nuclear Missile"),
    PARASITE(6, "Parasite"),
    BROODLINGS(7, "Broodlings"),
    EMP_SHOCKWAVE(8, "EMP Shockwave"),
    IRRADIATE(9, "Irradiate"),
    ENSNARE(10, "Ensnare"),
    PLAGUE(11, "Plague"),
    STASIS_FIELD(12, "Stasis Field"),
    DARK_SWARM(13, "Dark Swarm"),
    CONSUME(14, "Consume"),
    YAMATO_GUN(15, "Yamato Gun"),
    RESTORATION(16, "Restoration"),
    DISRUPTION_WEB(17, "Disruption Web"),
    CORROSIVE_ACID(18, "Corrosive Acid"),
    MIND_CONTROL(19, "Mind Control"),
    FEEDBACK(20, "Feedback"),
    OPTICAL_FLARE(21, "Optical Flare"),
    MAELSTROM(22, "Maelstrom"),
    UNUSED(23, "UNUSED"),
    AIR_SPLASH(24, "Air Splash"),
    UNKNOWN(25, "Unknown");


	protected int id;
	private String name;

	private ExplosionType(int id, String name) {
		this.id = id;
		this.name = name;
	}

	public final int getID() {
		return id;
	}
	
	public String getName() {
	    return name;
	}



	protected static final Map<String, ExplosionType> gNamesToExplosionTypes = new HashMap<String, ExplosionType>();
	protected static final Set<ExplosionType> gAllExplosionTypes;
	protected static final ExplosionType[] gIdsToExplosionTypes;

	static {
		Set<ExplosionType> allExplosionTypes = new HashSet<ExplosionType>();
		gIdsToExplosionTypes = new ExplosionType[26];
		gNamesToExplosionTypes.put("None", ExplosionType.NONE);
		allExplosionTypes.add(ExplosionType.NONE);
		gIdsToExplosionTypes[0] = ExplosionType.NONE;
		gNamesToExplosionTypes.put("Normal", ExplosionType.NORMAL);
		allExplosionTypes.add(ExplosionType.NORMAL);
		gIdsToExplosionTypes[1] = ExplosionType.NORMAL;
		gNamesToExplosionTypes.put("Radial Splash", ExplosionType.RADIAL_SPLASH);
		allExplosionTypes.add(ExplosionType.RADIAL_SPLASH);
		gIdsToExplosionTypes[2] = ExplosionType.RADIAL_SPLASH;
		gNamesToExplosionTypes.put("Enemy Splash", ExplosionType.ENEMY_SPLASH);
		allExplosionTypes.add(ExplosionType.ENEMY_SPLASH);
		gIdsToExplosionTypes[3] = ExplosionType.ENEMY_SPLASH;
		gNamesToExplosionTypes.put("Lockdown", ExplosionType.LOCKDOWN);
		allExplosionTypes.add(ExplosionType.LOCKDOWN);
		gIdsToExplosionTypes[4] = ExplosionType.LOCKDOWN;
		gNamesToExplosionTypes.put("Nuclear Missile", ExplosionType.NUCLEAR_MISSILE);
		allExplosionTypes.add(ExplosionType.NUCLEAR_MISSILE);
		gIdsToExplosionTypes[5] = ExplosionType.NUCLEAR_MISSILE;
		gNamesToExplosionTypes.put("Parasite", ExplosionType.PARASITE);
		allExplosionTypes.add(ExplosionType.PARASITE);
		gIdsToExplosionTypes[6] = ExplosionType.PARASITE;
		gNamesToExplosionTypes.put("Broodlings", ExplosionType.BROODLINGS);
		allExplosionTypes.add(ExplosionType.BROODLINGS);
		gIdsToExplosionTypes[7] = ExplosionType.BROODLINGS;
		gNamesToExplosionTypes.put("EMP Shockwave", ExplosionType.EMP_SHOCKWAVE);
		allExplosionTypes.add(ExplosionType.EMP_SHOCKWAVE);
		gIdsToExplosionTypes[8] = ExplosionType.EMP_SHOCKWAVE;
		gNamesToExplosionTypes.put("Irradiate", ExplosionType.IRRADIATE);
		allExplosionTypes.add(ExplosionType.IRRADIATE);
		gIdsToExplosionTypes[9] = ExplosionType.IRRADIATE;
		gNamesToExplosionTypes.put("Ensnare", ExplosionType.ENSNARE);
		allExplosionTypes.add(ExplosionType.ENSNARE);
		gIdsToExplosionTypes[10] = ExplosionType.ENSNARE;
		gNamesToExplosionTypes.put("Plague", ExplosionType.PLAGUE);
		allExplosionTypes.add(ExplosionType.PLAGUE);
		gIdsToExplosionTypes[11] = ExplosionType.PLAGUE;
		gNamesToExplosionTypes.put("Stasis Field", ExplosionType.STASIS_FIELD);
		allExplosionTypes.add(ExplosionType.STASIS_FIELD);
		gIdsToExplosionTypes[12] = ExplosionType.STASIS_FIELD;
		gNamesToExplosionTypes.put("Dark Swarm", ExplosionType.DARK_SWARM);
		allExplosionTypes.add(ExplosionType.DARK_SWARM);
		gIdsToExplosionTypes[13] = ExplosionType.DARK_SWARM;
		gNamesToExplosionTypes.put("Consume", ExplosionType.CONSUME);
		allExplosionTypes.add(ExplosionType.CONSUME);
		gIdsToExplosionTypes[14] = ExplosionType.CONSUME;
		gNamesToExplosionTypes.put("Yamato Gun", ExplosionType.YAMATO_GUN);
		allExplosionTypes.add(ExplosionType.YAMATO_GUN);
		gIdsToExplosionTypes[15] = ExplosionType.YAMATO_GUN;
		gNamesToExplosionTypes.put("Restoration", ExplosionType.RESTORATION);
		allExplosionTypes.add(ExplosionType.RESTORATION);
		gIdsToExplosionTypes[16] = ExplosionType.RESTORATION;
		gNamesToExplosionTypes.put("Disruption Web", ExplosionType.DISRUPTION_WEB);
		allExplosionTypes.add(ExplosionType.DISRUPTION_WEB);
		gIdsToExplosionTypes[17] = ExplosionType.DISRUPTION_WEB;
		gNamesToExplosionTypes.put("Corrosive Acid", ExplosionType.CORROSIVE_ACID);
		allExplosionTypes.add(ExplosionType.CORROSIVE_ACID);
		gIdsToExplosionTypes[18] = ExplosionType.CORROSIVE_ACID;
		gNamesToExplosionTypes.put("Mind Control", ExplosionType.MIND_CONTROL);
		allExplosionTypes.add(ExplosionType.MIND_CONTROL);
		gIdsToExplosionTypes[19] = ExplosionType.MIND_CONTROL;
		gNamesToExplosionTypes.put("Feedback", ExplosionType.FEEDBACK);
		allExplosionTypes.add(ExplosionType.FEEDBACK);
		gIdsToExplosionTypes[20] = ExplosionType.FEEDBACK;
		gNamesToExplosionTypes.put("Optical Flare", ExplosionType.OPTICAL_FLARE);
		allExplosionTypes.add(ExplosionType.OPTICAL_FLARE);
		gIdsToExplosionTypes[21] = ExplosionType.OPTICAL_FLARE;
		gNamesToExplosionTypes.put("Maelstrom", ExplosionType.MAELSTROM);
		allExplosionTypes.add(ExplosionType.MAELSTROM);
		gIdsToExplosionTypes[22] = ExplosionType.MAELSTROM;
		gNamesToExplosionTypes.put("Air Splash", ExplosionType.AIR_SPLASH);
		allExplosionTypes.add(ExplosionType.AIR_SPLASH);
		gIdsToExplosionTypes[24] = ExplosionType.AIR_SPLASH;
		gNamesToExplosionTypes.put("Unknown", ExplosionType.UNKNOWN);
		allExplosionTypes.add(ExplosionType.UNKNOWN);
		gIdsToExplosionTypes[25] = ExplosionType.UNKNOWN;
		gAllExplosionTypes = Collections.unmodifiableSet(allExplosionTypes);
	}

	public static final ExplosionType getExplosionType(String name) {
		return gNamesToExplosionTypes.get(name);
	}

	public static final Set<ExplosionType> allExplosionTypes() {
		return gAllExplosionTypes;
	}

	static final ExplosionType getExplosionTypeFromId(int id) {
		return gIdsToExplosionTypes[id];
	}

	static final int getMaxIdPlusOne() {
		return gIdsToExplosionTypes.length;
	}

}
