package org.bwapi.proxy.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum DamageType {
    INDEPENDENT (0, "Independent"),
    EXPLOSIVE (1, "Explosive"),
    CONCUSSIVE (2, "Concussive"),
    NORMAL (3, "Normal"),
    IGNORE_ARMOR (4, "Ignore Armor"),
    NONE (5, "None"),
    UNKNOWN (6, "Unknown");


	protected int id;
	protected String name;

	private DamageType(int id, String name) {
		this.id = id;
		this.name = name;
	}

    public final int getID() {
		return id;
	}
	public String getName() {
	    return name;
	}
	
	protected static final Map<String, DamageType> gNamesToDamageTypes = new HashMap<String, DamageType>();
	protected static final Set<DamageType> gAllDamageTypes;
	protected static final DamageType[] gIdsToDamageTypes;

	static {
		Set<DamageType> allDamageTypes = new HashSet<DamageType>();
		gIdsToDamageTypes = new DamageType[7];
		gNamesToDamageTypes.put("Independent", DamageType.INDEPENDENT);
		allDamageTypes.add(DamageType.INDEPENDENT);
		gIdsToDamageTypes[0] = DamageType.INDEPENDENT;
		gNamesToDamageTypes.put("Explosive", DamageType.EXPLOSIVE);
		allDamageTypes.add(DamageType.EXPLOSIVE);
		gIdsToDamageTypes[1] = DamageType.EXPLOSIVE;
		gNamesToDamageTypes.put("Concussive", DamageType.CONCUSSIVE);
		allDamageTypes.add(DamageType.CONCUSSIVE);
		gIdsToDamageTypes[2] = DamageType.CONCUSSIVE;
		gNamesToDamageTypes.put("Normal", DamageType.NORMAL);
		allDamageTypes.add(DamageType.NORMAL);
		gIdsToDamageTypes[3] = DamageType.NORMAL;
		gNamesToDamageTypes.put("Ignore Armor", DamageType.IGNORE_ARMOR);
		allDamageTypes.add(DamageType.IGNORE_ARMOR);
		gIdsToDamageTypes[4] = DamageType.IGNORE_ARMOR;
		gNamesToDamageTypes.put("None", DamageType.NONE);
		allDamageTypes.add(DamageType.NONE);
		gIdsToDamageTypes[5] = DamageType.NONE;
		gNamesToDamageTypes.put("Unknown", DamageType.UNKNOWN);
		allDamageTypes.add(DamageType.UNKNOWN);
		gIdsToDamageTypes[6] = DamageType.UNKNOWN;
		gAllDamageTypes = Collections.unmodifiableSet(allDamageTypes);
	}

	public static final DamageType getDamageType(String name) {
		return gNamesToDamageTypes.get(name);
	}

	public static final Set<DamageType> allDamageTypes() {
		return gAllDamageTypes;
	}

	static final DamageType getDamageTypeFromId(int id) {
		return gIdsToDamageTypes[id];
	}
	
}
