package org.bwapi.proxy.model;

public interface CommandValidator {
	public boolean canAttackMove(ROUnit self, Position position);
	public boolean canAttackUnit(ROUnit self, ROUnit target);
	public boolean canBuild(ROUnit self, TilePosition position, UnitType type);
	public boolean canBuildAddon(ROUnit self, UnitType type);
	public boolean canBurrow(ROUnit self);
	public boolean canCancelAddon(ROUnit self);
	public boolean canCancelConstruction(ROUnit self);
	public boolean canCancelMorph(ROUnit self);
	public boolean canCancelResearch(ROUnit self);
	public boolean canCancelTrain(ROUnit self);
	public boolean canCancelTrain(ROUnit self, int slot);
	public boolean canCancelUpgrade(ROUnit self);
	public boolean canCloak(ROUnit self);
	public boolean canDecloak(ROUnit self);
	public boolean canFollow(ROUnit self, ROUnit target);
	public boolean canHaltConstruction(ROUnit self);
	public boolean canHoldPosition(ROUnit self);
	public boolean canLand(ROUnit self, TilePosition position);
	public boolean canLift(ROUnit self);
	public boolean canLoad(ROUnit self, ROUnit target);
	public boolean canMorph(ROUnit self, UnitType type);
	public boolean canPatrol(ROUnit self, Position position);
	public boolean canRepair(ROUnit self, ROUnit target);
	public boolean canResearch(ROUnit self, TechType tech);
	public boolean canRightClick(ROUnit self, Position position);
	public boolean canRightClick(ROUnit self, ROUnit target);
	public boolean canSetRallyPosition(ROUnit self, Position target);
	public boolean canSetRallyUnit(ROUnit self, ROUnit target);
	public boolean canSiege(ROUnit self);
	public boolean canStop(ROUnit self);
	public boolean canTrain(ROUnit self, UnitType type);
	public boolean canUnburrow(ROUnit self);
	public boolean canUnload(ROUnit self, ROUnit target);
	public boolean canUnloadAll(ROUnit self);
	public boolean canUnloadAll(ROUnit self, Position position);
	public boolean canUnsiege(ROUnit self);
	public boolean canUpgrade(ROUnit self, UpgradeType upgrade);
	public boolean canUseTech(ROUnit self, TechType tech);
	public boolean canUseTech(ROUnit self, TechType tech, Position position);
	public boolean canUseTech(ROUnit self, TechType tech, ROUnit target);
	
	public static class Invalidator implements CommandValidator {
		private boolean canIssueCommand(ROUnit self) {
			return false;
		}

		@Override
		public boolean canAttackMove(ROUnit self, Position position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canAttackUnit(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canBuild(ROUnit self, TilePosition position, UnitType type) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canBuildAddon(ROUnit self, UnitType type) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canBurrow(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelAddon(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelConstruction(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelMorph(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelResearch(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelTrain(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelTrain(ROUnit self, int slot) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelUpgrade(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCloak(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canDecloak(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canFollow(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canHaltConstruction(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canHoldPosition(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canLand(ROUnit self, TilePosition position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canLift(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canLoad(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canMorph(ROUnit self, UnitType type) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canPatrol(ROUnit self, Position position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canRepair(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canResearch(ROUnit self, TechType tech) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canRightClick(ROUnit self, Position position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canRightClick(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canSetRallyPosition(ROUnit self, Position target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canSetRallyUnit(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canSiege(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canStop(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canTrain(ROUnit self, UnitType type) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUnburrow(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUnload(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUnloadAll(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUnloadAll(ROUnit self, Position position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUnsiege(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUpgrade(ROUnit self, UpgradeType upgrade) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUseTech(ROUnit self, TechType tech) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUseTech(ROUnit self, TechType tech, Position position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUseTech(ROUnit self, TechType tech, ROUnit target) {
			return canIssueCommand(self);
		}
	}
	
	public static class DefaultValidator implements CommandValidator {
		private final Game g;
		
		public DefaultValidator(Game g) {
			this.g = g;
		}
		
		private boolean canIssueCommand(ROUnit self) {
			return self.getPlayer().equals(g.self());
		}

		@Override
		public boolean canAttackMove(ROUnit self, Position position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canAttackUnit(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canBuild(ROUnit self, TilePosition position, UnitType type) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canBuildAddon(ROUnit self, UnitType type) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canBurrow(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelAddon(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelConstruction(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelMorph(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelResearch(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelTrain(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelTrain(ROUnit self, int slot) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCancelUpgrade(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canCloak(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canDecloak(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canFollow(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canHaltConstruction(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canHoldPosition(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canLand(ROUnit self, TilePosition position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canLift(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canLoad(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canMorph(ROUnit self, UnitType type) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canPatrol(ROUnit self, Position position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canRepair(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canResearch(ROUnit self, TechType tech) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canRightClick(ROUnit self, Position position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canRightClick(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canSetRallyPosition(ROUnit self, Position target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canSetRallyUnit(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canSiege(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canStop(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canTrain(ROUnit self, UnitType type) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUnburrow(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUnload(ROUnit self, ROUnit target) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUnloadAll(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUnloadAll(ROUnit self, Position position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUnsiege(ROUnit self) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUpgrade(ROUnit self, UpgradeType upgrade) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUseTech(ROUnit self, TechType tech) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUseTech(ROUnit self, TechType tech, Position position) {
			return canIssueCommand(self);
		}
		@Override
		public boolean canUseTech(ROUnit self, TechType tech, ROUnit target) {
			return canIssueCommand(self);
		}
	}
}
