package org.bwapi.proxy.model;

import java.util.LinkedList;
import java.util.Queue;

import org.bwapi.proxy.messages.BasicTypes;
import org.bwapi.proxy.messages.BasicTypes.Position;
import org.bwapi.proxy.messages.Commands.Command;
import org.bwapi.proxy.messages.DrawCommands.DrawCommand;
import org.bwapi.proxy.messages.Messages.Flag;
import org.bwapi.proxy.messages.Messages.FrameCommands;

class CommandManager {
	Queue<Command> commandQueue = new LinkedList<Command>();
	Queue<DrawCommand> drawCommandQueue = new LinkedList<DrawCommand>();
	Queue<String> sendTextQueue = new LinkedList<String>();
	Queue<String> printfQueue = new LinkedList<String>();
	Queue<Flag> flagQueue = new LinkedList<Flag>();
	
	private boolean changedGameSpeed = false;
	private int newGameSpeed;
	private Position screenPosition;
	
	void addCommand(Command c) {
		commandQueue.add(c);
	}
	
	void addDrawCommand(DrawCommand c) {
		drawCommandQueue.add(c);
	}
	
	void setGameSpeed(int speed) {
		newGameSpeed = speed;
		changedGameSpeed = true;
	}
	
	void addSendText(String text) {
		sendTextQueue.add(text);
	}
	
	void addPrintf(String printf) {
		printfQueue.add(printf);
	}
	
	void addFlag(Flag f) {
		flagQueue.add(f);
	}

	FrameCommands.Builder flushCommands() {
		FrameCommands.Builder b = FrameCommands.newBuilder();
		b.addAllCommands(commandQueue);
		commandQueue.clear();

		if (changedGameSpeed) {
			b.setGameSpeed(newGameSpeed);
			changedGameSpeed = false;
		}
		
		b.addAllSendText(sendTextQueue);
		sendTextQueue.clear();

	
		b.addAllPrintf(printfQueue);
		printfQueue.clear();
		
		b.addAllFlags(flagQueue);
		flagQueue.clear();
		if(Game.getInstance().isDrawing())
			b.addAllDrawCommands(drawCommandQueue);
		drawCommandQueue.clear();
		
		if(screenPosition != null) {
			b.setScreenPosition(screenPosition);
			screenPosition = null;
		}
		
		return b;
	}

	public void setScreenPosition(int x, int y) {
	  this.screenPosition = BasicTypes.Position.newBuilder().setX(x).setY(y).build();
	 
  }
}
