package org.bwapi.proxy.model;

import java.util.Map;

import org.bwapi.proxy.messages.TerrainMessages;

public class Chokepoint {

	private TerrainMessages.Chokepoint choke;
	private Bwta bwta;
	final int id;
	
	public Chokepoint(TerrainMessages.Chokepoint choke, Bwta bwta) {
	  this.choke = choke;
	  this.id = choke.getId();
	  this.bwta = bwta;
  }
	
	public Map.Entry<Region, Region> getRegions() {
		return new Map.Entry<Region, Region>() {

			@Override
      public Region getKey() {
	      return bwta.regionsList.get(choke.getRegion1());
      }

			@Override
      public Region getValue() {
				return bwta.regionsList.get(choke.getRegion2());
      }

			@Override
      public Region setValue(Region value) {
	      throw new UnsupportedOperationException("No.");
      }
			
		};
		
	}
	
	public Map.Entry<Position, Position> getSides() {
		return new Map.Entry<Position, Position>() {

			@Override
      public Position getKey() {
				return new Position(choke.getSide1());
      }

			@Override
      public Position getValue() {
				return new Position(choke.getSide2());
      }

			@Override
      public Position setValue(Position value) {
	      throw new UnsupportedOperationException("No.");
      }
			
		};
		
	}
	
	public Position getCenter() {
		return new Position(choke.getCenter());
	}
	
	public double getWidth() {
		return choke.getWidth();
	}

	@Override
  public int hashCode() {
	  final int prime = 31;
	  int result = 1;
	  result = prime * result + id;
	  return result;
  }

	@Override
  public boolean equals(Object obj) {
	  if (this == obj)
		  return true;
	  if (obj == null)
		  return false;
	  if (getClass() != obj.getClass())
		  return false;
	  Chokepoint other = (Chokepoint) obj;
	  if (id != other.id)
		  return false;
	  return true;
  }

}
