package org.bwapi.proxy.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.bwapi.proxy.messages.TerrainMessages;
import org.bwapi.proxy.messages.TerrainMessages.StaticTerrainInfo;

public class Bwta {
	
	private Bwta() {
		
	}
	
	private static Bwta instance = new Bwta(); 
	private Set<Region> regions = new HashSet<Region>();
	private Set<Chokepoint> chokepoints = new HashSet<Chokepoint>();
	private Set<BaseLocation> baselocations = new HashSet<BaseLocation>();
	private Set<Polygon> unwalkablePolygons = new HashSet<Polygon>();
	private Set<BaseLocation> startLocations = new HashSet<BaseLocation>();
	private boolean analyzed = false;
	
	List<Region> regionsList = new ArrayList<Region>();
	List<Chokepoint> chokepointsList = new ArrayList<Chokepoint>();
	List<BaseLocation> baselocationsList = new ArrayList<BaseLocation>();
	List<Polygon> unwalkablePolygonsList = new ArrayList<Polygon>();
	
	public static Bwta getInstance() {
		return instance;
	}
	
	public boolean isAnalyzed() {
		return analyzed;
	}
	
	public Set<Region> getRegions() {
  	return regions;
  }

	public Set<Chokepoint> getChokepoints() {
  	return chokepoints;
  }

	public Set<BaseLocation> getBaseLocations() {
  	return baselocations;
  }

	public Set<Polygon> getUnwalkablePolygons() {
  	return unwalkablePolygons;
  }

	public void setTerrainData(StaticTerrainInfo data) {
		analyzed = true;
		
		for(TerrainMessages.Region region: data.getRegionsList()) {
			Region r = new Region(region,this);
			regions.add(r);
			regionsList.add(r);
		}
		Collections.sort(regionsList, new Comparator<Region>() {

			@Override
      public int compare(Region arg0, Region arg1) {
	      return arg0.id - arg1.id;
      }
			
		});
		for(TerrainMessages.BaseLocation loc: data.getBaseLocationsList()) {
			BaseLocation bl = new BaseLocation(loc,this);
			baselocations.add(bl);
			baselocationsList.add(bl);
		}
		Collections.sort(baselocationsList, new Comparator<BaseLocation>() {

			@Override
      public int compare(BaseLocation arg0, BaseLocation arg1) {
	      return arg0.id - arg1.id;
      }
			
		});
		
		for(TerrainMessages.Polygon p: data.getUnwalkablePolygonList()) {
			Polygon bl = new Polygon(p);
			unwalkablePolygons.add(bl);
		}
		
		for(TerrainMessages.Chokepoint p: data.getChokepointsList()) {
			Chokepoint bl = new Chokepoint(p,this);
			chokepoints.add(bl);
			chokepointsList.add(bl);
		}
		Collections.sort(chokepointsList, new Comparator<Chokepoint>() {

			@Override
      public int compare(Chokepoint arg0, Chokepoint arg1) {
	      return arg0.id - arg1.id;
      }
			
		});
		
		for(int startLocationId: data.getStartLocationsList()) {
			startLocations.add(baselocationsList.get(startLocationId));
		}
		
	}


	public Set<BaseLocation> getStartLocations() {
	  return startLocations;
  }
	

	static <C> Set<C> wrap(List<C> chokepointsList, List<Integer> ind) {
	  HashSet<C> ret = new HashSet<C>();
	  for(int i: ind) {
	  	ret.add(chokepointsList.get(i));
	  }
	  return ret;
  }

	public BaseLocation getNearestBaseLocation(TilePosition pos) {
		// TODO make this use ground distance instead of air distance.
		double minDistance = Double.MAX_VALUE;
		BaseLocation best = null;
		for (BaseLocation l : baselocations) {
			double d = pos.getDistance(l.getTilePosition());
			if (d < minDistance) {
				best = l;
				minDistance = d;
			}
		}
		return best;
	}
}
