package org.bwapi.proxy.model;

import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.messages.GameMessages.BulletType;

/** 
 * Represents information about bullets. Currently only PsiStorm is sent.
 * 
 * @author dlwh
 *
 */
public class Bullet {
	private GameMessages.Bullet b;

	public Bullet(GameMessages.Bullet b) {
	  super();
	  this.b = b;
  }
	
	@Override
	public boolean equals(Object obj) {
		if (obj == this) return true;
		if (obj == null) return false;
		if (!(obj instanceof Bullet)) return false;
		return ((Bullet)obj).getId() == getId();
	}
	
	@Override
	public int hashCode() {
		return getId();
	}

	public double getAngle() {
	  return b.getAngle();
  }

	public boolean getExists() {
	  return b.getExists();
  }

	public int getId() {
	  return b.getId();
  }

	public boolean getIsVisible() {
	  return b.getIsVisible();
  }

	public Player getPlayer() {
	  return b.hasPlayer() ? Game.getInstance().playerManager.getPlayer(b.getPlayer()) : null;
  }

	public Position getPosition() {
	  return new Position(b.getPosition());
  }

	public int getRemoveTimer() {
	  return b.getRemoveTimer();
  }

	public ROUnit getSource() {
	  return b.hasSource() ? new Unit(b.getSource().getId()) : null;
  }

	public ROUnit getTarget() {
	  return b.hasTarget() ? new Unit(b.getTarget().getId()) : null;
  }
	
	public BulletType getType() {
		return b.getType();
	}

	public Position getTargetPosition() {
	  return new Position(b.getTargetPosition());
  }

	public double getVelocityX() {
	  return b.getVelocityX();
  }

	public double getVelocityY() {
	  return b.getVelocityY();
  }
}
