package org.bwapi.proxy.model;

import java.util.HashSet;
import java.util.Set;

import org.bwapi.proxy.messages.GameMessages;
import org.bwapi.proxy.messages.TerrainMessages;

public class BaseLocation {

	private TerrainMessages.BaseLocation loc;
	final int id;
	private Bwta bwta;

	public BaseLocation(TerrainMessages.BaseLocation loc, Bwta bwta) {
		this.loc = loc;
		this.bwta = bwta;
		this.id = loc.getId();
	}

	public Position getPosition() {
		return new Position(loc.getPosition());
	}

	public TilePosition getTilePosition() {
		return new TilePosition(loc.getTilePosition());
	}

	public Region getRegion() {
		return bwta.regionsList.get(loc.getRegion());
	}

	public int minerals() {
		return loc.getNumMinerals();
	}

	public int gas() {
		return loc.getNumGas();
	}

	public Set<? extends ROUnit> getMinerals() {
		Set<Unit> minerals = new HashSet<Unit>();
		for (GameMessages.UnitId u : loc.getMineralsList()) {
			minerals.add(new Unit(u.getId()));
		}
		return minerals;
	}

	public Set<? extends ROUnit> getStaticMinerals() {
		Set<Unit> minerals = new HashSet<Unit>();
		for (GameMessages.UnitId u : loc.getStaticMineralsList()) {
			minerals.add(new Unit(u.getId()));
		}
		return minerals;
	}

	public Set<? extends ROUnit> getGeysers() {
		Set<Unit> geysers = new HashSet<Unit>();
		for (GameMessages.UnitId u : loc.getGeysersList()) {
			geysers.add(new Unit(u.getId()));
		}
		return geysers;
	}

	public boolean isIsland() {
		return loc.getIsland();
	}

	public boolean isMineralOnly() {
		return loc.getMineralOnly();
	}

	public boolean isStartLocation() {
		return loc.getStartLocation();
	}
	
	@Override
  public int hashCode() {
	  final int prime = 31;
	  int result = 1;
	  result = prime * result + (loc.getId());
	  return result;
  }

	@Override
  public boolean equals(Object obj) {
	  if (this == obj)
		  return true;
	  if (obj == null)
		  return false;
	  if (getClass() != obj.getClass())
		  return false;
	  BaseLocation other = (BaseLocation) obj;
	  return other.loc.getId() == this.loc.getId();
  }

}
