#pragma once

#include <BWAPI.h>
#include <BWTA.h>
#include <hash_map>
#include "aimodule.pb.h"

#include <boost/thread/thread.hpp>
#include <boost/thread/condition_variable.hpp>



class TerrainAnalysis {
	// terrain stuff:
	boost::thread terrainWorker;
	bool terrainFinished;
	bool terrainSent;
	boost::mutex terrainMutex;
	boost::condition_variable cond;
	stdext::hash_map<BWTA::Region*,int> rids;
	stdext::hash_map<BWTA::BaseLocation*,int> bids;
	stdext::hash_map<BWTA::Chokepoint*,int> cids;

	static void actuallyRunTerrainAnalysis(TerrainAnalysis* self);

	void setPolygon(const BWTA::Polygon& p, messages::Polygon* mp);

	int idOf(BWTA::Region* r);
	int idOf(BWTA::BaseLocation* b);
	int idOf(BWTA::Chokepoint*);

	

	TerrainAnalysis(const TerrainAnalysis&) {}

public:
	void waitForTerrain();
	TerrainAnalysis(): terrainFinished(false), terrainSent(false) {}
	void startTerrainAnalysis();
	void setTerrainSent() { terrainSent = true; }
	bool isTerrainSent() { return terrainSent; }
	
	void addTerrainAnalysisData(messages::StaticTerrainInfo* msg);
	
	 bool isTerrainFinished() {
		boost::mutex::scoped_lock lock(terrainMutex);
		return terrainFinished;
	}
};

template<typename P1,typename P2>
void set_position(P1 pos, P2* pos2)
{
	pos2->set_x(pos.x());
	pos2->set_y(pos.y());
}