#pragma once
#include <iosfwd>                          // streamsize
#include <string>

#define _SCL_SECURE_NO_WARNINGS
#include <boost/iostreams/categories.hpp>  // sink_tag
#include <boost/iostreams/stream.hpp>  // sink_tag

class NetDevice {
	int sockfd;

public:
	NetDevice(const std::string& host, int port);
	typedef char                char_type;
		
	struct category:   boost::iostreams::bidirectional_device_tag, boost::iostreams::closable_tag{};
	std::streamsize read(char* s, std::streamsize n);
	std::streamsize write(const char* s, std::streamsize n);
	void close(std::ios_base::openmode);
};

typedef boost::iostreams::stream<NetDevice> NetStream;