#include "netstream.h"


#include <stdio.h>
#include <sstream>
#include <string>
#include <fstream>
#include <BWAPI.h>
#include <windows.h>
#include <iostream>

using namespace BWAPI;

NetDevice::NetDevice(const std::string& host_name, int port):sockfd(-1) {


	unsigned long nRemoteAddr = inet_addr(host_name.c_str());

	if (((sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == INVALID_SOCKET)) {
			     char Message[1024];
		 int ErrorCode = WSAGetLastError();

		FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS |
                  FORMAT_MESSAGE_MAX_WIDTH_MASK, NULL, ErrorCode,
                  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                  (LPSTR) Message, 1024, NULL);
			Broodwar->sendText(Message);
		char buf[60];
		throw std::runtime_error("could not connect to " + host_name + " " +  _itoa(port,buf,10));
	}



	sockaddr_in sinRemote;
	sinRemote.sin_family = AF_INET;
	sinRemote.sin_addr.s_addr = nRemoteAddr;
	sinRemote.sin_port = htons(port);
	if (connect(sockfd, (sockaddr*)&sinRemote, sizeof(sockaddr_in)) == 
		SOCKET_ERROR) {
			sockfd = INVALID_SOCKET;
			char buf[60];
			throw std::runtime_error("could not connect to " + host_name + " " +  _itoa(port,buf,10));
	}



}

void NetDevice::close(std::ios_base::openmode) {
	if(sockfd != -1) {
		closesocket(sockfd);
		sockfd = -1;
	}
	Broodwar->printf("closing connection");


}

std::streamsize NetDevice::read(char *s, std::streamsize n) {
	int ret = recv(sockfd,s, n, 0);
	if(ret == SOCKET_ERROR) {
     char Message[1024];
	 int ErrorCode = WSAGetLastError();

    FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS |
                  FORMAT_MESSAGE_MAX_WIDTH_MASK, NULL, ErrorCode,
                  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                  (LPSTR) Message, 1024, NULL);
		Broodwar->sendText(Message);
		return -1;
	}
	return ret;
}

std::streamsize NetDevice::write(const char *s, std::streamsize n) {
	int ret = send(sockfd,s, n, 0);
	if(ret == SOCKET_ERROR) {
     char Message[1024];
	 int ErrorCode = WSAGetLastError();

    FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS |
                  FORMAT_MESSAGE_MAX_WIDTH_MASK, NULL, ErrorCode,
                  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                  (LPSTR) Message, 1024, NULL);
		Broodwar->sendText(Message);
		return -1;
	}
	return ret;
}