#pragma once

#include "aimodule.pb.h"
#include <BWAPI.h>
#include <boost/format.hpp>
#include <set>
#include <BWTA.h>
#include <google/protobuf/repeated_field.h>
#include <hash_map>
#include <hash_set>
#include <string>
#include "netstream.h"

#include <fstream>

#include <google/protobuf/io/zero_copy_stream_impl.h>
#include "terrainanalysis.h"


class ClientModule : public BWAPI::AIModule
{
	messages::FrameMessage frameMessage;
	NetStream* proxyBotSocket;
	TerrainAnalysis terrain;
	stdext::hash_map<int,BWAPI::Unit*> unitMap;
	std::set<BWAPI::Unit*> registeredUnits;
	
	std::string stringbuf;
	std::ofstream log_;

	void log(const std::string& out) { log(boost::format(out)); }
	void log(const boost::format& format);

	bool writeMessageToStream(std::ostream& out, const google::protobuf::Message& message);
	bool readMessageFromStream(std::istream& out, google::protobuf::Message& message);
	void handleCommands(const messages::FrameCommands& commands);
	void registerUnit(messages::FrameMessage& frameMessage, BWAPI::Unit* u);
	void handleBotDefeated(const std::string& botName, const std::string& botCode, const std::string& playerName);
public:
	ClientModule();
	virtual void onStart();
	virtual void onFrame();
	virtual void onEnd(bool isWinner);
	virtual void onUnitCreate(BWAPI::Unit* unit);
	virtual void onUnitDestroy(BWAPI::Unit* unit);
	virtual void onSendText(std::string text);


	/** BWAPI calls this when another player sends a message. */
	virtual void onReceiveText(BWAPI::Player* player, std::string text);

	/** BWAPI calls this when a player leaves the game. */
	virtual void onPlayerLeft(BWAPI::Player* player);

	/** BWAPI calls this when a nuclear launch has been detected. If the target position is visible, or if
	* Complete Map Information is enabled, the target position will also be provided. If Complete Map
	* Information is disabled and the target position is not visible, target will be set to
	* Positions::Unknown. */
	virtual void onNukeDetect(BWAPI::Position target);

	/** BWAPI calls this when a unit changes type, such as from a Zerg Drone to a Zerg Hatchery, or from a
	* Terran Siege Tank Tank Mode to Terran Siege Tank Siege Mode. This is not called when the type changes
	* to or from UnitTypes::Unknown (which happens when a unit becomes visible or invisible). */
	virtual void onUnitMorph(BWAPI::Unit* unit);

	/** BWAPI calls this the instant a previously invisible unit becomes visible. The complete map
	* information flag has no effect on this callback. */
	virtual void onUnitShow(BWAPI::Unit* unit);

	/** BWAPI calls this right before a unit becomes invisible, so if you want your non-cheating AI to
	* remember where it last saw a unit, this callback would be a good place to implement it. The complete
	* map information flag has no effect on this callback. */
	virtual void onUnitHide(BWAPI::Unit* unit);

	/** BWAPI calls this when an accessible unit changes ownership. */
	virtual void onUnitRenegade(BWAPI::Unit* unit);

	// TODO: Add Doxygen documentation
	virtual void onSaveGame(std::string gameName);

};


// needs to be a macro to get laziness
#define SET_ID(source, target) if( (source) != 0) target->set_id( (source)->getID())

template<typename Container, typename P2>
void set_ids(const Container& c, google::protobuf::RepeatedPtrField<P2>* ptr) {
	ptr->Reserve(c.size());
	for(typename Container::const_iterator iter = c.begin(); iter != c.end(); ++iter) {
		SET_ID(*iter, ptr->Add());
	}
}