package undermind.micropacket;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import edu.berkeley.nlp.starcraft.util.UnitUtils;

public class VultureSquad {

	M3chSquad msquad = null;
	Set<Vulture> myVultures = new HashSet<Vulture>();
	Game mGame = Game.getInstance();
	Random rgen = new Random();

	public VultureSquad(M3chSquad m3chSquad){
		msquad = m3chSquad;
	}

	public void addUnit(Unit u){
		myVultures.add(new Vulture(u));
	}
	public void removeUnit(Unit u){
		Vulture tr = null;
		for (Vulture v : myVultures) {
			if (v.unit.getID() == u.getID()) {
				tr = v;
				break;
			}

		}

		if (tr != null) myVultures.remove(tr);
	}
	public void onFrame(){


		for (Vulture vulture : myVultures) {
			vulture.timeNeeded--;
			if (vulture.timeNeeded > 0)
				continue;
			Unit unit = vulture.unit;
			double nearestDistance = Double.POSITIVE_INFINITY;
			ROUnit closestEnemy = UnitUtils.getClosest(unit,
					msquad.everyNearbyUnits());
			Position medianpos = msquad.getMedian();
			mGame.drawCircleMap(medianpos, 10, Color.BLUE, false);

			double dist = unit.getTilePosition().getDistance(
					medianpos);



			if (shouldPoop(unit, closestEnemy)){
				vulture.timeNeeded = 13;
				unit.useTech(TechType.SPIDER_MINES, unit.getPosition());
				continue;
			}

			/*else if (msquad.master.allVisibleEnemies.size() != 0
					&& nearestDistance < 8) { // When enemies are close by
				TilePosition moveTo = null;
				if (nearestDistance < 4.5 || unit.isAttacking()) {
					// If very close to an enemy, or shooting, do the kiting thing 
					TilePosition myPosition = unit.getTilePosition();
					int x = myPosition.x();
					int y = myPosition.y();
					double biggest = nearestDistance;
					//Find position to run to 
					for (int dx = -4; dx <= 4; dx++) {
						for (int dy = -4; dy <= 4; dy++) {
							if (x + dx < 0 || x + dx >= mGame.getMapWidth()
									|| y + dy >= mGame.getMapHeight()
									|| y + dy < 0)
								continue;
							TilePosition newPosition = new TilePosition(x
									+ dx, y + dy);
							double newDist = newPosition
							.getDistance(closestEnemy.getPosition());
							Position center = Position
							.centerOfTile(newPosition);
							int xl = center.x() / 8;
							int yl = center.y() / 8;

							int s = mGame.unitsOnTile(newPosition).size();
							boolean canWalk = mGame.isWalkable(xl, yl)
							&& (s == 0 || mGame
									.unitsOnTile(newPosition)
									.iterator().next().getID() == unit
									.getID());
							if (newDist >= biggest && canWalk) {
								biggest = newDist;
								moveTo = newPosition;
							}
						}
					}
					if (moveTo == null) {
						unit.attack(closestEnemy);
					} else
						unit.move(moveTo);
				} else if (nearestDistance < 7) // If relatively far from an enemy, just engage
					unit.attack(closestEnemy);
			}  */




			else if (dist > 11 && medianpos != null && medianpos != Position.INVALID) { // If too far away from the tanks, attack move back towards them.
				if (msquad.master.time % 20 == 0)
					unit.move(medianpos);
			}

			else if (msquad.everyNearbyGroundUnits().size() != 0) {
				ROUnit targ = null;
				int bestprio = -1000;
				for (ROUnit ue : msquad.everyNearbyUnits()) {
					if (ue.getDistance(unit) < 340
							&& getVPriority(ue, unit, false) > bestprio) {
						bestprio = getVPriority(ue, unit, false);
						targ = ue;
					}
				}
				for (ROUnit ue : msquad.master.enemyBuildings) {
					if (ue.getDistance(unit) < 250
							&& getVPriority(ue, unit, false) > bestprio) {
						bestprio = getVPriority(ue, unit, false);
						targ = ue;
					}
				}

				ROUnit k = unit.getTarget();
				if (targ != null && msquad.master.time % 20 == 0 && (unit.getTarget() == null && unit.getOrderTarget() == null) || (targ != null && unit.getTarget() != null && unit.getTarget().getID() != targ.getID() && unit.getOrderTarget() != null && unit.getOrderTarget().getID() != targ.getID())) {
					unit.rightClick(targ);
				}
				else if (unit.isIdle()) unit.move(medianpos);
			}


			else if (unit.getTargetPosition() != msquad.goal || unit
					.isIdle()) { // Otherwise, if not moving towards the msquad.goal...
				if (unit.getTilePosition().getDistance(msquad.goal) > 4) {
					unit.attackMove(msquad.goal);
				}

			} 
		}
	}


	/*
			Set<ROUnit> close_enemies = msquad.everyNearbyGroundUnits();
			Set<EnemyUnit> filteredEnemies = doFilter(close_enemies);
			Map<Unit,EnemyUnit> hitmap = TargetSelectors.getTarget_ranged_simple(myVultures, filteredEnemies);
			if (hitmap != null){
				for (Unit vulture : myVultures){
					if (hitmap.containsKey(vulture) && hitmap.get(vulture) != null){
						vulture.attackUnit(hitmap.get(vulture).unit);
					}
					else {
//						Position ebayGoal = msquad.master.pleaseEbayHere;
//						if (vulture.getPosition().getDistance(msquad.getAverage()) < 6*32 && ebayGoal != null){
//							vulture.attackMove(ebayGoal);
//						}
//						else {
							vulture.attackMove(msquad.getAverage());
//						}
					}
				}
			} */






private Set<EnemyUnit> doFilter(Set<ROUnit> close_enemies) {
	Set<EnemyUnit> ret = new HashSet<EnemyUnit>();
	for (ROUnit rou : close_enemies){
		Position p = rou.isVisible() ? rou.getPosition() : rou.getLastKnownPosition();
		double dist = UnitUtils.getClosestDistance(p, msquad.tank_squad.myTanks);
		if (dist < 6*32 || rou.getGroundRange() <= dist){
			ret.add(new EnemyUnit(rou));
		}
	}
	return ret;
}

public void moveTo(Position p) {
	for (Vulture vulture : myVultures){
		vulture.unit.attackMove(p);
	}
}

//poop when you are alone (no danger of blowing up friends) and 
private boolean shouldPoop(Unit vulture, ROUnit closestEnemy){
	if (closestEnemy == null) return false;
	if (!mGame.self().hasResearched(TechType.SPIDER_MINES)) return false;
	int frameNum = Game.getInstance().getFrameCount() % 1;
	Position p = vulture.getPosition();
	msquad.myUnits.remove(vulture);
	double dist_friend = UnitUtils.getClosestDistance(p, msquad.myUnits);
	msquad.myUnits.add(vulture);

	for (BaseLocation bl : Bwta.getInstance().getBaseLocations()) {
		if (bl.getPosition().getDistance(vulture.getPosition()) < 600)
			return false;
	}

	Position p2 = closestEnemy.isVisible() ? closestEnemy.getPosition() : closestEnemy.getLastKnownPosition();
	double dist_enemy = vulture.getPosition().getDistance(p2);

	return (frameNum == 0 && dist_friend > 120 && dist_enemy < 280);
}

public int getVPriority(ROUnit u, Unit me, boolean harass) { // Priorities for vults
	int bonus = 0;
	bonus += 1.0/(u.getHitPoints()+2);
	UnitType t = u.getType();
	if (harass) {
		if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE
				|| t == UnitType.PROTOSS_PROBE)
			return 1;
		return 0 + bonus;
	}
	if (u.isInRange(me))
		bonus += 0.5;

	if (t == UnitType.PROTOSS_INTERCEPTOR)
		return -10;

	if (t == UnitType.ZERG_SUNKEN_COLONY
			|| t == UnitType.PROTOSS_PHOTON_CANNON
			|| t == UnitType.TERRAN_BUNKER
			|| t == UnitType.TERRAN_MISSILE_TURRET)
		return 1 + bonus;
	if (t.isFlyer()) {
		return -10;
	}
	if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE
			|| t == UnitType.PROTOSS_PROBE)
		return 2;

	if (t == UnitType.PROTOSS_ZEALOT)
		return 8;

	if (t == UnitType.PROTOSS_HIGH_TEMPLAR)
		return 10;

	if (t == UnitType.PROTOSS_DRAGOON)
		return 4;

	if (u.canAttack(me))
		return 4 + bonus;
	if (t.canAttack() || t.isSpellcaster())
		return 2 + bonus;
	if (t.isBuilding())
		return 1;
	return 0 + bonus;
}


}



