//TileTracker, get a set of dangerous barriar tiles to some goal.
package undermind.micropacket;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;

import edu.berkeley.nlp.starcraft.util.Utils;
import edu.berkeley.nlp.starcraft.util.Vector;

public class TileTracker {
	public Map<TilePosition,Integer> barrierTimeStamp = new HashMap<TilePosition,Integer>();
	
	public Set<TilePosition> getBarrierTiles(TilePosition goal, Set<Unit> myMen){
        HashSet<TilePosition> barrier_tps = new HashSet<TilePosition>();
        if (goal == null || myMen.size() == 0) return barrier_tps;
        Queue<TilePosition> q = new LinkedList<TilePosition>();
        HashSet<TilePosition> seen = new HashSet<TilePosition>();
        for (Unit u : myMen){
        	q.add(new TilePosition(u.getPosition()));
        	seen.add(new TilePosition(u.getPosition()));
        }
        while(!q.isEmpty()){
//        	drawTiles(q);
        	TilePosition tp = q.poll();
        	updateBarrierTile(tp);
        	if (shouldAddToBarrier(tp,goal,myMen,barrier_tps)){
        		barrier_tps.add(tp);
        	} 	
        	for(TilePosition succ : Arrays.asList(tp.add(0, 1),tp.add(1, 0),tp.add(0, -1),tp.add(-1, 0))){
        		///if(!tps.contains(succ) && !q.contains(succ) && b.getRegion().contains(succ)){
        		if(shouldContinueExplore(succ,goal,myMen,seen)){
        			q.add(succ);
        			seen.add(succ);
        		}
        	}
        }
        return barrier_tps;
	}

	private boolean shouldContinueExplore(TilePosition tp, TilePosition goal, Set<Unit> myMen, Set<TilePosition> seen) {
		if (seen.contains(tp)) return false;
		for (Unit tank : myMen){
			double sightrange = tank.getType().sightRange();
			Position my_pos = tank.getPosition();
			Position tp_pos = new Position(tp);
			Position goal_pos = new Position(goal);
			if (my_pos.getDistance(tp_pos) <= sightrange * 1.5){
				return true;
			}
		}
		return false;
	}

	private boolean shouldAddToBarrier(TilePosition tp, TilePosition goal, Set<Unit> myMen, Set<TilePosition> seen) {
		if (seen.contains(tp)) return false;
		Game g = Game.getInstance();
		for (Unit tank : myMen){
			double sightrange = tank.getType().sightRange();
			Position my_pos = tank.getPosition();
			Position tp_pos = new Position(tp);
			Position goal_pos = new Position(goal);
			
			boolean onpath = false;
			Vector my_to_tp = new Vector(my_pos, tp_pos).normalize();
			Vector goal_to_tp = new Vector(goal_pos, tp_pos).normalize();
			if (my_to_tp.dot(goal_to_tp) < -0.6){
				onpath = true;
			}
			boolean near_sight = tp_pos.getDistance(my_pos) <= 1.3 * sightrange;
			if (!g.isVisible(tp) && onpath && near_sight && Utils.isWalkable(tp)){
				return true;
			}
		}
		return false;
	}
	
	public void drawTiles(Collection<TilePosition> stuff){
		/*for (TilePosition tp : stuff){
			Game.getInstance().drawCircleMap(new Position(tp), 2, Color.ORANGE, false);
		}*/
	}
	
	public void updateBarrierTile(TilePosition tp){
		//if it is an invisible tile, and not tracked, track it
		if (!Game.getInstance().isVisible(tp) && !barrierTimeStamp.containsKey(tp)){
			barrierTimeStamp.put(tp, 0);
		}
		//if it is visible, and we tracked it, stamp the time
		if (Game.getInstance().isVisible(tp) && barrierTimeStamp.containsKey(tp)){
			barrierTimeStamp.remove(tp);
			barrierTimeStamp.put(tp,Game.getInstance().getFrameCount());
		}
	}
	
	//you really should only call this with the CURRENT(recently computed) barrierTiles. 
	//any other argument will likely bug
	public TilePosition getOldest(Set<TilePosition> barriers){
		//drawStamps();
		if (barrierTimeStamp.size() > 300) cleanUp();
		TilePosition ret = null;
		int frameNum = Integer.MAX_VALUE;
		for (TilePosition tp : barriers){
			int lastFrame = getTime(tp);
			if (lastFrame < frameNum){
				frameNum = lastFrame;
				ret = tp;
			}
		}
		return ret;
	}
	
	
	
	public void drawStamps(){
		for (TilePosition tp : barrierTimeStamp.keySet()){
			Game.getInstance().drawCircleMap(new Position(tp), 1, Color.ORANGE, true);
		}
	}

	private void cleanUp() {
		Set<TilePosition> toRemove = new HashSet<TilePosition>();
		for (TilePosition tp : barrierTimeStamp.keySet()){
			if (barrierTimeStamp.get(tp) < Game.getInstance().getFrameCount() - 300){
				toRemove.add(tp);
			}
		}
		for (TilePosition tp : toRemove){
			barrierTimeStamp.remove(tp);
		}
	}
	
	public Map<Unit,HashSet<TilePosition>> tank_to_tile_map(Set<TilePosition> tiles, Set<Unit> tanks){
		Map<Unit,HashSet<TilePosition>> ret = new HashMap<Unit,HashSet<TilePosition>>();
		for (Unit tank : tanks){
			ret.put(tank, new HashSet<TilePosition>());
			for (TilePosition tp : tiles){
				double sightrange = tank.getType().sightRange();
				Position tp_pos = new Position(tp);
				Position tank_pos = tank.getPosition();
				if (tp_pos.getDistance(tank_pos) <= sightrange * 1.3){
					//Game.getInstance().drawLineMap(tp_pos, tank_pos, Color.ORANGE);
					ret.get(tank).add(tp);
				}
			}
		}
		return ret;
	}
	
	public boolean areTilesSafe(Unit tank,  Map<Unit,HashSet<TilePosition>> tank_to_tile_map, int slack){
		HashSet<TilePosition> tiles = tank_to_tile_map.get(tank);
		if (tiles.size() == 0) return true;
		//if any point is not safe (stale), we are not safe
		for (TilePosition tp : tiles){
			if (barrierTimeStamp.containsKey(tp)){
				if (Game.getInstance().getFrameCount() - barrierTimeStamp.get(tp)> slack) return false;
			}
		}
		//all points are fresh
		return true;
	}
	
	public int getTime(TilePosition tp){
		if (barrierTimeStamp.containsKey(tp)){
			return barrierTimeStamp.get(tp);
		}
		else {
			barrierTimeStamp.put(tp, 0);
			return 0;
		}
	}
}
