package undermind.micropacket;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.util.UnitUtils;

public class TargetSelectionSandBox implements Cerebrate{
	
	Player me = Game.getInstance().self();
	Set<Unit> myMen = new HashSet<Unit>();
	Set<EnemyUnit> theirMen = new HashSet<EnemyUnit>();

	@Override
	public void onFrame() {
		//calculate targetMap
		Map<Unit,EnemyUnit> target_map = TargetSelectors.getTarget_ranged_simple(myMen, theirMen);
		for (Unit myMan : myMen){
			EnemyUnit target = target_map.get(myMan);
			if (target != null){
				myMan.attack(target.getUnit());
			}
		}
	}

	@Override
	public void onUnitShow(ROUnit unit) {
		if (unit.getPlayer() == me && unit.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
			Unit marine = UnitUtils.assumeControl(unit);
			myMen.add(marine);
		}
		if (!unit.getPlayer().equals(me)){
			theirMen.add(new EnemyUnit(unit));
		}
	}
	
	@Override
	public void onUnitDestroy(ROUnit unit) {
		if (unit.getPlayer() == me && unit.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
			myMen.remove(unit);
		}
		if (!unit.getPlayer().equals(me)){
			theirMen.remove(unit);
		}
	}


	@Override
	public void onEnd(boolean isWinnerFlag) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onSendText(String text) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onReceiveText(Player player, String text) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onPlayerLeft(Player player) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onNukeDetect(Position position) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitCreate(ROUnit unit) {
		// TODO Auto-generated method stub
	}
	
	@Override
	public void onUnitHide(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onStart() {
	}
	

	
	@Override
	public void onUnitMorph(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitRenegade(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onDroppedConnection() {
		// TODO Auto-generated method stub
		
	}

}
