package undermind.micropacket;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.util.UnitUtils;

public class TankvsTank implements Cerebrate{

	Player me = Game.getInstance().self();
	Set<Unit> myMen = new HashSet<Unit>();
	Set<ROUnit> theirMen = new HashSet<ROUnit>();
	TileTracker tile_tracker = new TileTracker();
	Position goal;

	@Override
	public void onFrame() {
		goal = UnitUtils.avePos(theirMen);
		Set<TilePosition> barrier = tile_tracker.getBarrierTiles(new TilePosition(goal), myMen);
		tile_tracker.drawTiles(barrier);
		TilePosition oldest = tile_tracker.getOldest(barrier);
		if (oldest != null){
			Game.getInstance().drawCircleMap(new Position(oldest), 3, Color.RED, true);
		}
		int oldest_time = 0;
		if (oldest != null){
			oldest_time = tile_tracker.barrierTimeStamp.get(oldest);
		}
		Map<Unit, HashSet<TilePosition>> tank_to_tile_map = tile_tracker.tank_to_tile_map(barrier, myMen);
		//calculate targetMap
		for (ROUnit enemy : theirMen){
			Game.getInstance().drawCircleMap(enemy.getPosition(), enemy.getGroundRange(), Color.RED, false);
			Game.getInstance().drawCircleMap(enemy.getPosition(), enemy.getType().sightRange(), Color.BLUE, false);
		}
		
		for (Unit myMan : myMen){
			Game.getInstance().drawCircleMap(myMan.getPosition(), 2, Color.GREEN, true);
			drawBox(myMan);
			Game.getInstance().drawCircleMap(myMan.getPosition(), myMan.getGroundRange(), Color.GREEN, false);
		}
		
		for (Unit tank : myMen){
			if (shouldSiege(tank)){
				Game.getInstance().drawTextMap(tank.getPosition(), "1");
				siegeUp(tank);
			} 
//			else {
//				if (tile_tracker.areTilesSafe(tank, tank_to_tile_map, 200)){
//					Game.getInstance().drawTextMap(tank.getPosition(), "2");
//					unsiege_and_forward(tank);
//				} else {
//					Game.getInstance().drawTextMap(tank.getPosition(), "3" + (Game.getInstance().getFrameCount()-oldest_time));
//					siegeUp(tank);
//				}
//			}
		}
	}

	boolean shouldSiege(Unit tank){
		for (ROUnit enemy : theirMen){
			double hit_radius = enemy.getType().diagonalLength();
			if (tank.getDistance(enemy.getPosition()) <= 12*32+hit_radius){
				return true;
			}
		}
		return false;
	}
	@Override
	public void onUnitShow(ROUnit unit) {
		if (unit.getPlayer() == me && unit.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
			Unit marine = UnitUtils.assumeControl(unit);
			myMen.add(marine);
		}
		if (unit.getPlayer() == me && unit.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) {
			Unit marine = UnitUtils.assumeControl(unit);
			myMen.add(marine);
		}
		if (!unit.getPlayer().equals(me)){
			theirMen.add(unit);
		}
	}
	
	@Override
	public void onUnitDestroy(ROUnit unit) {
		if (unit.getPlayer() == me) {
			myMen.remove(unit);
		}
		if (!unit.getPlayer().equals(me)){
			theirMen.remove(unit);
		}
	}


	@Override
	public void onEnd(boolean isWinnerFlag) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onSendText(String text) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onReceiveText(Player player, String text) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onPlayerLeft(Player player) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onNukeDetect(Position position) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitCreate(ROUnit unit) {
		// TODO Auto-generated method stub
	}
	
	@Override
	public void onUnitHide(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onStart() {
	}
	

	
	@Override
	public void onUnitMorph(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitRenegade(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onDroppedConnection() {
		// TODO Auto-generated method stub
		
	}
	
	private void unsiege_and_forward(Unit tank) {
		if (tank.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)){
			siegeDown(tank);
		} else {
			tank.attackMove(goal);
		}
	}
	
	private int get_rank(Unit tank, ArrayList<Unit> tank_rank) {
		for (int i = 0; i < tank_rank.size(); i++){
			if (tank == tank_rank.get(i)) {
				Game.getInstance().drawTextMap(tank.getPosition(), ""+i);
				return i;
			}
		}
		return 0;
	}
	private void siegeUp(Unit u){
		if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)){
			u.useTech(TechType.TANK_SIEGE_MODE);
		}
	}
	private void siegeDown(Unit u){
		if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)){
			u.useTech(TechType.TANK_SIEGE_MODE);
		}
	}
	
	private void drawBox(Unit u){
		Position p = u.getPosition();
		Game.getInstance().drawBoxMap(p.x()-16, p.y()-16, p.x()+16, p.y()+16, Color.WHITE, false);
	}

}